/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.authn;

import com.duosecurity.duoweb.DuoWeb;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Cache;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccount;
import org.apereo.cas.adaptors.duo.authn.BaseDuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationResult;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityCredential;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.configuration.model.support.mfa.DuoSecurityMultifactorAuthenticationProperties;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.http.HttpMessage;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="6.4.0")
public class BasicDuoSecurityAuthenticationService
extends BaseDuoSecurityAuthenticationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicDuoSecurityAuthenticationService.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private static final long serialVersionUID = -6690808348975271382L;

    public BasicDuoSecurityAuthenticationService(DuoSecurityMultifactorAuthenticationProperties duoProperties, HttpClient httpClient, List<MultifactorAuthenticationPrincipalResolver> multifactorAuthenticationPrincipalResolver, Cache<String, DuoSecurityUserAccount> userAccountCache) {
        super(duoProperties, httpClient, multifactorAuthenticationPrincipalResolver, userAccountCache);
    }

    private static String buildUrlHttpScheme(String url) {
        if (!RegexUtils.find((String)"^http(s)*://", (String)url)) {
            return "https://" + url;
        }
        return url;
    }

    @Override
    public DuoSecurityAuthenticationResult authenticateInternal(Credential creds) throws Exception {
        return this.authenticateDuoCredential(creds);
    }

    public boolean ping() {
        try {
            String duoApiHost = SpringExpressionLanguageValueResolver.getInstance().resolve(this.getProperties().getDuoApiHost());
            String url = BasicDuoSecurityAuthenticationService.buildUrlHttpScheme(duoApiHost.concat("/rest/v1/ping"));
            LOGGER.trace("Pinging Duo Security @ [{}]", (Object)url);
            HttpMessage msg = this.httpClient.sendMessageToEndPoint(new URL(url));
            if (msg != null) {
                String response = URLDecoder.decode(msg.getMessage(), StandardCharsets.UTF_8.name());
                LOGGER.debug("Received Duo ping response [{}]", (Object)response);
                JsonNode result = MAPPER.readTree(response);
                if (result.has("response") && result.has("stat") && result.get("response").asText().equalsIgnoreCase("pong") && result.get("stat").asText().equalsIgnoreCase("OK")) {
                    return true;
                }
                LOGGER.warn("Could not reach/ping Duo. Response returned is [{}]", (Object)result);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Pinging Duo has failed with error: [{}]", (Object)e.getMessage(), (Object)e);
        }
        return false;
    }

    public Optional<String> signRequestToken(String uid) {
        SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
        return Optional.of(DuoWeb.signRequest(resolver.resolve(this.properties.getDuoIntegrationKey()), resolver.resolve(this.properties.getDuoSecretKey()), resolver.resolve(this.properties.getDuoApplicationKey()), uid));
    }

    private DuoSecurityAuthenticationResult authenticateDuoCredential(Credential creds) throws Exception {
        String signedRequestToken = ((DuoSecurityCredential)DuoSecurityCredential.class.cast(creds)).getSignedDuoResponse();
        if (StringUtils.isBlank((CharSequence)signedRequestToken)) {
            throw new IllegalArgumentException("No signed request token was passed to verify");
        }
        LOGGER.trace("Verifying duo response with signed request token '[{}]'", (Object)signedRequestToken);
        SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
        String authUserId = DuoWeb.verifyResponse(resolver.resolve(this.properties.getDuoIntegrationKey()), resolver.resolve(this.properties.getDuoSecretKey()), resolver.resolve(this.properties.getDuoApplicationKey()), signedRequestToken);
        return DuoSecurityAuthenticationResult.builder().success(true).username(authUserId).build();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicDuoSecurityAuthenticationService)) {
            return false;
        }
        BasicDuoSecurityAuthenticationService other = (BasicDuoSecurityAuthenticationService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BasicDuoSecurityAuthenticationService;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

