/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.discovery.webfinger;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.discovery.webfinger.OidcWebFingerUserInfoRepository;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class OidcWebFingerDiscoveryService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcWebFingerDiscoveryService.class);
    private static final Pattern RESOURCE_NORMALIZED_PATTERN = Pattern.compile("^((https|acct|http|mailto|tel|device):(//)?)?((([^@]+)@)?(([^\\?#:/]+)(:(\\d*))?))([^\\?#]+)?(\\?([^#]+))?(#(.*))?$");
    private static final int PATTERN_GROUP_INDEX_SCHEME = 2;
    private static final int PATTERN_GROUP_INDEX_USERINFO = 6;
    private static final int PATTERN_GROUP_INDEX_HOST = 8;
    private static final int PATTERN_GROUP_INDEX_PORT = 10;
    private static final int PATTERN_GROUP_INDEX_PATH = 11;
    private static final int PATTERN_GROUP_INDEX_QUERY = 13;
    private static final int PATTERN_GROUP_INDEX_FRAGMENT = 15;
    private final OidcWebFingerUserInfoRepository userInfoRepository;
    private final OidcServerDiscoverySettings discovery;

    public ResponseEntity<Map> handleWebFingerDiscoveryRequest(String resource, String rel) {
        String issuer;
        if (StringUtils.isNotBlank((CharSequence)rel) && !"http://openid.net/specs/connect/1.0/issuer".equalsIgnoreCase(rel)) {
            LOGGER.warn("Handling discovery request for a non-standard OIDC relation [{}]", (Object)rel);
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)resource, (CharSequence)(issuer = this.discovery.getIssuer()))) {
            UriComponents resourceUri = this.normalize(resource);
            if (resourceUri == null) {
                LOGGER.error("Unable to parse and normalize resource: [{}]", (Object)resource);
                return this.buildNotFoundResponseEntity("Unable to normalize provided resource");
            }
            UriComponents issuerUri = this.normalize(issuer);
            if (!"acct".equals(resourceUri.getScheme())) {
                LOGGER.error("Unable to accept resource scheme: [{}]", (Object)resourceUri.toUriString());
                return this.buildNotFoundResponseEntity("Unable to recognize/accept resource scheme " + resourceUri.getScheme());
            }
            Map<String, Object> user = this.userInfoRepository.findByEmailAddress(resourceUri.getUserInfo() + "@" + resourceUri.getHost());
            if (user.isEmpty()) {
                user = this.userInfoRepository.findByUsername(resourceUri.getUserInfo());
            }
            if (user.isEmpty()) {
                LOGGER.info("User/Resource not found: [{}]", (Object)resource);
                return this.buildNotFoundResponseEntity("Unable to find resource");
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)issuerUri.getHost(), (CharSequence)resourceUri.getHost())) {
                LOGGER.info("Host mismatch for resource [{}]: expected [{}] and yet received [{}]", new Object[]{resource, issuerUri.getHost(), resourceUri.getHost()});
                return this.buildNotFoundResponseEntity("Unable to match resource host");
            }
        }
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put("subject", resource);
        ArrayList<Map> links = new ArrayList<Map>(0);
        links.add(CollectionUtils.wrap((String)"rel", (Object)"http://openid.net/specs/connect/1.0/issuer", (String)"href", (Object)issuer));
        body.put("links", links);
        return new ResponseEntity(body, HttpStatus.OK);
    }

    protected ResponseEntity buildNotFoundResponseEntity(String message) {
        return new ResponseEntity((Object)CollectionUtils.wrap((String)"message", (Object)message), HttpStatus.NOT_FOUND);
    }

    protected UriComponents normalize(String resource) {
        UriComponentsBuilder builder = UriComponentsBuilder.newInstance();
        Matcher matcher = RESOURCE_NORMALIZED_PATTERN.matcher(resource);
        if (!matcher.matches()) {
            LOGGER.error("Unable to match the resource [{}] against pattern [{}] for normalization", (Object)resource, (Object)matcher.pattern().pattern());
            return null;
        }
        builder.scheme(matcher.group(2));
        builder.userInfo(matcher.group(6));
        builder.host(matcher.group(8));
        String port = matcher.group(10);
        if (!StringUtils.isBlank((CharSequence)port)) {
            builder.port(Integer.parseInt(port));
        }
        builder.path(matcher.group(11));
        builder.query(matcher.group(13));
        builder.fragment(matcher.group(15));
        UriComponents currentBuilder = builder.build();
        if (StringUtils.isBlank((CharSequence)currentBuilder.getScheme())) {
            if (StringUtils.isNotBlank((CharSequence)currentBuilder.getUserInfo()) && StringUtils.isBlank((CharSequence)currentBuilder.getPath()) && StringUtils.isBlank((CharSequence)currentBuilder.getQuery()) && currentBuilder.getPort() < 0) {
                builder.scheme("acct");
            } else {
                builder.scheme("https");
            }
        }
        builder.fragment(null);
        return builder.build();
    }

    @Generated
    public OidcWebFingerDiscoveryService(OidcWebFingerUserInfoRepository userInfoRepository, OidcServerDiscoverySettings discovery) {
        this.userInfoRepository = userInfoRepository;
        this.discovery = discovery;
    }

    @Generated
    public OidcWebFingerUserInfoRepository getUserInfoRepository() {
        return this.userInfoRepository;
    }

    @Generated
    public OidcServerDiscoverySettings getDiscovery() {
        return this.discovery;
    }
}

