/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.authn;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.dpop.JWKThumbprintConfirmation;
import com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPIssuer;
import com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPTokenRequestVerifier;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.net.URI;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;

public class OidcDPoPAuthenticator
implements Authenticator {
    protected final OidcServerDiscoverySettings oidcServerDiscoverySettings;
    protected final ServicesManager servicesManager;
    protected final AuditableExecution registeredServiceAccessStrategyEnforcer;
    protected final CasConfigurationProperties casProperties;

    public void validate(Credentials credentials, WebContext webContext, SessionStore sessionStore) {
        webContext.getRequestHeader("DPoP").ifPresent(proof -> FunctionUtils.doAndHandle(u -> this.validateAccessToken(credentials, webContext, (String)proof)));
    }

    protected void validateAccessToken(Credentials credentials, WebContext webContext, String dPopProof) throws Exception {
        String clientId = (String)webContext.getRequestParameter("client_id").orElseThrow();
        OidcRegisteredService registeredService = (OidcRegisteredService)OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)clientId);
        AuditableContext audit = AuditableContext.builder().registeredService((RegisteredService)registeredService).build();
        AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
        accessResult.throwExceptionIfNeeded();
        JWKThumbprintConfirmation confirmation = this.verifyProofOfPossession(webContext, dPopProof, clientId);
        this.buildUserProfile(credentials, dPopProof, clientId, confirmation);
    }

    protected JWKThumbprintConfirmation verifyProofOfPossession(WebContext webContext, String dPopProof, String clientId) throws Exception {
        Set algorithms = this.oidcServerDiscoverySettings.getDPopSigningAlgValuesSupported().stream().map(JWSAlgorithm::parse).collect(Collectors.toSet());
        long seconds = Beans.newDuration((String)this.casProperties.getAuthn().getOidc().getCore().getSkew()).toSeconds();
        URI endpointURI = new URI(webContext.getRequestURL());
        DPoPTokenRequestVerifier verifier = new DPoPTokenRequestVerifier(algorithms, endpointURI, seconds, null);
        SignedJWT signedProof = this.getSignedProofOfPosessionJwt(dPopProof);
        DPoPIssuer dPopIssuer = new DPoPIssuer(new ClientID(clientId));
        return verifier.verify(dPopIssuer, signedProof);
    }

    protected void buildUserProfile(Credentials credentials, String dPopProof, String clientId, JWKThumbprintConfirmation confirmation) throws Exception {
        SignedJWT signedProof = this.getSignedProofOfPosessionJwt(dPopProof);
        CommonProfile userProfile = new CommonProfile(true);
        userProfile.setId(clientId);
        userProfile.addAttributes(signedProof.getJWTClaimsSet().getClaims());
        userProfile.addAttribute("DPoP", (Object)dPopProof);
        userProfile.addAttribute("DPoPConfirmation", (Object)confirmation.getValue().toString());
        credentials.setUserProfile((UserProfile)userProfile);
    }

    protected SignedJWT getSignedProofOfPosessionJwt(String dPopProof) throws Exception {
        return SignedJWT.parse((String)dPopProof);
    }

    @Generated
    public OidcDPoPAuthenticator(OidcServerDiscoverySettings oidcServerDiscoverySettings, ServicesManager servicesManager, AuditableExecution registeredServiceAccessStrategyEnforcer, CasConfigurationProperties casProperties) {
        this.oidcServerDiscoverySettings = oidcServerDiscoverySettings;
        this.servicesManager = servicesManager;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
        this.casProperties = casProperties;
    }
}

