/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.time.Duration;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public abstract class AbstractAjaxTimerBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private java.time.Duration updateInterval;
    private boolean stopped = false;
    private String timerId;

    @Deprecated
    public AbstractAjaxTimerBehavior(Duration updateInterval) {
        this.setUpdateInterval(updateInterval.toJavaDuration());
    }

    public AbstractAjaxTimerBehavior(java.time.Duration updateInterval) {
        this.setUpdateInterval(updateInterval);
    }

    protected final void setUpdateInterval(java.time.Duration updateInterval) {
        if (updateInterval == null || updateInterval.toMillis() <= 0L) {
            throw new IllegalArgumentException("Invalid update interval");
        }
        this.updateInterval = updateInterval;
    }

    public final java.time.Duration getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        if (!this.isStopped()) {
            this.setTimeout(response);
        }
    }

    @Override
    protected final void respond(AjaxRequestTarget target) {
        this.timerId = null;
        if (this.shouldTrigger()) {
            this.onTimer(target);
            if (this.shouldTrigger()) {
                this.setTimeout(target.getHeaderResponse());
            }
        }
    }

    protected boolean shouldTrigger() {
        return !this.isStopped() && this.isEnabled(this.getComponent()) && (this.getComponent() instanceof Page || this.getComponent().findParent(Page.class) != null);
    }

    protected abstract void onTimer(AjaxRequestTarget var1);

    public final boolean isStopped() {
        return this.stopped;
    }

    public final void restart(IPartialPageRequestHandler target) {
        this.stopped = false;
        if (target != null) {
            this.setTimeout(target.getHeaderResponse());
        }
    }

    protected String getTimerId() {
        Component component = this.getComponent();
        return component.getMarkupId() + "." + component.getBehaviorId(this);
    }

    private void setTimeout(IHeaderResponse headerResponse) {
        CharSequence js = this.getCallbackScript();
        this.timerId = this.getTimerId();
        headerResponse.render(OnLoadHeaderItem.forScript("Wicket.Timer.set('" + this.timerId + "', function(){" + js + "}, " + this.updateInterval.toMillis() + ");"));
    }

    private void clearTimeout(IHeaderResponse headerResponse) {
        if (this.timerId != null) {
            headerResponse.render(OnLoadHeaderItem.forScript("Wicket.Timer.clear('" + this.timerId + "');"));
            this.timerId = null;
        }
    }

    public final void stop(IPartialPageRequestHandler target) {
        if (!this.stopped) {
            this.stopped = true;
            if (target != null) {
                this.clearTimeout(target.getHeaderResponse());
            }
        }
    }

    @Override
    public void onRemove(Component component) {
        component.getRequestCycle().find(IPartialPageRequestHandler.class).ifPresent(target -> this.clearTimeout(target.getHeaderResponse()));
    }

    @Override
    protected void onUnbind() {
        Component component = this.getComponent();
        component.getRequestCycle().find(IPartialPageRequestHandler.class).ifPresent(target -> this.clearTimeout(target.getHeaderResponse()));
    }

    public static AbstractAjaxTimerBehavior onTimer(java.time.Duration interval, final SerializableConsumer<AjaxRequestTarget> onTimer) {
        Args.notNull(onTimer, (String)"onTimer");
        return new AbstractAjaxTimerBehavior(interval){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onTimer(AjaxRequestTarget target) {
                onTimer.accept((Object)target);
            }
        };
    }
}

