/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.delete;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricProcessInstanceQuery;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.delete.BatchDeleteProcessConfig;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class ComputeDeleteHistoricProcessInstanceIdsJobHandler
implements JobHandler {
    public static final String TYPE = "compute-delete-historic-process-ids";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        ProcessEngineConfigurationImpl engineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        BatchService batchService = engineConfiguration.getBatchServiceConfiguration().getBatchService();
        BatchDeleteProcessConfig config = BatchDeleteProcessConfig.create(configuration, engineConfiguration);
        BatchPart batchPart = config.getBatchPart();
        Batch batch = config.getBatch();
        boolean sequentialExecution = config.isSequentialExecution();
        if (config.hasError()) {
            this.failBatchPart(engineConfiguration, batchService, batchPart, batch, config.getError(), sequentialExecution);
            return;
        }
        if ("stopped".equals(batch.getStatus())) {
            batchService.completeBatchPart(batchPart.getId(), "stopped", null);
            return;
        }
        int batchSize = config.getBatchSize();
        int batchPartNumber = Integer.parseInt(batchPart.getSearchKey());
        int firstResult = batchPartNumber * batchSize;
        HistoricProcessInstanceQuery query = config.getQuery();
        List processInstances = query.listPage(firstResult, batchSize);
        ObjectNode resultNode = engineConfiguration.getObjectMapper().createObjectNode();
        ArrayNode idsToDelete = resultNode.putArray("processInstanceIdsToDelete");
        for (HistoricProcessInstance processInstance : processInstances) {
            idsToDelete.add(processInstance.getId());
        }
        BatchPart batchPartForDelete = engineConfiguration.getManagementService().createBatchPartBuilder(batch).type("deleteProcess").searchKey(batchPart.getId()).searchKey2(batchPart.getSearchKey()).status("waiting").create();
        resultNode.put("deleteBatchPart", batchPartForDelete.getId());
        if (sequentialExecution) {
            resultNode.put("sequential", true);
            List nextComputeParts = engineConfiguration.getManagementService().createBatchPartQuery().batchId(batch.getId()).status("waiting").type("computeDeleteProcessInstanceIds").listPage(0, 2);
            boolean startDeletion = !"failed".equals(batch.getStatus());
            for (BatchPart nextComputePart : nextComputeParts) {
                if (nextComputePart.getId().equals(batchPart.getId())) continue;
                startDeletion = false;
                JobService jobService = engineConfiguration.getJobServiceConfiguration().getJobService();
                JobEntity nextComputeJob = jobService.createJob();
                nextComputeJob.setJobHandlerType(TYPE);
                nextComputeJob.setJobHandlerConfiguration(nextComputePart.getId());
                jobService.createAsyncJob(nextComputeJob, false);
                jobService.scheduleAsyncJob(nextComputeJob);
                break;
            }
            if (startDeletion) {
                JobService jobService = engineConfiguration.getJobServiceConfiguration().getJobService();
                JobEntity nextDeleteJob = jobService.createJob();
                nextDeleteJob.setJobHandlerType("delete-historic-process-ids");
                nextDeleteJob.setJobHandlerConfiguration(batchPartForDelete.getId());
                jobService.createAsyncJob(nextDeleteJob, false);
                jobService.scheduleAsyncJob(nextDeleteJob);
            }
        }
        batchService.completeBatchPart(batchPart.getId(), "completed", resultNode.toString());
    }

    protected void failBatchPart(ProcessEngineConfigurationImpl engineConfiguration, BatchService batchService, BatchPart batchPart, Batch batch, String resultJson, boolean sequentialExecution) {
        batchService.completeBatchPart(batchPart.getId(), "failed", resultJson);
        if (sequentialExecution) {
            this.completeBatch(batch, "failed", engineConfiguration);
        }
    }

    protected void completeBatch(Batch batch, String status, ProcessEngineConfigurationImpl engineConfiguration) {
        engineConfiguration.getBatchServiceConfiguration().getBatchService().completeBatch(batch.getId(), status);
    }
}

