/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.opensaml.core.Version;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.security.saml2.provider.service.authentication.logout.OpenSamlLogoutRequestValidator;
import org.springframework.security.saml2.provider.service.authentication.logout.OpenSamlLogoutResponseValidator;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.authentication.logout.HttpSessionLogoutRequestRepository;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

final class Saml2LogoutBeanDefinitionParserUtils {
    private static final String OPEN_SAML_4_VERSION = "4";
    private static final String ATT_RELYING_PARTY_REGISTRATION_REPOSITORY_REF = "relying-party-registration-repository-ref";
    private static final String ATT_LOGOUT_REQUEST_VALIDATOR_REF = "logout-request-validator-ref";
    private static final String ATT_LOGOUT_REQUEST_REPOSITORY_REF = "logout-request-repository-ref";
    private static final String ATT_LOGOUT_REQUEST_RESOLVER_REF = "logout-request-resolver-ref";
    private static final String ATT_LOGOUT_RESPONSE_RESOLVER_REF = "logout-response-resolver-ref";
    private static final String ATT_LOGOUT_RESPONSE_VALIDATOR_REF = "logout-response-validator-ref";

    private Saml2LogoutBeanDefinitionParserUtils() {
    }

    static BeanMetadataElement getRelyingPartyRegistrationRepository(Element element) {
        String relyingPartyRegistrationRepositoryRef = element.getAttribute(ATT_RELYING_PARTY_REGISTRATION_REPOSITORY_REF);
        if (StringUtils.hasText((String)relyingPartyRegistrationRepositoryRef)) {
            return new RuntimeBeanReference(relyingPartyRegistrationRepositoryRef);
        }
        return new RuntimeBeanReference(RelyingPartyRegistrationRepository.class);
    }

    static BeanMetadataElement getLogoutResponseResolver(Element element, BeanMetadataElement registrations) {
        String logoutResponseResolver = element.getAttribute(ATT_LOGOUT_RESPONSE_RESOLVER_REF);
        if (StringUtils.hasText((String)logoutResponseResolver)) {
            return new RuntimeBeanReference(logoutResponseResolver);
        }
        if (Saml2LogoutBeanDefinitionParserUtils.version().startsWith(OPEN_SAML_4_VERSION)) {
            return BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSaml4LogoutResponseResolver").addConstructorArgValue((Object)registrations).getBeanDefinition();
        }
        return BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSamlLogoutResponseResolver").addConstructorArgValue((Object)registrations).getBeanDefinition();
    }

    static BeanMetadataElement getLogoutRequestValidator(Element element) {
        String logoutRequestValidator = element.getAttribute(ATT_LOGOUT_REQUEST_VALIDATOR_REF);
        if (StringUtils.hasText((String)logoutRequestValidator)) {
            return new RuntimeBeanReference(logoutRequestValidator);
        }
        return BeanDefinitionBuilder.rootBeanDefinition(OpenSamlLogoutRequestValidator.class).getBeanDefinition();
    }

    static BeanMetadataElement getLogoutResponseValidator(Element element) {
        String logoutResponseValidator = element.getAttribute(ATT_LOGOUT_RESPONSE_VALIDATOR_REF);
        if (StringUtils.hasText((String)logoutResponseValidator)) {
            return new RuntimeBeanReference(logoutResponseValidator);
        }
        return BeanDefinitionBuilder.rootBeanDefinition(OpenSamlLogoutResponseValidator.class).getBeanDefinition();
    }

    static BeanMetadataElement getLogoutRequestRepository(Element element) {
        String logoutRequestRepository = element.getAttribute(ATT_LOGOUT_REQUEST_REPOSITORY_REF);
        if (StringUtils.hasText((String)logoutRequestRepository)) {
            return new RuntimeBeanReference(logoutRequestRepository);
        }
        return BeanDefinitionBuilder.rootBeanDefinition(HttpSessionLogoutRequestRepository.class).getBeanDefinition();
    }

    static BeanMetadataElement getLogoutRequestResolver(Element element, BeanMetadataElement registrations) {
        String logoutRequestResolver = element.getAttribute(ATT_LOGOUT_REQUEST_RESOLVER_REF);
        if (StringUtils.hasText((String)logoutRequestResolver)) {
            return new RuntimeBeanReference(logoutRequestResolver);
        }
        if (Saml2LogoutBeanDefinitionParserUtils.version().startsWith(OPEN_SAML_4_VERSION)) {
            return BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSaml4LogoutRequestResolver").addConstructorArgValue((Object)registrations).getBeanDefinition();
        }
        return BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSamlLogoutRequestResolver").addConstructorArgValue((Object)registrations).getBeanDefinition();
    }

    static String version() {
        String version = Version.getVersion();
        if (StringUtils.hasText((String)version)) {
            return version;
        }
        boolean openSaml4ClassPresent = ClassUtils.isPresent((String)"org.opensaml.core.xml.persist.impl.PassthroughSourceStrategy", null);
        if (openSaml4ClassPresent) {
            return OPEN_SAML_4_VERSION;
        }
        throw new IllegalStateException("cannot determine OpenSAML version");
    }
}

