/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.terracotta.runnel.decoding.fields.Field;
import org.terracotta.runnel.decoding.fields.StructField;
import org.terracotta.runnel.metadata.FieldDecoder;
import org.terracotta.runnel.metadata.FieldSearcher;
import org.terracotta.runnel.utils.ReadBuffer;

public class Metadata {
    private final List<Field> fields = new ArrayList<Field>();
    private final Map<String, Field> fieldsByName = new HashMap<String, Field>();
    private volatile boolean initialized = false;
    private volatile boolean initializationFullyChecked = false;
    private final ThreadLocal<Boolean> checkingForFullInitialization = new ThreadLocal();

    public void addField(Field field) {
        if (this.initialized) {
            throw new IllegalStateException("Metadata already initialized");
        }
        this.fields.add(field);
    }

    public void init() {
        if (this.initialized) {
            throw new IllegalStateException("Metadata already initialized");
        }
        for (Field field : this.fields) {
            this.fieldsByName.put(field.name(), field);
        }
        this.initialized = true;
    }

    public FieldSearcher fieldSearcher() {
        return new FieldSearcher(this);
    }

    public void checkFullyInitialized() throws IllegalStateException {
        if (this.initializationFullyChecked || Boolean.TRUE.equals(this.checkingForFullInitialization.get())) {
            return;
        }
        if (!this.initialized) {
            throw new IllegalStateException("Metadata not yet initialized");
        }
        this.checkingForFullInitialization.set(Boolean.TRUE);
        try {
            for (Field field : this.fields) {
                if (!(field instanceof StructField)) continue;
                ((StructField)field).getMetadata().checkFullyInitialized();
            }
            this.initializationFullyChecked = true;
        }
        finally {
            this.checkingForFullInitialization.remove();
        }
    }

    public FieldDecoder fieldDecoder(ReadBuffer readBuffer) {
        return new FieldDecoder(this, readBuffer);
    }

    public Map<Integer, Field> buildFieldsByIndexMap() {
        HashMap<Integer, Field> map = new HashMap<Integer, Field>();
        for (Field field : this.fieldsByName.values()) {
            map.put(field.index(), field);
        }
        return map;
    }

    Field getFieldByName(String name) {
        return this.fieldsByName.get(name);
    }
}

