/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.decoding.fields;

import java.io.PrintStream;
import java.util.Map;
import org.terracotta.runnel.decoding.fields.AbstractField;
import org.terracotta.runnel.decoding.fields.Field;
import org.terracotta.runnel.metadata.Metadata;
import org.terracotta.runnel.utils.ReadBuffer;

public class StructField
extends AbstractField {
    private final Metadata metadata;

    public StructField(String name, int index) {
        this(name, index, new Metadata());
    }

    private StructField(String name, int index, Metadata metadata) {
        super(name, index);
        this.metadata = metadata;
    }

    public StructField alias(String name, int index) {
        return new StructField(name, index, this.metadata);
    }

    public void init() {
        this.metadata.init();
    }

    public void addField(Field field) {
        this.metadata.addField(field);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void dump(ReadBuffer parentBuffer, PrintStream out, int depth) {
        int fieldSize = parentBuffer.getVlqInt();
        out.append(" size: ").append(Integer.toString(fieldSize));
        ReadBuffer readBuffer = parentBuffer.limit(fieldSize);
        out.append(" type: ").append(this.getClass().getSimpleName());
        out.append(" name: ").append(this.name());
        Map<Integer, Field> fieldsByInteger = this.getMetadata().buildFieldsByIndexMap();
        while (!readBuffer.limitReached()) {
            out.append("\n  ");
            for (int j = 0; j < depth; ++j) {
                out.append("  ");
            }
            int index = readBuffer.getVlqInt();
            out.append(" index: ").append(Integer.toString(index));
            Field subField = fieldsByInteger.get(index);
            subField.dump(readBuffer, out, depth + 1);
        }
    }

    public void checkFullyInitialized() throws IllegalStateException {
        this.metadata.checkFullyInitialized();
    }
}

