/*
 * Decompiled with CFR 0.152.
 */
package com.tc.runtime;

import com.tc.runtime.JVMMemoryManager;
import com.tc.runtime.Jdk15MemoryUsage;
import com.tc.runtime.MemoryUsage;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TCMemoryManagerJdk15Basic
implements JVMMemoryManager {
    private static final Logger logger = LoggerFactory.getLogger(TCMemoryManagerJdk15Basic.class);
    private final MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();

    public TCMemoryManagerJdk15Basic() {
        java.lang.management.MemoryUsage heapUsage = this.memoryBean.getHeapMemoryUsage();
        if (heapUsage.getMax() <= 0L) {
            logger.warn("Please specify Max memory using -Xmx flag for Memory manager to work properly");
        }
    }

    @Override
    public boolean isMemoryPoolMonitoringSupported() {
        return false;
    }

    @Override
    public MemoryUsage getMemoryUsage() {
        java.lang.management.MemoryUsage heapUsage = this.memoryBean.getHeapMemoryUsage();
        return new Jdk15MemoryUsage(heapUsage, "VM 1.5 Heap Usage");
    }

    @Override
    public MemoryUsage getOldGenUsage() {
        throw new UnsupportedOperationException();
    }
}

