/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net;

import com.tc.process.StreamCollector;
import com.tc.util.FindbugsSuppressWarnings;
import com.tc.util.io.IOUtils;
import com.tc.util.runtime.Os;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EphemeralPorts {
    private static Range range = null;

    public static synchronized Range getRange() {
        if (range == null) {
            range = EphemeralPorts.findRange();
        }
        return range;
    }

    private static Range findRange() {
        if (Os.isLinux()) {
            return new Linux().getRange();
        }
        if (Os.isSolaris()) {
            return new SolarisAndHPUX(false).getRange();
        }
        if (Os.isMac()) {
            return new Mac().getRange();
        }
        if (Os.isWindows()) {
            return new Windows().getRange();
        }
        if (Os.isAix()) {
            return new Aix().getRange();
        }
        if (Os.isHpux()) {
            return new SolarisAndHPUX(true).getRange();
        }
        throw new AssertionError((Object)("No support for this OS: " + Os.getOsName()));
    }

    public static void main(String[] args) {
        System.err.println(EphemeralPorts.getRange());
    }

    private static class Exec {
        static final int STDOUT = 1;
        static final int STDERR = 2;
        private final String[] cmd;

        Exec(String[] cmd) {
            this.cmd = cmd;
        }

        String execute(int stream) throws IOException, InterruptedException {
            if (stream != 1 && stream != 2) {
                throw new IllegalArgumentException("bad stream: " + stream);
            }
            Process proc = Runtime.getRuntime().exec(this.cmd);
            proc.getOutputStream().close();
            StreamCollector out = new StreamCollector(proc.getInputStream());
            StreamCollector err = new StreamCollector(proc.getErrorStream());
            out.start();
            err.start();
            proc.waitFor();
            out.join();
            err.join();
            if (stream == 1) {
                return out.toString();
            }
            return err.toString();
        }
    }

    private static class Aix
    implements RangeGetter {
        private Aix() {
        }

        @Override
        public Range getRange() {
            String output;
            Exec exec = new Exec(new String[]{"/usr/sbin/no", "-a"});
            try {
                output = exec.execute(1);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Properties props = new Properties();
            try {
                props.load(new StringBufferInputStream(output));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            int low = Integer.parseInt(props.getProperty("tcp_ephemeral_low"));
            int high = Integer.parseInt(props.getProperty("tcp_ephemeral_high"));
            return new Range(low, high);
        }
    }

    private static class Linux
    implements RangeGetter {
        private static final String source = "/proc/sys/net/ipv4/ip_local_port_range";

        private Linux() {
        }

        @Override
        @FindbugsSuppressWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
        public Range getRange() {
            File src = new File(source);
            if (!src.exists() || !src.canRead()) {
                throw new RuntimeException("Cannot access /proc/sys/net/ipv4/ip_local_port_range");
            }
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(src)));
                String data = reader.readLine();
                if (data == null) {
                    throw new RuntimeException("Unexpected EOF at /proc/sys/net/ipv4/ip_local_port_range");
                }
                String[] parts = data.split("[ \\t]");
                if (parts.length != 2) {
                    throw new RuntimeException("Wrong number of tokens (" + parts.length + ") in " + data);
                }
                int low = Integer.parseInt(parts[0]);
                int high = Integer.parseInt(parts[1]);
                Range range = new Range(low, high);
                return range;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static class Mac
    implements RangeGetter {
        private Mac() {
        }

        @Override
        public Range getRange() {
            String output;
            Exec exec = new Exec(new String[]{"sysctl", "net.inet.ip.portrange"});
            try {
                output = exec.execute(1);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Properties props = new Properties();
            try {
                props.load(new StringBufferInputStream(output));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            int low = Integer.parseInt(props.getProperty("net.inet.ip.portrange.hifirst"));
            int high = Integer.parseInt(props.getProperty("net.inet.ip.portrange.hilast"));
            return new Range(low, high);
        }
    }

    private static class Windows
    implements RangeGetter {
        private Windows() {
        }

        @Override
        public Range getRange() {
            String osName = System.getProperty("os.name");
            if (osName.equalsIgnoreCase("windows xp") || osName.equalsIgnoreCase("windows 2003")) {
                return this.getLegacySettings();
            }
            return this.getNetshRange();
        }

        private Range getNetshRange() {
            int DEFAULT_LOWER = 49152;
            int DEFAULT_UPPER = 65535;
            try {
                String line;
                File netshExe = new File(new File(Os.findWindowsSystemRoot(), "system32"), "netsh.exe");
                String[] cmd = new String[]{netshExe.getAbsolutePath(), "int", "ipv4", "show", "dynamicport", "tcp"};
                Exec exec = new Exec(cmd);
                BufferedReader reader = new BufferedReader(new StringReader(exec.execute(1)));
                Pattern pattern = Pattern.compile("^.*: (\\p{XDigit}+)");
                int start = -1;
                int num = -1;
                while ((line = reader.readLine()) != null) {
                    Matcher matcher = pattern.matcher(line);
                    if (start == -1 && matcher.matches()) {
                        start = Integer.parseInt(matcher.group(1));
                        continue;
                    }
                    if (num == -1 && matcher.matches()) {
                        num = Integer.parseInt(matcher.group(1));
                        continue;
                    }
                    if (start == -1 || num == -1) continue;
                    break;
                }
                IOUtils.closeQuietly(reader);
                if (num == -1 || start == -1) {
                    throw new Exception("start: " + start + ", num = " + num);
                }
                return new Range(start, start + num - 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                return new Range(49152, 65535);
            }
        }

        private Range getLegacySettings() {
            int DEFAULT_LOWER = 1024;
            int DEFAULT_UPPER = 5000;
            try {
                File regExe;
                String sysRoot = Os.findWindowsSystemRoot();
                if (sysRoot != null && (regExe = new File(new File(sysRoot, "system32"), "reg.exe")).exists()) {
                    String[] cmd = new String[]{regExe.getAbsolutePath(), "query", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\Tcpip\\Parameters", "/v", "MaxUserPort"};
                    Exec exec = new Exec(cmd);
                    BufferedReader reader = new BufferedReader(new StringReader(exec.execute(1)));
                    Pattern pattern = Pattern.compile("^.*MaxUserPort\\s+REG_DWORD\\s+0x(\\p{XDigit}+)");
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        Matcher matcher = pattern.matcher(line);
                        if (!matcher.matches()) continue;
                        int val = Integer.parseInt(matcher.group(1), 16);
                        return new Range(1024, val);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return new Range(1024, 5000);
        }
    }

    private static class SolarisAndHPUX
    implements RangeGetter {
        private final String ndd;

        public SolarisAndHPUX(boolean isHpux) {
            this.ndd = isHpux ? "/usr/bin/ndd" : "/usr/sbin/ndd";
        }

        @Override
        public Range getRange() {
            String upper;
            String lower;
            Exec exec = new Exec(new String[]{this.ndd, "/dev/tcp", "tcp_smallest_anon_port"});
            try {
                lower = exec.execute(1);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            exec = new Exec(new String[]{this.ndd, "/dev/tcp", "tcp_largest_anon_port"});
            try {
                upper = exec.execute(1);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            int low = Integer.parseInt(lower.replaceAll("\n", ""));
            int high = Integer.parseInt(upper.replaceAll("\n", ""));
            return new Range(low, high);
        }
    }

    private static interface RangeGetter {
        public Range getRange();
    }

    public static class Range {
        private final int upper;
        private final int lower;

        private Range(int lower, int upper) {
            this.lower = lower;
            this.upper = upper;
        }

        public int getUpper() {
            return this.upper;
        }

        public int getLower() {
            return this.lower;
        }

        public boolean isInRange(int num) {
            return num >= this.lower && num <= this.upper;
        }

        public String toString() {
            return this.lower + " " + this.upper;
        }
    }
}

