/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.task;

import org.apache.syncope.common.lib.to.MacroTaskTO;
import org.apache.syncope.common.lib.to.NotificationTaskTO;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.entity.task.MacroTask;
import org.apache.syncope.core.persistence.api.entity.task.NotificationTask;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtils;
import org.apache.syncope.core.persistence.jpa.entity.task.AbstractTask;
import org.apache.syncope.core.persistence.jpa.entity.task.AbstractTaskExec;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAMacroTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAMacroTaskExec;
import org.apache.syncope.core.persistence.jpa.entity.task.JPANotificationTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPANotificationTaskExec;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPropagationTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPropagationTaskExec;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPullTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPullTaskExec;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPushTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPushTaskExec;
import org.apache.syncope.core.persistence.jpa.entity.task.JPASchedTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPASchedTaskExec;
import org.apache.syncope.core.spring.security.SecureRandomUtils;

public final class JPATaskUtils
implements TaskUtils {
    protected final TaskType type;

    protected JPATaskUtils(TaskType type) {
        this.type = type;
    }

    public TaskType getType() {
        return this.type;
    }

    public <T extends Task<T>> Class<T> taskClass() {
        Class<PropagationTask> result = null;
        switch (this.type) {
            case PROPAGATION: {
                result = PropagationTask.class;
                break;
            }
            case SCHEDULED: {
                result = SchedTask.class;
                break;
            }
            case PULL: {
                result = PullTask.class;
                break;
            }
            case PUSH: {
                result = PushTask.class;
                break;
            }
            case MACRO: {
                result = MacroTask.class;
                break;
            }
            case NOTIFICATION: {
                result = NotificationTask.class;
                break;
            }
        }
        return result;
    }

    public <T extends Task<T>> T newTask() {
        AbstractTask result = null;
        switch (this.type) {
            case PROPAGATION: {
                result = new JPAPropagationTask();
                break;
            }
            case SCHEDULED: {
                result = new JPASchedTask();
                break;
            }
            case PULL: {
                result = new JPAPullTask();
                break;
            }
            case PUSH: {
                result = new JPAPushTask();
                break;
            }
            case MACRO: {
                result = new JPAMacroTask();
                break;
            }
            case NOTIFICATION: {
                result = new JPANotificationTask();
                break;
            }
        }
        if (result != null) {
            ((AbstractTask)result).setKey(SecureRandomUtils.generateRandomUUID().toString());
        }
        return (T)result;
    }

    public <E extends TaskExec<?>> E newTaskExec() {
        AbstractTaskExec result;
        switch (this.type) {
            case NOTIFICATION: {
                result = new JPANotificationTaskExec();
                break;
            }
            case PROPAGATION: {
                result = new JPAPropagationTaskExec();
                break;
            }
            case PULL: {
                result = new JPAPullTaskExec();
                break;
            }
            case PUSH: {
                result = new JPAPushTaskExec();
                break;
            }
            case MACRO: {
                result = new JPAMacroTaskExec();
                break;
            }
            case SCHEDULED: {
                result = new JPASchedTaskExec();
                break;
            }
            default: {
                result = null;
            }
        }
        if (result != null) {
            ((AbstractTaskExec)result).setKey(SecureRandomUtils.generateRandomUUID().toString());
        }
        return (E)result;
    }

    public <T extends TaskTO> Class<T> taskTOClass() {
        Class<PropagationTaskTO> result = null;
        switch (this.type) {
            case PROPAGATION: {
                result = PropagationTaskTO.class;
                break;
            }
            case SCHEDULED: {
                result = SchedTaskTO.class;
                break;
            }
            case PULL: {
                result = PullTaskTO.class;
                break;
            }
            case PUSH: {
                result = PushTaskTO.class;
                break;
            }
            case MACRO: {
                result = MacroTaskTO.class;
                break;
            }
            case NOTIFICATION: {
                result = NotificationTaskTO.class;
                break;
            }
        }
        return result;
    }

    public <T extends TaskTO> T newTaskTO() {
        Class<T> taskClass = this.taskTOClass();
        try {
            return (T)(taskClass == null ? null : (TaskTO)taskClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getTaskTable() {
        String result = null;
        switch (this.type) {
            case NOTIFICATION: {
                result = "NotificationTask";
                break;
            }
            case PROPAGATION: {
                result = "PropagationTask";
                break;
            }
            case PUSH: {
                result = "PushTask";
                break;
            }
            case PULL: {
                result = "PullTask";
                break;
            }
            case MACRO: {
                result = "MacroTask";
                break;
            }
            case SCHEDULED: {
                result = "SchedTask";
                break;
            }
        }
        return result;
    }

    public Class<? extends Task<?>> getTaskEntity() {
        Class result = null;
        switch (this.type) {
            case NOTIFICATION: {
                result = JPANotificationTask.class;
                break;
            }
            case PROPAGATION: {
                result = JPAPropagationTask.class;
                break;
            }
            case PUSH: {
                result = JPAPushTask.class;
                break;
            }
            case PULL: {
                result = JPAPullTask.class;
                break;
            }
            case MACRO: {
                result = JPAMacroTask.class;
                break;
            }
            case SCHEDULED: {
                result = JPASchedTask.class;
                break;
            }
        }
        return result;
    }

    public String getTaskExecTable() {
        String result = null;
        switch (this.type) {
            case NOTIFICATION: {
                result = "NotificationTaskExec";
                break;
            }
            case PROPAGATION: {
                result = "PropagationTaskExec";
                break;
            }
            case SCHEDULED: {
                result = "SchedTaskExec";
                break;
            }
            case PUSH: {
                result = "PushTaskExec";
                break;
            }
            case PULL: {
                result = "PullTaskExec";
                break;
            }
            case MACRO: {
                result = "MacroTaskExec";
                break;
            }
        }
        return result;
    }

    public Class<? extends TaskExec<?>> getTaskExecEntity() {
        Class result = null;
        switch (this.type) {
            case NOTIFICATION: {
                result = JPANotificationTaskExec.class;
                break;
            }
            case PROPAGATION: {
                result = JPAPropagationTaskExec.class;
                break;
            }
            case SCHEDULED: {
                result = JPASchedTaskExec.class;
                break;
            }
            case PUSH: {
                result = JPAPushTaskExec.class;
                break;
            }
            case PULL: {
                result = JPAPullTaskExec.class;
                break;
            }
            case MACRO: {
                result = JPAMacroTaskExec.class;
                break;
            }
        }
        return result;
    }
}

