/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.core.persistence.jpa.dao.SearchSupport;

public class AnySearchNode {
    private final Type type;
    private final List<AnySearchNode> children = new ArrayList<AnySearchNode>();

    protected AnySearchNode(Type type) {
        this.type = type;
    }

    protected Type getType() {
        return this.type;
    }

    protected boolean add(AnySearchNode child) {
        if (this.type == Type.LEAF) {
            throw new IllegalArgumentException("Cannot add children to a leaf node");
        }
        return this.children.add(child);
    }

    protected List<AnySearchNode> getChildren() {
        return this.children;
    }

    protected Optional<Leaf> asLeaf() {
        return this.type == Type.LEAF ? Optional.of((Leaf)this) : Optional.empty();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.type).append(this.children).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnySearchNode other = (AnySearchNode)obj;
        return new EqualsBuilder().append((Object)this.type, (Object)other.type).append(this.children, other.children).build();
    }

    public String toString() {
        return "Node{type=" + String.valueOf((Object)this.type) + ", children=" + String.valueOf(this.children) + "}";
    }

    public static class Leaf
    extends AnySearchNode {
        private final SearchSupport.SearchView from;
        private final String clause;

        protected Leaf(SearchSupport.SearchView from, String clause) {
            super(Type.LEAF);
            this.from = from;
            this.clause = clause;
        }

        public SearchSupport.SearchView getFrom() {
            return this.from;
        }

        public String getClause() {
            return this.clause;
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.from).append((Object)this.clause).build();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Leaf other = (Leaf)obj;
            return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.from, (Object)other.from).append((Object)this.clause, (Object)other.clause).build();
        }

        @Override
        public String toString() {
            return "LeafNode{from=" + String.valueOf(this.from) + ", clause=" + this.clause + "}";
        }
    }

    static enum Type {
        AND,
        OR,
        LEAF;

    }
}

