/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common;

import java.io.Serializable;

public interface PoolAllocation
extends Serializable {
    public boolean isCompatible(PoolAllocation var1);

    public static final class Unknown
    implements PoolAllocation {
        private static final long serialVersionUID = 3584540926973176260L;

        @Override
        public boolean isCompatible(PoolAllocation other) {
            return other != null;
        }
    }

    public static final class Shared
    implements SharedPoolAllocation {
        private static final long serialVersionUID = -5111316473831788364L;
        private final String resourcePoolName;

        public Shared(String resourcePoolName) {
            this.resourcePoolName = resourcePoolName;
        }

        @Override
        public String getResourcePoolName() {
            return this.resourcePoolName;
        }

        @Override
        public boolean isCompatible(PoolAllocation other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (other.getClass().isAssignableFrom(Unknown.class)) {
                return true;
            }
            if (!other.getClass().isAssignableFrom(Shared.class)) {
                return false;
            }
            Shared shared = (Shared)other;
            return this.resourcePoolName.equals(shared.resourcePoolName);
        }

        public String toString() {
            return "Shared{resourcePoolName='" + this.resourcePoolName + "'}";
        }
    }

    public static final class Dedicated
    implements DedicatedPoolAllocation {
        private static final long serialVersionUID = -2249181124582282204L;
        private final long size;
        private final String resourceName;

        public Dedicated(String resourceName, long size) {
            this.resourceName = resourceName;
            this.size = size;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public String getResourceName() {
            return this.resourceName;
        }

        @Override
        public boolean isCompatible(PoolAllocation other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (other.getClass().isAssignableFrom(Unknown.class)) {
                return true;
            }
            if (!other.getClass().isAssignableFrom(Dedicated.class)) {
                return false;
            }
            Dedicated dedicated = (Dedicated)other;
            if (this.size != dedicated.size) {
                return false;
            }
            return this.resourceName != null ? this.resourceName.equals(dedicated.resourceName) : dedicated.resourceName == null;
        }

        public String toString() {
            return "Dedicated{resourceName='" + this.resourceName + "', size='" + this.size + "'}";
        }
    }

    public static interface SharedPoolAllocation
    extends PoolAllocation {
        public String getResourcePoolName();
    }

    public static interface DedicatedPoolAllocation
    extends PoolAllocation {
        public long getSize();

        public String getResourceName();
    }
}

