/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.config.builders;

import java.time.Duration;
import java.util.Objects;
import org.ehcache.clustered.client.config.Timeouts;
import org.ehcache.config.Builder;

public final class TimeoutsBuilder
implements Builder<Timeouts> {
    private Duration readOperationTimeout = Timeouts.DEFAULT.getReadOperationTimeout();
    private Duration writeOperationTimeout = Timeouts.DEFAULT.getWriteOperationTimeout();
    private Duration connectionTimeout = Timeouts.DEFAULT.getConnectionTimeout();

    public static TimeoutsBuilder timeouts() {
        return new TimeoutsBuilder();
    }

    private TimeoutsBuilder() {
    }

    public TimeoutsBuilder read(Duration readOperationTimeout) {
        this.readOperationTimeout = Objects.requireNonNull(readOperationTimeout, "Read operation timeout can't be null");
        return this;
    }

    public TimeoutsBuilder write(Duration writeOperationTimeout) {
        this.writeOperationTimeout = Objects.requireNonNull(writeOperationTimeout, "Write operation timeout can't be null");
        return this;
    }

    public TimeoutsBuilder connection(Duration connectionTimeout) {
        this.connectionTimeout = Objects.requireNonNull(connectionTimeout, "Connection timeout can't be null");
        return this;
    }

    public Timeouts build() {
        return new Timeouts(this.readOperationTimeout, this.writeOperationTimeout, this.connectionTimeout);
    }
}

