/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.tirasa.connid.bundles.ad.ADConfiguration;
import net.tirasa.connid.bundles.ad.ADConnection;
import net.tirasa.connid.bundles.ad.authentication.ADAuthenticate;
import net.tirasa.connid.bundles.ad.crud.ADCreate;
import net.tirasa.connid.bundles.ad.crud.ADDelete;
import net.tirasa.connid.bundles.ad.crud.ADUpdate;
import net.tirasa.connid.bundles.ad.search.ADSearch;
import net.tirasa.connid.bundles.ldap.LdapConnector;
import net.tirasa.connid.bundles.ldap.search.LdapFilter;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.spi.ConnectorClass;

@ConnectorClass(configurationClass=ADConfiguration.class, displayNameKey="ADConnector")
public class ADConnector
extends LdapConnector {
    public static final String OBJECTGUID = "objectGUID";
    public static final String OBJECTSID = "objectSID";
    public static final String PRIMARYGROUPID = "primaryGroupID";
    public static final String MEMBEROF = "memberOf";
    public static final String UACCONTROL_ATTR = "userAccountControl";
    public static final String SDDL_ATTR = "ntSecurityDescriptor";
    public static final List<String> ADDS2012_ATTRIBUTES_TO_BE_REMOVED = Arrays.asList("msds-memberOfTransitive", "msDS-parentdistname", "msds-memberTransitive");
    public static final int UF_ACCOUNTDISABLE = 2;
    public static final int UF_PASSWD_NOTREQD = 32;
    public static final int UF_PASSWD_CANT_CHANGE = 64;
    public static final int UF_NORMAL_ACCOUNT = 512;
    public static final int UF_DONT_EXPIRE_PASSWD = 65536;
    public static final int UF_PASSWORD_EXPIRED = 0x800000;

    public void executeQuery(ObjectClass oclass, LdapFilter query, ResultsHandler handler, OperationOptions options) {
        new ADSearch(this.conn, oclass, query, handler, options).execute();
    }

    public Uid create(ObjectClass oclass, Set<Attribute> attrs, OperationOptions options) {
        if (((ADConfiguration)((Object)ADConfiguration.class.cast(this.conn.getConfiguration()))).isPwdUpdateOnly()) {
            throw new IllegalStateException("Create operation not permitted");
        }
        HashSet<Attribute> attributes = new HashSet<Attribute>(attrs);
        if (oclass.is(ObjectClass.ACCOUNT_NAME)) {
            Attribute ldapGroups = AttributeUtil.find((String)"ldapGroups", attributes);
            HashSet ldapGroupsToBeAdded = new HashSet();
            if (ldapGroups != null) {
                attributes.remove(ldapGroups);
                ldapGroupsToBeAdded.addAll(ldapGroups.getValue() == null ? Collections.emptyList() : Arrays.asList(ldapGroups.getValue().toArray(new String[ldapGroups.getValue().size()])));
            }
            ldapGroupsToBeAdded.addAll(((ADConfiguration)this.config).getMemberships() == null ? Collections.emptyList() : Arrays.asList(((ADConfiguration)this.config).getMemberships()));
            attributes.add(AttributeBuilder.build((String)"ldapGroups", ldapGroupsToBeAdded));
        }
        return new ADCreate((ADConnection)this.conn, oclass, attributes, options).execute();
    }

    public Uid update(ObjectClass oclass, Uid uid, Set<Attribute> attrs, OperationOptions options) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        if (((ADConfiguration)((Object)ADConfiguration.class.cast(this.conn.getConfiguration()))).isPwdUpdateOnly()) {
            Attribute pwd = AttributeUtil.find((String)OperationalAttributes.PASSWORD_NAME, attrs);
            if (pwd != null) {
                attributes.add(pwd);
            }
        } else {
            attributes.addAll(attrs);
            Attribute ldapGroups = AttributeUtil.find((String)"ldapGroups", attributes);
            if (ldapGroups != null && oclass.is(ObjectClass.ACCOUNT_NAME)) {
                attributes.remove(ldapGroups);
                HashSet ldapGroupsToBeAdded = new HashSet(ldapGroups.getValue() == null ? Collections.emptyList() : Arrays.asList(ldapGroups.getValue().toArray(new String[ldapGroups.getValue().size()])));
                String[] memberships = ((ADConfiguration)this.config).getMemberships();
                ldapGroupsToBeAdded.addAll(memberships == null ? Collections.emptyList() : Arrays.asList(memberships));
                attributes.add(AttributeBuilder.build((String)"ldapGroups", ldapGroupsToBeAdded));
            }
        }
        return new ADUpdate((ADConnection)this.conn, oclass, uid).update(attributes);
    }

    public void delete(ObjectClass oclass, Uid uid, OperationOptions options) {
        if (((ADConfiguration)((Object)ADConfiguration.class.cast(this.conn.getConfiguration()))).isPwdUpdateOnly()) {
            throw new IllegalStateException("Delete operation not permitted");
        }
        new ADDelete((ADConnection)this.conn, oclass, uid).execute();
    }

    public Uid authenticate(ObjectClass objectClass, String username, GuardedString password, OperationOptions options) {
        return new ADAuthenticate((ADConnection)this.conn, objectClass, username, options).authenticate(password);
    }

    public Uid resolveUsername(ObjectClass objectClass, String username, OperationOptions options) {
        return new ADAuthenticate((ADConnection)this.conn, objectClass, username, options).resolveUsername();
    }
}

