/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.FieldMappingInfo;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.ValueMappingInfo;
import org.apache.openjpa.jdbc.meta.strats.RelationStrategies;
import org.apache.openjpa.jdbc.meta.strats.StoreCollectionFieldStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.jdbc.sql.RowManager;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.MetaDataContext;
import org.apache.openjpa.util.ChangeTracker;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.Proxies;
import org.apache.openjpa.util.Proxy;

public abstract class RelationToManyTableFieldStrategy
extends StoreCollectionFieldStrategy {
    private static final long serialVersionUID = 1L;
    private static final Localizer _loc = Localizer.forPackage(RelationToManyTableFieldStrategy.class);

    @Override
    protected ClassMapping[] getIndependentElementMappings(boolean traverse) {
        return traverse ? this.field.getElementMapping().getIndependentTypeMappings() : ClassMapping.EMPTY_MAPPINGS;
    }

    @Override
    protected ForeignKey getJoinForeignKey(ClassMapping elem) {
        return this.field.getJoinForeignKey();
    }

    @Override
    protected void selectElement(Select sel, ClassMapping elem, JDBCStore store, JDBCFetchConfiguration fetch, int eagerMode, Joins joins) {
        sel.select(elem, this.field.getElementMapping().getSelectSubclasses(), store, fetch, eagerMode, joins);
    }

    @Override
    protected Object loadElement(OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Result res, Joins joins) throws SQLException {
        ClassMapping elem = res.getBaseMapping();
        if (elem == null) {
            elem = this.field.getElementMapping().getIndependentTypeMappings()[0];
        }
        return res.load(elem, store, fetch, joins);
    }

    @Override
    protected Joins join(Joins joins, ClassMapping elem) {
        return this.join(joins, false);
    }

    @Override
    protected Joins joinElementRelation(Joins joins, ClassMapping elem) {
        ValueMapping vm = this.field.getElementMapping();
        return joins.joinRelation(this.field.getName(), vm.getForeignKey(elem), elem, vm.getSelectSubclasses(), false, false);
    }

    @Override
    public void map(boolean adapt) {
        this.field.getValueInfo().assertNoSchemaComponents(this.field, !adapt);
        this.field.getKeyMapping().getValueInfo().assertNoSchemaComponents((MetaDataContext)this.field.getKey(), !adapt);
        ValueMapping elem = this.field.getElementMapping();
        if (elem.getTypeCode() != 15 || elem.isEmbeddedPC()) {
            throw new MetaDataException(_loc.get("not-elem-relation", (Object)this.field));
        }
        FieldMapping mapped = this.field.getMappedByMapping();
        ValueMappingInfo vinfo = elem.getValueInfo();
        boolean criteria = vinfo.getUseClassCriteria();
        OpenJPAConfiguration conf = this.field.getRepository().getConfiguration();
        boolean isNonDefaultMappingAllowed = this.field.getRepository().getMetaDataFactory().getDefaults().isNonDefaultMappingAllowed(conf);
        if (mapped != null && !this.field.isBiMTo1JT()) {
            if (mapped.getElement().getTypeCode() != 15) {
                throw new MetaDataException(_loc.get("not-inv-relation-coll", (Object)this.field, (Object)mapped));
            }
            this.field.getMappingInfo().assertNoSchemaComponents(this.field, !adapt);
            vinfo.assertNoSchemaComponents(elem, !adapt);
            mapped.resolve(3);
            if (!mapped.isMapped() || mapped.isSerialized()) {
                throw new MetaDataException(_loc.get("mapped-by-unmapped", (Object)this.field, (Object)mapped));
            }
            this.field.setJoinForeignKey(mapped.getElementMapping().getForeignKey(this.field.getDefiningMapping()));
            elem.setForeignKey(mapped.getJoinForeignKey());
            elem.setUseClassCriteria(criteria);
            this.field.setOrderColumn(mapped.getOrderColumn());
            return;
        }
        if (mapped == null || this.field.isBiMTo1JT()) {
            if (this.field.isBiMTo1JT()) {
                this.field.setBi1MJoinTableInfo();
            }
            this.field.mapJoin(adapt, true);
            if (elem.getTypeMapping().isMapped()) {
                ForeignKey fk = vinfo.getTypeJoin(elem, "element", false, adapt);
                elem.setForeignKey(fk);
                elem.setColumnIO(vinfo.getColumnIO());
            } else {
                RelationStrategies.mapRelationToUnmappedPC(elem, "element", adapt);
            }
            elem.setUseClassCriteria(criteria);
            elem.mapConstraints("element", adapt);
            FieldMappingInfo finfo = this.field.getMappingInfo();
            Column orderCol = finfo.getOrderColumn(this.field, this.field.getTable(), adapt);
            this.field.setOrderColumn(orderCol);
            this.field.setOrderColumnIO(finfo.getColumnIO());
            this.field.mapPrimaryKey(adapt);
        }
    }

    @Override
    public void insert(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        if (this.field.getMappedBy() == null || this.field.isBiMTo1JT()) {
            this.insert(sm, rm, sm.fetchObject(this.field.getIndex()));
        }
    }

    private void insert(OpenJPAStateManager sm, RowManager rm, Object vals) throws SQLException {
        Collection coll = this.toCollection(vals);
        if (coll == null || coll.isEmpty()) {
            return;
        }
        Row row = rm.getSecondaryRow(this.field.getTable(), 1);
        row.setForeignKey(this.field.getJoinForeignKey(), this.field.getJoinColumnIO(), sm);
        ValueMapping elem = this.field.getElementMapping();
        StoreContext ctx = sm.getContext();
        Column order = this.field.getOrderColumn();
        boolean setOrder = this.field.getOrderColumnIO().isInsertable(order, false);
        int idx = 0;
        Iterator itr = coll.iterator();
        while (itr.hasNext()) {
            OpenJPAStateManager esm = RelationStrategies.getStateManager(itr.next(), ctx);
            elem.setForeignKey(row, esm);
            if (setOrder) {
                row.setInt(order, idx);
            }
            rm.flushSecondaryRow(row);
            ++idx;
        }
    }

    @Override
    public void update(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        Collection add;
        OpenJPAStateManager esm;
        Proxy proxy;
        if (this.field.getMappedBy() != null && !this.field.isBiMTo1JT()) {
            return;
        }
        Object obj = sm.fetchObject(this.field.getIndex());
        ChangeTracker ct = null;
        if (obj instanceof Proxy && Proxies.isOwner((Proxy)(proxy = (Proxy)obj), (OpenJPAStateManager)sm, (int)this.field.getIndex())) {
            ct = proxy.getChangeTracker();
        }
        Column order = this.field.getOrderColumn();
        if (ct == null || !ct.isTracking() || order != null && !ct.getRemoved().isEmpty()) {
            this.delete(sm, store, rm);
            this.insert(sm, rm, obj);
            return;
        }
        StoreContext ctx = store.getContext();
        ValueMapping elem = this.field.getElementMapping();
        Collection rem = ct.getRemoved();
        if (!rem.isEmpty()) {
            Row delRow = rm.getSecondaryRow(this.field.getTable(), 2);
            delRow.whereForeignKey(this.field.getJoinForeignKey(), sm);
            for (Object o : rem) {
                esm = RelationStrategies.getStateManager(o, ctx);
                elem.whereForeignKey(delRow, esm);
                rm.flushSecondaryRow(delRow);
            }
        }
        if (!(add = ct.getAdded()).isEmpty()) {
            Row addRow = rm.getSecondaryRow(this.field.getTable(), 1);
            addRow.setForeignKey(this.field.getJoinForeignKey(), this.field.getJoinColumnIO(), sm);
            int seq = ct.getNextSequence();
            boolean setOrder = this.field.getOrderColumnIO().isInsertable(order, false);
            Iterator itr = add.iterator();
            while (itr.hasNext()) {
                esm = RelationStrategies.getStateManager(itr.next(), ctx);
                elem.setForeignKey(addRow, esm);
                if (setOrder) {
                    addRow.setInt(order, seq);
                }
                rm.flushSecondaryRow(addRow);
                ++seq;
            }
            if (order != null) {
                ct.setNextSequence(seq);
            }
        }
    }

    @Override
    public void delete(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        Row row = rm.getAllRows(this.field.getTable(), 2);
        row.whereForeignKey(this.field.getJoinForeignKey(), sm);
        rm.flushAllRows(row);
    }

    @Override
    public Object toDataStoreValue(Object val, JDBCStore store) {
        return RelationStrategies.toDataStoreValue(this.field.getElementMapping(), val, store);
    }

    @Override
    public Joins join(Joins joins, boolean forceOuter) {
        return this.field.join(joins, forceOuter, true);
    }

    @Override
    public Joins joinRelation(Joins joins, boolean forceOuter, boolean traverse) {
        ValueMapping elem = this.field.getElementMapping();
        ClassMapping[] clss = elem.getIndependentTypeMappings();
        if (clss.length != 1) {
            if (traverse) {
                throw RelationStrategies.unjoinable(elem);
            }
            return joins;
        }
        if (forceOuter) {
            return joins.outerJoinRelation(this.field.getName(), elem.getForeignKey(clss[0]), clss[0], elem.getSelectSubclasses(), false, false);
        }
        return joins.joinRelation(this.field.getName(), elem.getForeignKey(clss[0]), clss[0], elem.getSelectSubclasses(), false, false);
    }
}

