/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor.caching;

import java.util.Iterator;
import java.util.Map;
import org.springframework.util.StringUtils;
import org.springmodules.cache.CachingModel;
import org.springmodules.cache.FatalCacheException;
import org.springmodules.cache.interceptor.caching.AbstractModelSourceCachingInterceptor;
import org.springmodules.cache.interceptor.caching.CachingModelSource;
import org.springmodules.cache.interceptor.caching.MethodMapCachingModelSource;

public final class MethodMapCachingInterceptor
extends AbstractModelSourceCachingInterceptor {
    protected void onAfterPropertiesSet() throws FatalCacheException {
        CachingModelSource cachingModelSource = this.getCachingModelSource();
        if (cachingModelSource == null) {
            MethodMapCachingModelSource newSource = new MethodMapCachingModelSource();
            Map models = this.models();
            String key = null;
            try {
                Iterator i = models.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    key = (String)entry.getKey();
                    newSource.addModel((CachingModel)entry.getValue(), key);
                }
            }
            catch (Exception exception) {
                throw new FatalCacheException("Unable to add model stored under the key " + StringUtils.quote(key), exception);
            }
            this.setCachingModelSource(newSource);
        }
    }
}

