/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.core.settings.requrestcycle;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.context.extensions.types.DurationUnit;
import com.giffing.wicket.spring.boot.context.extensions.types.TypeParser;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.core.settings.requrestcycle.RequestCycleSettingsProperties;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.settings.RequestCycleSettings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.core.settings.requestcycle", value={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={RequestCycleSettingsProperties.class})
public class RequestCycleSettingsConfig
implements WicketApplicationInitConfiguration {
    @Autowired
    private RequestCycleSettingsProperties props;
    @Autowired
    private WicketEndpointRepository wicketEndpointRepository;

    public void init(WebApplication webApplication) {
        RequestCycleSettings requestCycleSettings = webApplication.getRequestCycleSettings();
        requestCycleSettings.setRenderStrategy(this.props.getRenderStrategy());
        requestCycleSettings.setBufferResponse(this.props.isBufferResponse());
        requestCycleSettings.setExceptionRetryCount(this.props.getExceptionRetryCount());
        requestCycleSettings.setGatherExtendedBrowserInfo(this.props.isGatherExtendedBrowserInfo());
        requestCycleSettings.setResponseRequestEncoding(this.props.getResponseRequestEncoding());
        requestCycleSettings.setTimeout(TypeParser.parse((Long)this.props.getTimeoutSize(), (DurationUnit)this.props.getTimeoutUnit()));
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.props).build());
    }
}

