/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.db.table;

import net.tirasa.connid.bundles.db.commons.DatabaseFilterTranslator;
import net.tirasa.connid.bundles.db.commons.SQLParam;
import net.tirasa.connid.bundles.db.table.DatabaseTableConfiguration;
import net.tirasa.connid.bundles.db.table.DatabaseTableConnector;
import net.tirasa.connid.bundles.db.table.util.DatabaseTableSQLUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;

public class DatabaseTableFilterTranslator
extends DatabaseFilterTranslator {
    private final DatabaseTableConnector connector;

    public DatabaseTableFilterTranslator(DatabaseTableConnector connector, ObjectClass oclass, OperationOptions options) {
        super(oclass, options);
        this.connector = connector;
    }

    protected SQLParam getSQLParam(Attribute attribute, ObjectClass oclass, OperationOptions options) {
        Object value = AttributeUtil.getSingleValue((Attribute)attribute);
        String columnName = this.connector.getColumnName(attribute.getName());
        if (StringUtil.isNotBlank((String)columnName)) {
            Integer columnType = this.connector.getColumnType(columnName);
            String quoting = ((DatabaseTableConfiguration)this.connector.getConfiguration()).getQuoting();
            String quotedName = DatabaseTableSQLUtil.quoteName(quoting, columnName);
            return new SQLParam(columnName, value, columnType.intValue(), quotedName);
        }
        return null;
    }
}

