/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.commons;

import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.ui.commons.markup.html.form.preview.BinaryPreviewer;
import org.apache.syncope.client.ui.commons.markup.html.form.preview.DefaultPreviewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class PreviewUtils
implements Serializable {
    private static final long serialVersionUID = 2765845550328631887L;
    protected static final Logger LOG = LoggerFactory.getLogger(PreviewUtils.class);
    protected final ClassPathScanImplementationLookup lookup;

    public PreviewUtils(ClassPathScanImplementationLookup lookup) {
        this.lookup = lookup;
    }

    public BinaryPreviewer getPreviewer(String mimeType) {
        if (StringUtils.isBlank((CharSequence)mimeType)) {
            return new DefaultPreviewer(mimeType);
        }
        return Optional.ofNullable(this.lookup.getPreviewerClass(mimeType)).map(clazz -> {
            try {
                return (BinaryPreviewer)ClassUtils.getConstructorIfAvailable((Class)clazz, (Class[])new Class[]{String.class}).newInstance(mimeType);
            }
            catch (Exception e) {
                LOG.error("While getting BinaryPreviewer for {}", (Object)mimeType, (Object)e);
                return new DefaultPreviewer(mimeType);
            }
        }).orElseGet(() -> new DefaultPreviewer(mimeType));
    }
}

