/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote.commands;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class GetConfigurationCommand
implements RemoteCommand<BucketConfiguration>,
ComparableByContent<GetConfigurationCommand> {
    public static SerializationHandle<GetConfigurationCommand> SERIALIZATION_HANDLE = new SerializationHandle<GetConfigurationCommand>(){

        @Override
        public <S> GetConfigurationCommand deserialize(DeserializationAdapter<S> adapter, S input, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            return new GetConfigurationCommand();
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, GetConfigurationCommand command, Version backwardCompatibilityVersion) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
        }

        @Override
        public int getTypeId() {
            return 33;
        }

        @Override
        public Class<GetConfigurationCommand> getSerializedType() {
            return GetConfigurationCommand.class;
        }

        @Override
        public GetConfigurationCommand fromJsonCompatibleSnapshot(Map<String, Object> snapshot, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            return new GetConfigurationCommand();
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(GetConfigurationCommand command, Version backwardCompatibilityVersion) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            return result;
        }

        @Override
        public String getTypeName() {
            return "GetConfigurationCommand";
        }
    };

    @Override
    public CommandResult<BucketConfiguration> execute(MutableBucketEntry mutableEntry, long currentTimeNanos) {
        if (!mutableEntry.exists()) {
            return CommandResult.bucketNotFound();
        }
        RemoteBucketState state = mutableEntry.get();
        return CommandResult.success(state.getConfiguration(), BucketConfiguration.SERIALIZATION_HANDLE);
    }

    @Override
    public SerializationHandle getSerializationHandle() {
        return SERIALIZATION_HANDLE;
    }

    @Override
    public boolean equalsByContent(GetConfigurationCommand other) {
        return true;
    }

    @Override
    public boolean isImmediateSyncRequired(long unsynchronizedTokens, long nanosSinceLastSync) {
        return false;
    }

    @Override
    public long estimateTokensToConsume() {
        return 0L;
    }

    @Override
    public long getConsumedTokens(BucketConfiguration result) {
        return 0L;
    }
}

