/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.GroupableRelatable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class DefaultDerAttrHandler
implements DerAttrHandler {
    protected static final Logger LOG = LoggerFactory.getLogger(DerAttrHandler.class);
    protected final AnyUtilsFactory anyUtilsFactory;

    protected static Map<DerSchema, String> getValues(Any<?> any, Set<DerSchema> schemas) {
        HashMap<DerSchema, String> result = new HashMap<DerSchema, String>(schemas.size());
        schemas.forEach(schema -> {
            MapContext jexlContext = new MapContext();
            JexlUtils.addPlainAttrsToContext((Collection)any.getPlainAttrs(), (JexlContext)jexlContext);
            JexlUtils.addFieldsToContext((Object)any, (JexlContext)jexlContext);
            result.put((DerSchema)schema, JexlUtils.evaluateExpr((String)schema.getExpression(), (JexlContext)jexlContext).toString());
        });
        return result;
    }

    public DefaultDerAttrHandler(AnyUtilsFactory anyUtilsFactory) {
        this.anyUtilsFactory = anyUtilsFactory;
    }

    public String getValue(Any<?> any, DerSchema schema) {
        if (!this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, DerSchema.class).forSelfContains((Schema)schema)) {
            LOG.debug("{} not allowed for {}", (Object)schema, any);
            return null;
        }
        return DefaultDerAttrHandler.getValues(any, Set.of(schema)).get(schema);
    }

    public String getValue(Any<?> any, Membership<?> membership, DerSchema schema) {
        if (!this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, DerSchema.class).getForMembership((Group)membership.getRightEnd()).contains(schema)) {
            LOG.debug("{} not allowed for {}", (Object)schema, any);
            return null;
        }
        return DefaultDerAttrHandler.getValues(any, Set.of(schema)).get(schema);
    }

    public Map<DerSchema, String> getValues(Any<?> any) {
        return DefaultDerAttrHandler.getValues(any, this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, DerSchema.class).getForSelf());
    }

    protected static Map<DerSchema, String> getValues(GroupableRelatable<?, ?, ?, ?, ?> any, Membership<?> membership, Set<DerSchema> schemas) {
        HashMap<DerSchema, String> result = new HashMap<DerSchema, String>(schemas.size());
        schemas.forEach(schema -> {
            MapContext jexlContext = new MapContext();
            JexlUtils.addPlainAttrsToContext((Collection)any.getPlainAttrs(membership), (JexlContext)jexlContext);
            JexlUtils.addFieldsToContext((Object)any, (JexlContext)jexlContext);
            result.put((DerSchema)schema, JexlUtils.evaluateExpr((String)schema.getExpression(), (JexlContext)jexlContext).toString());
        });
        return result;
    }

    public Map<DerSchema, String> getValues(GroupableRelatable<?, ?, ?, ?, ?> any, Membership<?> membership) {
        return DefaultDerAttrHandler.getValues(any, membership, this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, DerSchema.class).getForMembership((Group)membership.getRightEnd()));
    }
}

