/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.oauth2.useragent;

import com.microsoft.alm.oauth2.useragent.AuthorizationException;
import com.microsoft.alm.oauth2.useragent.AuthorizationResponse;
import com.microsoft.alm.oauth2.useragent.InterceptingBrowser;
import com.microsoft.alm.oauth2.useragent.RunnableFactory;
import com.microsoft.alm.oauth2.useragent.UserAgent;
import com.microsoft.alm.oauth2.useragent.UserAgentImpl;
import java.net.URI;
import java.util.List;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextField;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.stage.Stage;

public class JavaFx
extends Application
implements UserAgent,
Runnable,
RunnableFactory<JavaFx> {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    static RunnableFactory<JavaFx> RUNNABLE_FACTORY_OVERRIDE = null;
    private final RunnableFactory<JavaFx> runnableFactory = RUNNABLE_FACTORY_OVERRIDE != null ? RUNNABLE_FACTORY_OVERRIDE : this;
    private InterceptingBrowser interceptingBrowser = null;

    public static void main(String[] args) {
        JavaFx.launch((String[])args);
    }

    @Override
    public AuthorizationResponse requestAuthorizationCode(URI authorizationEndpoint, URI redirectUri) throws AuthorizationException {
        this.interceptingBrowser.sendRequest(authorizationEndpoint, redirectUri);
        return this.interceptingBrowser.waitForResponse();
    }

    public void start(Stage primaryStage) throws Exception {
        primaryStage.setTitle("OAuth 2.0 Authorization Request");
        final TextField addressBar = new TextField();
        addressBar.setEditable(false);
        this.interceptingBrowser = new InterceptingBrowser();
        WebEngine webEngine = this.interceptingBrowser.getWebEngine();
        webEngine.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                addressBar.setText(newValue);
            }
        });
        VBox vBox = new VBox(5.0);
        vBox.getChildren().setAll((Object[])new Node[]{addressBar, this.interceptingBrowser});
        VBox.setVgrow((Node)this.interceptingBrowser, (Priority)Priority.ALWAYS);
        Scene scene = new Scene((Parent)vBox);
        primaryStage.setScene(scene);
        primaryStage.show();
        Runnable runnable = this.runnableFactory.create(this);
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public void stop() throws Exception {
        this.interceptingBrowser.cancel();
    }

    @Override
    public void run() {
        Application.Parameters parameters = this.getParameters();
        List parameterList = parameters.getRaw();
        String[] args = parameterList.toArray(EMPTY_STRING_ARRAY);
        UserAgentImpl.decode(this, args, System.in, System.out);
        System.exit(0);
    }

    @Override
    public Runnable create(JavaFx javaFx) {
        return this;
    }
}

