/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.assertion;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPSamlRegisteredServiceCriterion;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileBuilderContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectSigner;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.model.TriStateBoolean;
import org.jooq.lambda.Unchecked;
import org.opensaml.saml.metadata.criteria.entity.impl.EvaluableEntityRoleEntityDescriptorCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlProfileSamlAssertionBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<Assertion> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlAssertionBuilder.class);
    private static final long serialVersionUID = -3945938960014421135L;
    private final SamlProfileObjectBuilder<AuthnStatement> samlProfileSamlAuthNStatementBuilder;
    private final SamlProfileObjectBuilder<AttributeStatement> samlProfileSamlAttributeStatementBuilder;
    private final SamlProfileObjectBuilder<Subject> samlProfileSamlSubjectBuilder;
    private final SamlProfileObjectBuilder<Conditions> samlProfileSamlConditionsBuilder;
    private final SamlIdPObjectSigner samlObjectSigner;
    private final MetadataResolver samlIdPMetadataResolver;

    public SamlProfileSamlAssertionBuilder(OpenSamlConfigBean configBean, SamlProfileObjectBuilder<AuthnStatement> samlProfileSamlAuthNStatementBuilder, SamlProfileObjectBuilder<AttributeStatement> samlProfileSamlAttributeStatementBuilder, SamlProfileObjectBuilder<Subject> samlProfileSamlSubjectBuilder, SamlProfileObjectBuilder<Conditions> samlProfileSamlConditionsBuilder, SamlIdPObjectSigner samlObjectSigner, MetadataResolver samlIdPMetadataResolver) {
        super(configBean);
        this.samlProfileSamlAuthNStatementBuilder = samlProfileSamlAuthNStatementBuilder;
        this.samlProfileSamlAttributeStatementBuilder = samlProfileSamlAttributeStatementBuilder;
        this.samlProfileSamlSubjectBuilder = samlProfileSamlSubjectBuilder;
        this.samlProfileSamlConditionsBuilder = samlProfileSamlConditionsBuilder;
        this.samlObjectSigner = samlObjectSigner;
        this.samlIdPMetadataResolver = samlIdPMetadataResolver;
    }

    @Override
    public Assertion build(SamlProfileBuilderContext context) throws Exception {
        ArrayList<Object> statements = new ArrayList<Object>();
        AuthnStatement authnStatement = this.samlProfileSamlAuthNStatementBuilder.build(context);
        statements.add(authnStatement);
        AttributeStatement attrStatement = this.samlProfileSamlAttributeStatementBuilder.build(context);
        if (!attrStatement.getAttributes().isEmpty() || !attrStatement.getEncryptedAttributes().isEmpty()) {
            statements.add(attrStatement);
        }
        String issuerId = (String)FunctionUtils.doIf((boolean)StringUtils.isNotBlank((CharSequence)context.getRegisteredService().getIssuerEntityId()), () -> ((SamlRegisteredService)context.getRegisteredService()).getIssuerEntityId(), (Supplier)Unchecked.supplier(() -> {
            CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EvaluableEntityRoleEntityDescriptorCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME), new SamlIdPSamlRegisteredServiceCriterion(context.getRegisteredService())});
            LOGGER.trace("Resolving entity id from SAML2 IdP metadata to determine issuer for [{}]", (Object)context.getRegisteredService().getName());
            EntityDescriptor entityDescriptor = Objects.requireNonNull((EntityDescriptor)this.samlIdPMetadataResolver.resolveSingle((Object)criteriaSet));
            return entityDescriptor.getEntityID();
        })).get();
        String id = "_" + String.valueOf(RandomUtils.nextLong());
        Assertion assertion = this.newAssertion(statements, issuerId, ZonedDateTime.now(ZoneOffset.UTC), id);
        assertion.setSubject(this.samlProfileSamlSubjectBuilder.build(context));
        assertion.setConditions(this.samlProfileSamlConditionsBuilder.build(context));
        this.signAssertion(assertion, context);
        return assertion;
    }

    protected void signAssertion(Assertion assertion, SamlProfileBuilderContext context) throws Exception {
        boolean signAssertions;
        boolean bl = signAssertions = context.getRegisteredService().getSignAssertions() == TriStateBoolean.UNDEFINED && context.getAdaptor().isWantAssertionsSigned() || context.getRegisteredService().getSignAssertions().isTrue();
        if (signAssertions) {
            LOGGER.debug("SAML registered service [{}] requires assertions to be signed", (Object)context.getAdaptor().getEntityId());
            this.samlObjectSigner.encode(assertion, context.getRegisteredService(), context.getAdaptor(), context.getHttpResponse(), context.getHttpRequest(), context.getBinding(), context.getSamlRequest(), context.getMessageContext());
        } else {
            LOGGER.debug("SAML registered service [{}] does not require assertions to be signed", (Object)context.getAdaptor().getEntityId());
        }
    }
}

