/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="statistics", enableByDefault=false)
public class StatisticsEndpoint
extends BaseCasActuatorEndpoint {
    private final ZonedDateTime upTimeStartDate = ZonedDateTime.now(ZoneOffset.UTC);
    private final ObjectProvider<TicketRegistry> ticketRegistry;

    public StatisticsEndpoint(ObjectProvider<TicketRegistry> ticketRegistry, CasConfigurationProperties casProperties) {
        super(casProperties);
        this.ticketRegistry = ticketRegistry;
    }

    @ReadOperation
    @Operation(summary="Get a report of CAS statistics")
    public Map<String, Object> handle() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        Duration diff = Duration.between(this.upTimeStartDate, ZonedDateTime.now(ZoneOffset.UTC));
        model.put("upTime", diff.getSeconds());
        Runtime runtime = Runtime.getRuntime();
        model.put("totalMemory", FileUtils.byteCountToDisplaySize((long)runtime.totalMemory()));
        model.put("maxMemory", FileUtils.byteCountToDisplaySize((long)runtime.maxMemory()));
        model.put("freeMemory", FileUtils.byteCountToDisplaySize((long)runtime.freeMemory()));
        AtomicInteger unexpiredTgts = new AtomicInteger();
        AtomicInteger unexpiredSts = new AtomicInteger();
        AtomicInteger expiredTgts = new AtomicInteger();
        AtomicInteger expiredSts = new AtomicInteger();
        Stream tickets = ((TicketRegistry)this.ticketRegistry.getObject()).getTickets(ticket -> true);
        tickets.forEach(Unchecked.consumer(ticket -> {
            if (ticket instanceof ServiceTicket) {
                if (ticket.isExpired()) {
                    ((TicketRegistry)this.ticketRegistry.getObject()).deleteTicket(ticket.getId());
                    expiredSts.incrementAndGet();
                } else {
                    unexpiredSts.incrementAndGet();
                }
            } else if (ticket.isExpired()) {
                ((TicketRegistry)this.ticketRegistry.getObject()).deleteTicket(ticket.getId());
                expiredTgts.incrementAndGet();
            } else {
                unexpiredTgts.incrementAndGet();
            }
        }));
        model.put("unexpiredTgts", unexpiredTgts);
        model.put("unexpiredSts", unexpiredSts);
        model.put("expiredTgts", expiredTgts);
        model.put("expiredSts", expiredSts);
        return model;
    }
}

