/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.apereo.cas.web.flow.CasWebflowExecutionPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.expression.Expression;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;
import org.springframework.webflow.action.EvaluateAction;
import org.springframework.webflow.action.ExternalRedirectAction;
import org.springframework.webflow.action.SetAction;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.EndState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.FlowVariable;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.support.ActionExecutingViewFactory;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.AnnotatedAction;

@Endpoint(id="springWebflow", enableByDefault=false)
public class SpringWebflowEndpoint
extends BaseCasActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringWebflowEndpoint.class);
    private final ApplicationContext applicationContext;

    public SpringWebflowEndpoint(CasConfigurationProperties casProperties, ApplicationContext applicationContext) {
        super(casProperties);
        this.applicationContext = applicationContext;
    }

    private static String convertActionToString(Action action) {
        if (action instanceof EvaluateAction) {
            return SpringWebflowEndpoint.convertEvaluateActionToString(action);
        }
        if (action instanceof AnnotatedAction) {
            AnnotatedAction eval = (AnnotatedAction)action;
            if (eval.getTargetAction() instanceof EvaluateAction) {
                return SpringWebflowEndpoint.convertEvaluateActionToString(eval.getTargetAction());
            }
            return eval.getTargetAction().toString();
        }
        if (action instanceof SetAction) {
            Field expF = ReflectionUtils.findField(action.getClass(), (String)"nameExpression");
            Field resultExpF = ReflectionUtils.findField(action.getClass(), (String)"valueExpression");
            return "set " + SpringWebflowEndpoint.stringifyActionField(action, expF) + " = " + SpringWebflowEndpoint.stringifyActionField(action, resultExpF);
        }
        return action.toString();
    }

    private static String convertEvaluateActionToString(Action action) {
        EvaluateAction eval = (EvaluateAction)action;
        Field expF = ReflectionUtils.findField(eval.getClass(), (String)"expression");
        Field resultExpF = ReflectionUtils.findField(eval.getClass(), (String)"resultExpression");
        return SpringWebflowEndpoint.stringifyActionField(action, expF, resultExpF);
    }

    private static String stringifyActionField(Action eval, Field ... fields) {
        return Arrays.stream(fields).map(f -> {
            ReflectionUtils.makeAccessible((Field)f);
            Object exp = ReflectionUtils.getField((Field)f, (Object)eval);
            if (exp != null) {
                return StringUtils.defaultString((String)exp.toString());
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.joining(", "));
    }

    private static Map<String, Object> getStateDetails(Flow flowDefinition, String stateId) {
        List acts;
        State state = (State)flowDefinition.getState(stateId);
        LinkedHashMap<String, Object> stateMap = new LinkedHashMap<String, Object>();
        if (!state.getAttributes().asMap().isEmpty()) {
            stateMap.put("attributes", CollectionUtils.wrap((Object)state.getAttributes()));
        }
        if (StringUtils.isNotBlank((CharSequence)state.getCaption())) {
            stateMap.put("caption", state.getCaption());
        }
        if (!(acts = StreamSupport.stream(state.getEntryActionList().spliterator(), false).map(SpringWebflowEndpoint::convertActionToString).collect(Collectors.toList())).isEmpty()) {
            stateMap.put("entryActions", acts);
        }
        if (state instanceof ActionState && !(acts = StreamSupport.stream(((ActionState)state).getActionList().spliterator(), false).map(SpringWebflowEndpoint::convertActionToString).collect(Collectors.toList())).isEmpty()) {
            stateMap.put("actionList", acts);
        }
        if (state instanceof EndState) {
            stateMap.put("isEndState", Boolean.TRUE);
        }
        if (state.isViewState()) {
            Field field;
            ViewState viewState = (ViewState)state;
            stateMap.put("isViewState", state.isViewState());
            stateMap.put("isRedirect", viewState.getRedirect());
            acts = StreamSupport.stream(viewState.getRenderActionList().spliterator(), false).map(Object::toString).collect(Collectors.toList());
            if (!acts.isEmpty()) {
                stateMap.put("renderActions", acts);
            }
            if (!(acts = Arrays.stream(viewState.getVariables()).map(variable -> variable.getName() + " -> " + variable.getValueFactory().toString()).collect(Collectors.toList())).isEmpty()) {
                stateMap.put("viewVariables", acts);
            }
            if ((field = ReflectionUtils.findField(viewState.getViewFactory().getClass(), (String)"viewId")) != null) {
                ReflectionUtils.makeAccessible((Field)field);
                Expression exp = (Expression)ReflectionUtils.getField((Field)field, (Object)viewState.getViewFactory());
                stateMap.put("viewId", StringUtils.defaultIfBlank((CharSequence)Objects.requireNonNull(exp).getExpressionString(), (CharSequence)exp.getValue(null).toString()));
            } else if (viewState.getViewFactory() instanceof ActionExecutingViewFactory) {
                ActionExecutingViewFactory factory = (ActionExecutingViewFactory)viewState.getViewFactory();
                if (factory.getAction() instanceof ExternalRedirectAction) {
                    ExternalRedirectAction redirect = (ExternalRedirectAction)factory.getAction();
                    Field uri = ReflectionUtils.findField(redirect.getClass(), (String)"resourceUri");
                    ReflectionUtils.makeAccessible((Field)Objects.requireNonNull(uri));
                    Expression exp = (Expression)ReflectionUtils.getField((Field)uri, (Object)redirect);
                    stateMap.put("viewId", "externalRedirect -> #{" + Objects.requireNonNull(exp).getExpressionString() + "}");
                } else {
                    stateMap.put("viewId", factory.getAction().toString());
                }
            } else {
                LOGGER.info("Field viewId cannot be located on view state [{}]", (Object)state);
            }
        }
        if (state instanceof TransitionableState) {
            TransitionableState stDef = (TransitionableState)state;
            acts = StreamSupport.stream(stDef.getExitActionList().spliterator(), false).map(Object::toString).collect(Collectors.toList());
            if (!acts.isEmpty()) {
                stateMap.put("exitActions", acts);
            }
            if (!(acts = Arrays.stream(stDef.getTransitions()).map(tr -> tr.getId() + " -> " + tr.getTargetStateId()).collect(Collectors.toList())).isEmpty()) {
                stateMap.put("transitions", acts);
            }
        }
        return stateMap;
    }

    @ReadOperation
    @Operation(summary="Get Spring webflow report using an optional flow id", parameters={@Parameter(name="flowId"), @Parameter(name="stateId")})
    public Map<?, ?> getReport(@Nullable String flowId, @Nullable String stateId) {
        LinkedHashMap jsonMap = new LinkedHashMap();
        CasWebflowExecutionPlan executionPlan = (CasWebflowExecutionPlan)this.applicationContext.getBean("casWebflowExecutionPlan", CasWebflowExecutionPlan.class);
        executionPlan.execute();
        Map map = this.applicationContext.getBeansOfType(FlowDefinitionRegistry.class);
        map.forEach((k, value) -> Arrays.stream(value.getFlowDefinitionIds()).filter(currentId -> StringUtils.isBlank((CharSequence)flowId) || flowId.equalsIgnoreCase((String)currentId)).forEach(id -> {
            String vars;
            Flow flowDefinition = (Flow)value.getFlowDefinition(id);
            LinkedHashMap<String, Object> flowDetails = new LinkedHashMap<String, Object>();
            flowDetails.put("startState", flowDefinition.getStartState().getId());
            List startActions = StreamSupport.stream(flowDefinition.getStartActionList().spliterator(), false).map(SpringWebflowEndpoint::convertActionToString).collect(Collectors.toList());
            if (!startActions.isEmpty()) {
                flowDetails.put("startActions", startActions);
            }
            LinkedHashMap states = new LinkedHashMap();
            Arrays.stream(flowDefinition.getStateIds()).filter(st -> StringUtils.isBlank((CharSequence)stateId) || RegexUtils.find((String)stateId, (String)st)).forEach(st -> {
                Map<String, Object> stateMap = SpringWebflowEndpoint.getStateDetails(flowDefinition, st);
                states.put(st, stateMap);
            });
            flowDetails.put("states", states);
            flowDetails.put("possibleOutcomes", flowDefinition.getPossibleOutcomes());
            flowDetails.put("stateCount", flowDefinition.getStateCount());
            List acts = StreamSupport.stream(flowDefinition.getEndActionList().spliterator(), false).map(SpringWebflowEndpoint::convertActionToString).collect(Collectors.toList());
            if (!acts.isEmpty()) {
                flowDetails.put("endActions", acts);
            }
            if (!(acts = StreamSupport.stream(flowDefinition.getGlobalTransitionSet().spliterator(), false).map(tr -> tr.getId() + " -> " + tr.getTargetStateId() + " @ " + tr.getExecutionCriteria().toString()).collect(Collectors.toList())).isEmpty()) {
                flowDetails.put("globalTransitions", acts);
            }
            if (!(acts = Arrays.stream(flowDefinition.getExceptionHandlerSet().toArray()).map(Object::toString).collect(Collectors.toList())).isEmpty()) {
                flowDetails.put("exceptionHandlers", acts);
            }
            if (StringUtils.isNotBlank((CharSequence)(vars = Arrays.stream(flowDefinition.getVariables()).map(FlowVariable::getName).collect(Collectors.joining(","))))) {
                flowDetails.put("variables", vars);
            }
            jsonMap.put(id, flowDetails);
        }));
        return jsonMap;
    }
}

