/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.otp.web.flow;

import lombok.Generated;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.otp.util.QRUtils;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class OneTimeTokenAccountCreateRegistrationAction
extends AbstractMultifactorAuthenticationAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OneTimeTokenAccountCreateRegistrationAction.class);
    public static final String FLOW_SCOPE_ATTR_ACCOUNT = "key";
    public static final String FLOW_SCOPE_ATTR_QR_IMAGE_BASE64 = "QRcode";
    private final OneTimeTokenCredentialRepository repository;
    private final String label;
    private final String issuer;

    protected Event doExecute(RequestContext requestContext) throws Exception {
        Principal principal = this.resolvePrincipal(WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal());
        String uid = principal.getId();
        OneTimeTokenAccount keyAccount = this.repository.create(uid);
        String keyUri = "otpauth://totp/" + this.label + ":" + uid + "?secret=" + keyAccount.getSecretKey() + "&issuer=" + this.issuer;
        MutableAttributeMap flowScope = requestContext.getFlowScope();
        flowScope.put(FLOW_SCOPE_ATTR_ACCOUNT, (Object)keyAccount);
        String qrCodeBase64 = QRUtils.generateQRCode(keyUri, 250, 250);
        flowScope.put(FLOW_SCOPE_ATTR_QR_IMAGE_BASE64, (Object)qrCodeBase64);
        LOGGER.debug("Registration key URI is [{}]", (Object)keyUri);
        return new EventFactorySupport().event((Object)this, "register");
    }

    @Generated
    public OneTimeTokenAccountCreateRegistrationAction(OneTimeTokenCredentialRepository repository, String label, String issuer) {
        this.repository = repository;
        this.label = label;
        this.issuer = issuer;
    }
}

