/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.scimv2.api.data;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.common.util.StringUtils;
import org.apache.syncope.ext.scimv2.api.data.Member;
import org.apache.syncope.ext.scimv2.api.data.SCIMComplexValue;
import org.apache.syncope.ext.scimv2.api.data.SCIMEnterpriseInfo;
import org.apache.syncope.ext.scimv2.api.data.SCIMPatchOperation;
import org.apache.syncope.ext.scimv2.api.data.SCIMPatchPath;
import org.apache.syncope.ext.scimv2.api.data.SCIMUser;
import org.apache.syncope.ext.scimv2.api.data.SCIMUserAddress;
import org.apache.syncope.ext.scimv2.api.data.SCIMUserManager;
import org.apache.syncope.ext.scimv2.api.data.SCIMUserName;
import org.apache.syncope.ext.scimv2.api.data.Value;
import org.apache.syncope.ext.scimv2.api.type.PatchOp;

public class SCIMPatchOperationDeserializer
extends StdDeserializer<SCIMPatchOperation> {
    private static final long serialVersionUID = -7401353969242788372L;
    private static final Pattern PATH_PATTERN = Pattern.compile("^(?<schema>[A-Za-z0-9:.]+:)?(?<attribute>\\w+)(?<filter>\\[.*\\])?(?<sub>\\.\\w+)?");

    private static Serializable scalar(JsonNode v) {
        if (v.isNull()) {
            return null;
        }
        if (v.isBoolean()) {
            return Boolean.valueOf(v.booleanValue());
        }
        if (v.isFloat()) {
            return Float.valueOf(v.floatValue());
        }
        if (v.isDouble()) {
            return Double.valueOf(v.doubleValue());
        }
        if (v.isInt()) {
            return Integer.valueOf(v.intValue());
        }
        if (v.isShort()) {
            return Short.valueOf(v.shortValue());
        }
        if (v.isLong()) {
            return Long.valueOf(v.longValue());
        }
        return v.asText();
    }

    public SCIMPatchOperationDeserializer() {
        this(null);
    }

    public SCIMPatchOperationDeserializer(Class<?> vc) {
        super(vc);
    }

    public SCIMPatchOperation deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Matcher matcher;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        SCIMPatchOperation scimPatchOperation = new SCIMPatchOperation();
        if (node.has("op")) {
            scimPatchOperation.setOp(PatchOp.valueOf(node.get("op").asText().toLowerCase()));
        }
        if (node.has("path") && (matcher = PATH_PATTERN.matcher(node.get("path").asText())).matches()) {
            SCIMPatchPath path = new SCIMPatchPath();
            scimPatchOperation.setPath(path);
            Optional.ofNullable(matcher.group("schema")).ifPresent(schema -> path.setSchema(schema.substring(0, schema.length() - 1)));
            path.setAttribute(StringUtils.uncapitalize((String)matcher.group("attribute")));
            Optional.ofNullable(matcher.group("filter")).ifPresent(condition -> path.setFilter(condition.substring(1, condition.length() - 1)));
            Optional.ofNullable(matcher.group("sub")).ifPresent(sub -> path.setSub(StringUtils.uncapitalize((String)sub.substring(1))));
        }
        if (node.has("value")) {
            JsonNode value = node.get("value");
            if (scimPatchOperation.getPath() == null) {
                scimPatchOperation.setValue(List.of((Serializable)jp.getCodec().treeToValue((TreeNode)value, SCIMUser.class)));
            } else if ("members".equals(scimPatchOperation.getPath().getAttribute())) {
                scimPatchOperation.setValue(List.of((Serializable[])jp.getCodec().treeToValue((TreeNode)value, Member[].class)));
            } else if (value.isObject()) {
                SCIMUser user = new SCIMUser(null, List.of(), null, "userName".equals(scimPatchOperation.getPath().getAttribute()) ? value.asText() : null, "active".equals(scimPatchOperation.getPath().getAttribute()) ? Boolean.valueOf(value.asBoolean()) : null);
                user.setEnterpriseInfo(new SCIMEnterpriseInfo());
                switch (scimPatchOperation.getPath().getAttribute()) {
                    case "externalId": {
                        user.setExternalId(value.asText());
                        break;
                    }
                    case "name": {
                        user.setName((SCIMUserName)jp.getCodec().treeToValue((TreeNode)value, SCIMUserName.class));
                        break;
                    }
                    case "displayName": {
                        user.setDisplayName(value.asText());
                        break;
                    }
                    case "nickName": {
                        user.setNickName(value.asText());
                        break;
                    }
                    case "profileUrl": {
                        user.setProfileUrl(value.asText());
                        break;
                    }
                    case "title": {
                        user.setTitle(value.asText());
                        break;
                    }
                    case "userType": {
                        user.setUserType(value.asText());
                        break;
                    }
                    case "preferredLanguage": {
                        user.setPreferredLanguage(value.asText());
                        break;
                    }
                    case "locale": {
                        user.setLocale(value.asText());
                        break;
                    }
                    case "timezone": {
                        user.setTimezone(value.asText());
                        break;
                    }
                    case "emails": {
                        user.getEmails().add((SCIMComplexValue)jp.getCodec().treeToValue((TreeNode)value, SCIMComplexValue.class));
                        break;
                    }
                    case "phoneNumbers": {
                        user.getPhoneNumbers().add((SCIMComplexValue)jp.getCodec().treeToValue((TreeNode)value, SCIMComplexValue.class));
                        break;
                    }
                    case "ims": {
                        user.getIms().add((SCIMComplexValue)jp.getCodec().treeToValue((TreeNode)value, SCIMComplexValue.class));
                        break;
                    }
                    case "photos": {
                        user.getPhotos().add((SCIMComplexValue)jp.getCodec().treeToValue((TreeNode)value, SCIMComplexValue.class));
                        break;
                    }
                    case "addresses": {
                        user.getAddresses().add((SCIMUserAddress)jp.getCodec().treeToValue((TreeNode)value, SCIMUserAddress.class));
                        break;
                    }
                    case "x509Certificates": {
                        user.getX509Certificates().add((Value)jp.getCodec().treeToValue((TreeNode)value, Value.class));
                        break;
                    }
                    case "employeeNumber": {
                        user.getEnterpriseInfo().setEmployeeNumber(value.asText());
                        break;
                    }
                    case "costCenter": {
                        user.getEnterpriseInfo().setCostCenter(value.asText());
                        break;
                    }
                    case "organization": {
                        user.getEnterpriseInfo().setOrganization(value.asText());
                        break;
                    }
                    case "division": {
                        user.getEnterpriseInfo().setDivision(value.asText());
                        break;
                    }
                    case "department": {
                        user.getEnterpriseInfo().setDepartment(value.asText());
                        break;
                    }
                    case "manager": {
                        user.getEnterpriseInfo().setManager((SCIMUserManager)jp.getCodec().treeToValue((TreeNode)value, SCIMUserManager.class));
                        break;
                    }
                }
                scimPatchOperation.setValue(List.of(user));
            } else if (!value.isContainerNode()) {
                scimPatchOperation.setValue(List.of(SCIMPatchOperationDeserializer.scalar(value)));
            }
        }
        return scimPatchOperation;
    }
}

