/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.flow.SingleSignOnParticipationRequest;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedAuthenticationSingleSignOnEvaluator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationSingleSignOnEvaluator.class);
    private final DelegatedClientAuthenticationConfigurationContext configurationContext;

    public boolean singleSignOnSessionAuthorizedForService(RequestContext requestContext) {
        Service resolvedService = this.resolveServiceFromRequestContext(requestContext);
        Optional<Authentication> authentication = this.getSingleSignOnAuthenticationFrom(requestContext);
        Boolean authorized = authentication.map(authn -> this.configurationContext.getDelegatedClientIdentityProviderAuthorizers().stream().allMatch(authz -> authz.isDelegatedClientAuthorizedForAuthentication(authn, resolvedService, requestContext))).orElse(Boolean.FALSE);
        SingleSignOnParticipationStrategy strategy = this.configurationContext.getSingleSignOnParticipationStrategy();
        SingleSignOnParticipationRequest ssoRequest = SingleSignOnParticipationRequest.builder().requestContext(requestContext).build();
        return authorized != false && strategy.supports(ssoRequest) && strategy.isParticipating(ssoRequest);
    }

    public Service resolveServiceFromRequestContext(RequestContext context) {
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        return this.configurationContext.getAuthenticationRequestServiceSelectionStrategies().resolveService((Service)service);
    }

    private Optional<Authentication> getSingleSignOnAuthenticationFrom(RequestContext requestContext) {
        String tgtId = WebUtils.getTicketGrantingTicketId((RequestContext)requestContext);
        if (StringUtils.isBlank((CharSequence)tgtId)) {
            LOGGER.trace("No ticket-granting ticket could be located in the webflow context");
            return Optional.empty();
        }
        TicketGrantingTicket ticket = (TicketGrantingTicket)this.configurationContext.getTicketRegistry().getTicket(tgtId, TicketGrantingTicket.class);
        LOGGER.trace("Located a valid ticket-granting ticket");
        return Optional.of(ticket.getAuthentication());
    }

    public boolean singleSignOnSessionExists(RequestContext requestContext) {
        try {
            Optional<Authentication> authn = this.getSingleSignOnAuthenticationFrom(requestContext);
            if (authn.isPresent()) {
                LOGGER.trace("Located a valid ticket-granting ticket. Examining existing single sign-on session strategies...");
                Authentication authentication = authn.get();
                AuthenticationResultBuilder builder = this.configurationContext.getAuthenticationSystemSupport().establishAuthenticationContextFromInitial(authentication);
                LOGGER.trace("Recording and tracking initial authentication results in the request context");
                WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)builder, (RequestContext)requestContext);
                WebUtils.putAuthentication((Authentication)authentication, (RequestContext)requestContext);
                SingleSignOnParticipationStrategy strategy = this.configurationContext.getSingleSignOnParticipationStrategy();
                SingleSignOnParticipationRequest ssoRequest = SingleSignOnParticipationRequest.builder().requestContext(requestContext).build();
                return strategy.supports(ssoRequest) && strategy.isParticipating(ssoRequest);
            }
        }
        catch (AbstractTicketException e) {
            LOGGER.trace("Could not retrieve ticket id [{}] from registry.", (Object)e.getMessage());
        }
        LOGGER.trace("Ticket-granting ticket found in the webflow context is invalid or has expired");
        return false;
    }

    @Generated
    public DelegatedAuthenticationSingleSignOnEvaluator(DelegatedClientAuthenticationConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    @Generated
    public DelegatedClientAuthenticationConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }
}

