/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.azure;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.microsoft.graph.models.AssignedLicense;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.DirectoryObjectCollectionResponse;
import com.microsoft.graph.models.Group;
import com.microsoft.graph.models.GroupCollectionResponse;
import com.microsoft.graph.models.ProvisionedPlan;
import com.microsoft.graph.models.SubscribedSku;
import com.microsoft.graph.models.User;
import com.microsoft.graph.models.UserCollectionResponse;
import com.microsoft.graph.users.item.assignlicense.AssignLicensePostRequestBody;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.tirasa.connid.bundles.azure.AzureConnectorConfiguration;
import net.tirasa.connid.bundles.azure.AzureFilterTranslator;
import net.tirasa.connid.bundles.azure.service.AzureClient;
import net.tirasa.connid.bundles.azure.utils.AzureAttributes;
import net.tirasa.connid.bundles.azure.utils.AzureFilter;
import net.tirasa.connid.bundles.azure.utils.AzureFilterOp;
import net.tirasa.connid.bundles.azure.utils.AzureUtils;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.PredefinedAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

@ConnectorClass(displayNameKey="AzureConnector.connector.display", configurationClass=AzureConnectorConfiguration.class)
public class AzureConnector
implements Connector,
CreateOp,
DeleteOp,
SchemaOp,
SearchOp<AzureFilter>,
TestOp,
UpdateOp {
    private static final Log LOG = Log.getLog(AzureConnector.class);
    private AzureConnectorConfiguration configuration;
    private Schema schema;
    private AzureClient client;

    private static void doUserSetAttribute(String name, List<Object> values, User user) {
        Object value = values.isEmpty() ? null : values.get(0);
        switch (name) {
            case "displayName": {
                user.setDisplayName((String)value);
                break;
            }
            case "id": {
                user.setId((String)value);
                break;
            }
            case "city": {
                user.setCity((String)value);
                break;
            }
            case "country": {
                user.setCountry((String)value);
                break;
            }
            case "department": {
                user.setDepartment((String)value);
                break;
            }
            case "businessPhones": {
                user.setBusinessPhones(new ArrayList<Object>(values));
                break;
            }
            case "givenName": {
                user.setGivenName((String)value);
                break;
            }
            case "onPremisesImmutableId": {
                user.setOnPremisesImmutableId((String)value);
                break;
            }
            case "jobTitle": {
                user.setJobTitle((String)value);
                break;
            }
            case "mail": {
                user.setMail((String)value);
                break;
            }
            case "mobilePhone": {
                user.setMobilePhone((String)value);
                break;
            }
            case "passwordPolicies": {
                user.setPasswordPolicies((String)value);
                break;
            }
            case "preferredLanguage": {
                user.setPreferredLanguage((String)value);
                break;
            }
            case "officeLocation": {
                user.setOfficeLocation((String)value);
                break;
            }
            case "postalCode": {
                user.setPostalCode((String)value);
                break;
            }
            case "state": {
                user.setState((String)value);
                break;
            }
            case "streetAddress": {
                user.setStreetAddress((String)value);
                break;
            }
            case "surname": {
                user.setSurname((String)value);
                break;
            }
            case "usageLocation": {
                user.setUsageLocation((String)value);
                break;
            }
            case "userPrincipalName": {
                user.setUserPrincipalName((String)value);
                break;
            }
            case "companyName": {
                user.setCompanyName((String)value);
                break;
            }
            case "creationType": {
                user.setCreationType((String)value);
                break;
            }
            case "employeeId": {
                user.setEmployeeId((String)value);
                break;
            }
            case "onPremisesDistinguishedName": {
                user.setOnPremisesDistinguishedName((String)value);
                break;
            }
            case "onPremisesSecurityIdentifier": {
                user.setOnPremisesSecurityIdentifier((String)value);
                break;
            }
            case "showInAddressList": {
                user.setShowInAddressList((Boolean)value);
                break;
            }
            case "proxyAddresses": {
                user.setProxyAddresses(new ArrayList<Object>(values));
                break;
            }
            case "userType": {
                user.setUserType((String)value);
                break;
            }
            case "otherMails": {
                user.setOtherMails(new ArrayList<Object>(values));
                break;
            }
            case "provisionedPlans": {
                user.setProvisionedPlans(new ArrayList<Object>(values));
                break;
            }
            case "assignedLicenses": {
                user.setAssignedLicenses(new ArrayList<Object>(values));
                break;
            }
            case "assignedPlans": {
                user.setAssignedPlans(new ArrayList<Object>(values));
                break;
            }
        }
    }

    private static void doGroupSetAttribute(String name, List<Object> values, Group group) {
        Object value = values.isEmpty() ? null : values.get(0);
        switch (name) {
            case "id": {
                group.setId((String)value);
                break;
            }
            case "mail": {
                group.setMail((String)value);
                break;
            }
            case "mailEnabled": {
                group.setMailEnabled((Boolean)value);
                break;
            }
            case "onPremisesSecurityIdentifier": {
                group.setOnPremisesSecurityIdentifier((String)value);
                break;
            }
            case "proxyAddresses": {
                group.setProxyAddresses(new ArrayList<Object>(values));
                break;
            }
            case "description": {
                group.setDescription((String)value);
                break;
            }
            case "securityEnabled": {
                group.setSecurityEnabled((Boolean)value);
                break;
            }
            case "classification": {
                group.setClassification((String)value);
                break;
            }
            case "groupTypes": {
                group.setGroupTypes(new ArrayList<Object>(values));
                break;
            }
            case "preferredLanguage": {
                group.setPreferredLanguage((String)value);
                break;
            }
            case "securityIdentifier": {
                group.setSecurityIdentifier((String)value);
                break;
            }
            case "theme": {
                group.setTheme((String)value);
                break;
            }
            case "visibility": {
                group.setVisibility((String)value);
                break;
            }
            case "mailNickname": {
                group.setMailNickname((String)value);
                break;
            }
            case "displayName": {
                group.setDisplayName((String)value);
                break;
            }
            case "allowExternalSenders": {
                group.setAllowExternalSenders((Boolean)value);
                break;
            }
            case "autoSubscribeNewMembers": {
                group.setAutoSubscribeNewMembers((Boolean)value);
                break;
            }
            case "preferredDataLocation": {
                group.setPreferredDataLocation((String)value);
                break;
            }
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void init(Configuration configuration) {
        LOG.ok("Init", new Object[0]);
        this.configuration = (AzureConnectorConfiguration)configuration;
        this.configuration.validate();
        this.client = new AzureClient(this.configuration);
        LOG.ok("Connector {0} successfully inited", new Object[]{this.getClass().getName()});
    }

    public void dispose() {
        LOG.ok("Configuration cleanup", new Object[0]);
        this.configuration = null;
    }

    public void test() {
        LOG.ok("connector TEST", new Object[0]);
        if (this.configuration != null) {
            if (this.client.getAuthenticated() != null) {
                LOG.ok("Test was successful", new Object[0]);
            } else {
                AzureUtils.handleGeneralError("Test error. Problems with client service");
            }
        } else {
            LOG.error("Error with establishing connection while testing. No instance of the configuration class", new Object[0]);
        }
    }

    public Schema schema() {
        LOG.ok("Building SCHEMA definition", new Object[0]);
        if (this.schema == null) {
            this.schema = AzureAttributes.buildSchema();
        }
        return this.schema;
    }

    public FilterTranslator<AzureFilter> createFilterTranslator(ObjectClass objectClass, OperationOptions options) {
        LOG.ok("check the ObjectClass", new Object[0]);
        if (objectClass == null) {
            throw new IllegalArgumentException("Object class not supported");
        }
        LOG.ok("The ObjectClass is ok", new Object[0]);
        return new AzureFilterTranslator(objectClass);
    }

    public void executeQuery(ObjectClass objectClass, AzureFilter query, ResultsHandler handler, OperationOptions options) {
        LOG.ok("Connector READ", new Object[0]);
        Attribute key = null;
        boolean moreFilters = true;
        if (query != null) {
            Attribute filterAttr = query.getAttribute();
            if (filterAttr instanceof Uid) {
                key = filterAttr;
            } else if (ObjectClass.ACCOUNT.equals((Object)objectClass) || ObjectClass.GROUP.equals((Object)objectClass)) {
                key = filterAttr;
            }
            if (key == null && !query.getFilters().isEmpty()) {
                moreFilters = false;
            }
        }
        HashSet<String> attributesToGet = new HashSet<String>();
        if (options.getAttributesToGet() != null) {
            attributesToGet.addAll(Arrays.asList(options.getAttributesToGet()));
        }
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            if (key == null && moreFilters) {
                List users = null;
                int remainingResults = -1;
                int pagesSize = options.getPageSize() != null ? options.getPageSize() : -1;
                String cookie = options.getPagedResultsCookie();
                try {
                    if (pagesSize != -1) {
                        UserCollectionResponse response = StringUtil.isNotBlank((String)cookie) ? this.client.getAuthenticated().getAllUsersNextPage(cookie) : this.client.getAuthenticated().getAllUsers(pagesSize);
                        users = response.getValue();
                        cookie = response.getOdataNextLink();
                    } else {
                        users = this.client.getAuthenticated().getAllUsers();
                    }
                }
                catch (Exception e) {
                    AzureUtils.wrapGeneralError("While getting Users!", e);
                }
                if (users != null) {
                    users.forEach(user -> handler.handle(this.fromUser((User)user, (Set<String>)attributesToGet)));
                }
                if (handler instanceof SearchResultsHandler) {
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(cookie, remainingResults));
                }
            } else if (AzureFilterOp.EQUALS == query.getFilterOp() && (Uid.NAME.equals(key.getName()) || "objectId".equals(key.getName()))) {
                User result = null;
                try {
                    result = this.client.getAuthenticated().getUser(AttributeUtil.getAsStringValue((Attribute)key));
                }
                catch (Exception e) {
                    AzureUtils.wrapGeneralError("While getting User : " + key.getName() + " - " + AttributeUtil.getAsStringValue((Attribute)key), e);
                }
                if (result != null) {
                    handler.handle(this.fromUser(result, attributesToGet));
                }
            } else {
                List<User> result = null;
                try {
                    result = this.client.getAuthenticated().getUsersFilteredBy(query);
                }
                catch (Exception e) {
                    AzureUtils.wrapGeneralError("While searching with key : " + key.getName() + " - " + AttributeUtil.getAsStringValue((Attribute)key), e);
                }
                if (result != null) {
                    result.forEach(user -> handler.handle(this.fromUser((User)user, (Set<String>)attributesToGet)));
                }
            }
        } else if (ObjectClass.GROUP.equals((Object)objectClass)) {
            if (key == null && moreFilters) {
                List groups = null;
                int remainingResults = -1;
                int pagesSize = options.getPageSize() != null ? options.getPageSize() : -1;
                String cookie = options.getPagedResultsCookie();
                try {
                    if (pagesSize != -1) {
                        GroupCollectionResponse response = StringUtil.isNotBlank((String)cookie) ? this.client.getAuthenticated().getAllGroupsNextPage(cookie) : this.client.getAuthenticated().getAllGroups(pagesSize);
                        groups = response.getValue();
                        cookie = response.getOdataNextLink();
                    } else {
                        groups = this.client.getAuthenticated().getAllGroups();
                    }
                }
                catch (Exception e) {
                    AzureUtils.wrapGeneralError("While getting Groups!", e);
                }
                if (groups != null) {
                    groups.forEach(group -> handler.handle(this.fromGroup((Group)group, (Set<String>)attributesToGet)));
                }
                if (handler instanceof SearchResultsHandler) {
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(cookie, remainingResults));
                }
            } else if (AzureFilterOp.EQUALS == query.getFilterOp() && (Uid.NAME.equals(key.getName()) || "objectId".equals(key.getName()))) {
                Group result = null;
                try {
                    result = this.client.getAuthenticated().getGroup(AttributeUtil.getAsStringValue((Attribute)key));
                }
                catch (Exception e) {
                    AzureUtils.wrapGeneralError("While getting Group!", e);
                }
                if (result != null) {
                    handler.handle(this.fromGroup(result, attributesToGet));
                }
            } else {
                List<Group> result = null;
                try {
                    result = this.client.getAuthenticated().getGroupsFilteredBy(query);
                }
                catch (Exception e) {
                    AzureUtils.wrapGeneralError("While searching with key : " + key.getName() + " - " + AttributeUtil.getAsStringValue((Attribute)key), e);
                }
                if (result != null) {
                    result.forEach(group -> handler.handle(this.fromGroup((Group)group, (Set<String>)attributesToGet)));
                }
            }
        } else if (new ObjectClass("azureLicense").equals((Object)objectClass)) {
            if (key == null) {
                List<SubscribedSku> subscribedSkus = null;
                try {
                    subscribedSkus = this.client.getAuthenticated().getCurrentTenantSubscriptions();
                }
                catch (Exception e) {
                    AzureUtils.wrapGeneralError("While getting subscriptions!", e);
                }
                if (subscribedSkus != null) {
                    for (SubscribedSku subscribedSku : subscribedSkus) {
                        handler.handle(this.fromLicense(subscribedSku, attributesToGet));
                    }
                }
                if (handler instanceof SearchResultsHandler) {
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(null, -1));
                }
            }
        } else {
            LOG.warn("Search of type " + objectClass.getObjectClassValue() + " is not supported", new Object[0]);
            throw new UnsupportedOperationException("Search of type" + objectClass.getObjectClassValue() + " is not supported");
        }
    }

    public Uid create(ObjectClass objectClass, Set<Attribute> createAttributes, OperationOptions options) {
        LOG.ok("Connector CREATE", new Object[0]);
        if (CollectionUtil.isEmpty(createAttributes)) {
            AzureUtils.handleGeneralError("Set of Attributes value is null or empty");
        }
        AttributesAccessor accessor = new AttributesAccessor(createAttributes);
        String id = accessor.findString("objectId");
        if (this.configuration.getRestoreItems() && id != null && this.client.getDeletedDirectoryObject(id) != null) {
            DirectoryObject directoryObject = this.client.restoreDirectoryObject(id);
            return new Uid(directoryObject.getId());
        }
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            User user = new User();
            User createdUser = new User();
            String username = accessor.findString("mailNickname");
            if (username == null) {
                username = accessor.findString(Name.NAME);
            }
            List licenses = accessor.findList("azureLicense");
            user.setDisplayName(accessor.findString("displayName"));
            user.setMailNickname(username);
            accessor.getPassword().access(pwd -> user.setPasswordProfile(AzureUtils.createPassword(new String(pwd))));
            user.setAccountEnabled(Boolean.valueOf(accessor.getEnabled(true)));
            createAttributes.stream().filter(attribute -> attribute.getValue() != null).forEach(attribute -> AzureConnector.doUserSetAttribute(attribute.getName(), attribute.getValue(), user));
            try {
                createdUser = this.client.getAuthenticated().createUser(user);
            }
            catch (Exception e) {
                AzureUtils.wrapGeneralError("Could not create User : " + username, e);
            }
            List groups = accessor.findList(PredefinedAttributes.GROUPS_NAME);
            if (!CollectionUtil.isEmpty((Collection)groups)) {
                for (Object group : groups) {
                    try {
                        this.client.getAuthenticated().addUserToGroup(createdUser.getId(), group.toString());
                    }
                    catch (Exception e) {
                        LOG.error("Could not add User {0} to Group {1} ", new Object[]{createdUser.getId(), group, e});
                    }
                }
            }
            if (!CollectionUtil.isEmpty((Collection)licenses)) {
                for (Object license : licenses) {
                    AssignedLicense assignedLicense = new AssignedLicense();
                    assignedLicense.setSkuId(UUID.fromString(license.toString()));
                    AssignLicensePostRequestBody body = new AssignLicensePostRequestBody();
                    body.setAddLicenses(Collections.singletonList(assignedLicense));
                    try {
                        this.client.getAuthenticated().assignLicense(createdUser.getId(), body);
                    }
                    catch (RuntimeException ex) {
                        LOG.error("While assigning license {0} to user {1}", new Object[]{license, createdUser, ex});
                    }
                }
            }
            return new Uid(createdUser.getId());
        }
        if (ObjectClass.GROUP.equals((Object)objectClass)) {
            String groupName = accessor.findString("mailNickname");
            if (groupName == null) {
                groupName = accessor.findString(Name.NAME);
            }
            String displayName = accessor.findString("displayName");
            Group group = new Group();
            group.setDisplayName(displayName);
            group.setMailNickname(groupName);
            createAttributes.stream().filter(attribute -> attribute.getValue() != null).forEach(attribute -> AzureConnector.doGroupSetAttribute(attribute.getName(), attribute.getValue(), group));
            try {
                return new Uid(this.client.getAuthenticated().createGroup(group).getId());
            }
            catch (Exception e) {
                AzureUtils.wrapGeneralError("Could not create Group : " + groupName, e);
            }
        }
        LOG.warn("Create of type " + objectClass.getObjectClassValue() + " is not supported", new Object[0]);
        throw new UnsupportedOperationException("Create of type" + objectClass.getObjectClassValue() + " is not supported");
    }

    public void delete(ObjectClass objectClass, Uid uid, OperationOptions options) {
        LOG.ok("Connector DELETE", new Object[0]);
        if (StringUtil.isBlank((String)uid.getUidValue())) {
            LOG.error("Uid not provided or empty ", new Object[0]);
            throw new InvalidAttributeValueException("Uid value not provided or empty");
        }
        if (objectClass == null) {
            LOG.error("Object value not provided ", new Object[0]);
            throw new InvalidAttributeValueException("Object value not provided");
        }
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            try {
                DirectoryObjectCollectionResponse groups = this.client.getAuthenticated().getAllGroupsForUser(uid.getUidValue());
                while (groups != null) {
                    groups.getValue().stream().filter(Group.class::isInstance).map(Group.class::cast).forEach(group -> this.client.getAuthenticated().deleteUserFromGroup(uid.getUidValue(), group.getId()));
                    String odataNextLink = groups.getOdataNextLink();
                    if (odataNextLink != null && !odataNextLink.isEmpty()) {
                        groups = this.client.getAuthenticated().getAllGroupsForUser(uid.getUidValue(), odataNextLink);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                LOG.error("Could not delete User {0} from Groups", new Object[]{uid.getUidValue()});
            }
            try {
                this.client.getAuthenticated().deleteUser(uid.getUidValue());
            }
            catch (Exception e) {
                AzureUtils.wrapGeneralError("Could not delete User " + uid.getUidValue(), e);
            }
        } else if (ObjectClass.GROUP.equals((Object)objectClass)) {
            try {
                this.client.getAuthenticated().deleteGroup(uid.getUidValue());
            }
            catch (Exception e) {
                AzureUtils.wrapGeneralError("Could not delete Group " + uid.getUidValue(), e);
            }
        } else {
            LOG.warn("Delete of type " + objectClass.getObjectClassValue() + " is not supported", new Object[0]);
            throw new UnsupportedOperationException("Delete of type" + objectClass.getObjectClassValue() + " is not supported");
        }
    }

    public Uid update(ObjectClass objectClass, Uid uid, Set<Attribute> replaceAttributes, OperationOptions options) {
        LOG.ok("Connector UPDATE", new Object[0]);
        if (replaceAttributes == null || replaceAttributes.isEmpty()) {
            AzureUtils.handleGeneralError("Set of Attributes value is null or empty");
        }
        AttributesAccessor accessor = new AttributesAccessor(replaceAttributes);
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            Object odataNextLink;
            Object groups;
            Uid returnUid = uid;
            String displayName = accessor.findString("displayName");
            Attribute status = accessor.find("accountEnabled");
            List licenses = accessor.findList("azureLicense");
            if (displayName == null) {
                AzureUtils.handleGeneralError("The displayName property cannot be cleared during updates");
            }
            User user = new User();
            user.setId(uid.getUidValue());
            if (status == null || status.getValue() == null || status.getValue().isEmpty()) {
                LOG.warn("{0} attribute value not correct, can't handle User status update", new Object[]{OperationalAttributes.ENABLE_NAME});
            } else {
                user.setAccountEnabled(Boolean.valueOf(status.getValue().get(0).toString()));
            }
            try {
                replaceAttributes.stream().filter(attribute -> attribute.getValue() != null).forEach(attribute -> AzureConnector.doUserSetAttribute(attribute.getName(), attribute.getValue(), user));
                if (accessor.getPassword() != null) {
                    accessor.getPassword().access(pwd -> user.setPasswordProfile(AzureUtils.createPassword(new String(pwd))));
                }
                this.client.getAuthenticated().updateUser(user);
                returnUid = new Uid(user.getId());
            }
            catch (Exception e) {
                AzureUtils.wrapGeneralError("Could not update User " + uid.getUidValue() + " from attributes ", e);
            }
            HashSet ownGroups = new HashSet();
            try {
                groups = this.client.getAuthenticated().getAllGroupsForUser(uid.getUidValue());
                while (groups != null) {
                    groups.getValue().stream().filter(Group.class::isInstance).map(Group.class::cast).forEach(group -> this.client.getAuthenticated().deleteUserFromGroup(uid.getUidValue(), group.getId()));
                    odataNextLink = groups.getOdataNextLink();
                    if (odataNextLink != null && !((String)odataNextLink).isEmpty()) {
                        groups = this.client.getAuthenticated().getAllGroupsForUser(uid.getUidValue(), (String)odataNextLink);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex, "Could not list groups for User {0}", new Object[]{uid.getUidValue()});
            }
            groups = CollectionUtil.nullAsEmpty((List)accessor.findList(PredefinedAttributes.GROUPS_NAME));
            odataNextLink = groups.iterator();
            while (odataNextLink.hasNext()) {
                Object group2 = odataNextLink.next();
                if (ownGroups.contains(group2.toString())) continue;
                try {
                    this.client.getAuthenticated().addUserToGroup(returnUid.getUidValue(), group2.toString());
                    LOG.ok("User added to Group: {0} after update", new Object[]{group2});
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, "Could not add User {0} to Group {1} ", new Object[]{returnUid.getUidValue(), group2});
                }
            }
            for (Object group2 : ownGroups) {
                if (groups.contains(group2)) continue;
                try {
                    this.client.getAuthenticated().deleteUserFromGroup(returnUid.getUidValue(), (String)group2);
                    LOG.ok("User removed from group: {0} after update", new Object[]{group2});
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, "Could not remove Group {0} from User {1} ", new Object[]{group2, returnUid.getUidValue()});
                }
            }
            User updatedUser = this.client.getAuthenticated().getUser(returnUid.getUidValue());
            if (updatedUser == null) {
                LOG.error("While reading user {0} after update in order to handle licenses update", new Object[]{returnUid.getUidValue()});
            } else {
                ArrayList<UUID> assignedSkuIds = new ArrayList<UUID>();
                if (updatedUser.getAssignedLicenses() != null) {
                    for (AssignedLicense assignedLicense : updatedUser.getAssignedLicenses()) {
                        assignedSkuIds.add(assignedLicense.getSkuId());
                    }
                }
                if (CollectionUtil.isEmpty((Collection)licenses)) {
                    if (!assignedSkuIds.isEmpty()) {
                        AssignLicensePostRequestBody body = new AssignLicensePostRequestBody();
                        body.setRemoveLicenses(assignedSkuIds);
                        try {
                            this.client.getAuthenticated().assignLicense(user.getId(), body);
                        }
                        catch (RuntimeException ex) {
                            LOG.error((Throwable)ex, "While removing licenses from user {0}", new Object[]{user});
                        }
                    }
                } else {
                    ArrayList<UUID> toRemove = new ArrayList<UUID>();
                    ArrayList<UUID> newLicenses = new ArrayList<UUID>();
                    for (Object license : licenses) {
                        newLicenses.add(UUID.fromString(license.toString()));
                    }
                    for (UUID assignedSkuId : assignedSkuIds) {
                        if (newLicenses.contains(assignedSkuId)) continue;
                        toRemove.add(assignedSkuId);
                    }
                    for (UUID newLicense : newLicenses) {
                        if (assignedSkuIds.contains(newLicense)) continue;
                        AssignedLicense assignedLicense = new AssignedLicense();
                        assignedLicense.setSkuId(newLicense);
                        AssignLicensePostRequestBody body = new AssignLicensePostRequestBody();
                        body.setAddLicenses(Collections.singletonList(assignedLicense));
                        try {
                            this.client.getAuthenticated().assignLicense(user.getId(), body);
                        }
                        catch (RuntimeException ex) {
                            LOG.error((Throwable)ex, "While assigning license {0} to user {1}", new Object[]{newLicense, user});
                        }
                    }
                    if (!toRemove.isEmpty()) {
                        AssignLicensePostRequestBody body = new AssignLicensePostRequestBody();
                        body.setRemoveLicenses(toRemove);
                        try {
                            this.client.getAuthenticated().assignLicense(user.getId(), body);
                        }
                        catch (RuntimeException ex) {
                            LOG.error((Throwable)ex, "While removing licenses from user {0}", new Object[]{user});
                        }
                    }
                }
            }
            return returnUid;
        }
        if (ObjectClass.GROUP.equals((Object)objectClass)) {
            Uid returnUid = uid;
            String groupID = accessor.findString("objectId");
            if (groupID == null) {
                groupID = accessor.findString(Name.NAME);
            }
            String mailNickname = accessor.findString("mailNickname");
            String displayName = accessor.findString("displayName");
            Group group3 = new Group();
            group3.setId(uid.getUidValue());
            if (!uid.getUidValue().equals(groupID)) {
                LOG.info("Update - uid value different from Group ID", new Object[0]);
                group3.setMailNickname(mailNickname);
                group3.setDisplayName(displayName);
            }
            try {
                replaceAttributes.stream().filter(attribute -> attribute.getValue() != null).forEach(attribute -> AzureConnector.doGroupSetAttribute(attribute.getName(), attribute.getValue(), group3));
                this.client.getAuthenticated().updateGroup(group3);
                returnUid = new Uid(group3.getId());
            }
            catch (Exception e) {
                AzureUtils.wrapGeneralError("Could not update Group " + uid.getUidValue() + " from attributes ", e);
            }
            return returnUid;
        }
        LOG.warn("Update of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
        throw new UnsupportedOperationException("Update of type" + objectClass.getObjectClassValue() + " is not supported");
    }

    public AzureClient getClient() {
        return this.client;
    }

    private ConnectorObject fromUser(User user, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(ObjectClass.ACCOUNT);
        builder.setUid(user.getId());
        builder.setName(user.getUserPrincipalName());
        try {
            HashSet<Attribute> attrs = new HashSet<Attribute>();
            Field[] fields = User.class.getDeclaredFields();
            block68: for (Field field : fields) {
                if (field.getAnnotation(JsonIgnore.class) != null) continue;
                field.setAccessible(true);
                if (field.getName().equals("passwordProfile") && user.getPasswordProfile() != null && user.getPasswordProfile().getPassword() != null) {
                    attrs.add(AttributeBuilder.build((String)"passwordProfile", (Object[])new Object[]{new GuardedString(user.getPasswordProfile().getPassword().toCharArray())}));
                    continue;
                }
                if (field.getName().equals("accountEnabled") && user.getAccountEnabled() != null) {
                    attrs.add(AttributeBuilder.build((String)"accountEnabled", (Object[])new Object[]{user.getAccountEnabled()}));
                    continue;
                }
                switch (field.getName()) {
                    case "displayName": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getDisplayName(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "id": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getId(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "userPrincipalName": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getUserPrincipalName(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "city": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getCity(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "country": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getCountry(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "department": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getDepartment(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "businessPhones": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getBusinessPhones(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "givenName": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getGivenName(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "onPremisesImmutableId": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getOnPremisesImmutableId(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "jobTitle": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getJobTitle(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "mail": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getMail(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "mobilePhone": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getMobilePhone(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "preferredLanguage": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getPreferredLanguage(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "officeLocation": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getOfficeLocation(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "postalCode": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getPostalCode(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "state": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getState(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "streetAddress": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getStreetAddress(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "surname": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getSurname(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "usageLocation": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getUsageLocation(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "companyName": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getCompanyName(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "creationType": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getCreationType(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "employeeId": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getEmployeeId(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "onPremisesDistinguishedName": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getOnPremisesDistinguishedName(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "onPremisesSecurityIdentifier": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getOnPremisesSecurityIdentifier(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "showInAddressList": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getShowInAddressList(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "proxyAddresses": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getProxyAddresses(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "userType": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getUserType(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "otherMails": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.getOtherMails(), field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "provisionedPlans": {
                        List provisionedPlans = user.getProvisionedPlans() == null ? null : user.getProvisionedPlans().stream().map(ProvisionedPlan::getService).collect(Collectors.toList());
                        new AttributeBuilder();
                        attrs.add(AttributeBuilder.build((String)field.getName(), provisionedPlans));
                        continue block68;
                    }
                    case "assignedLicenses": {
                        List assignedLicenses = user.getAssignedLicenses() == null ? null : user.getAssignedLicenses().stream().map(assignedLicense -> assignedLicense.getSkuId() == null ? "" : assignedLicense.getSkuId().toString()).collect(Collectors.toList());
                        new AttributeBuilder();
                        attrs.add(AttributeBuilder.build((String)field.getName(), assignedLicenses));
                        continue block68;
                    }
                    case "assignedPlans": {
                        List assignedPlans = user.getAssignedPlans() == null ? null : user.getAssignedPlans().stream().map(assignedPlan -> assignedPlan.getServicePlanId() == null ? "" : assignedPlan.getServicePlanId().toString()).collect(Collectors.toList());
                        new AttributeBuilder();
                        attrs.add(AttributeBuilder.build((String)field.getName(), assignedPlans));
                        continue block68;
                    }
                }
            }
            block69: for (Attribute toAttribute : attrs) {
                String attributeName = toAttribute.getName();
                for (String attributeToGetName : attributesToGet) {
                    if (OperationalAttributes.ENABLE_NAME.equals(attributeToGetName) && "accountEnabled".equals(attributeName)) {
                        builder.addAttribute(OperationalAttributes.ENABLE_NAME, (Collection)toAttribute.getValue());
                        continue block69;
                    }
                    if (!attributeName.equals(attributeToGetName)) continue;
                    builder.addAttribute(new Attribute[]{toAttribute});
                    continue block69;
                }
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.error((Throwable)ex, "While converting to attributes", new Object[0]);
        }
        if (attributesToGet.contains(PredefinedAttributes.GROUPS_NAME)) {
            DirectoryObjectCollectionResponse groups = this.client.getAuthenticated().getAllGroupsForUser(user.getId());
            ArrayList groupNames = new ArrayList();
            while (groups != null) {
                groups.getValue().stream().filter(Group.class::isInstance).map(Group.class::cast).forEach(group -> groupNames.add(group.getMailNickname()));
                String odataNextLink = groups.getOdataNextLink();
                if (odataNextLink == null || odataNextLink.isEmpty()) break;
                groups = this.client.getAuthenticated().getAllGroupsForUser(user.getId(), odataNextLink);
            }
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)PredefinedAttributes.GROUPS_NAME, groupNames)});
        }
        return builder.build();
    }

    private ConnectorObject fromGroup(Group group, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(ObjectClass.GROUP);
        builder.setUid(group.getId());
        builder.setName(group.getMailNickname());
        try {
            HashSet<Attribute> attrs = new HashSet<Attribute>();
            Field[] fields = Group.class.getDeclaredFields();
            block42: for (Field field : fields) {
                field.setAccessible(true);
                switch (field.getName()) {
                    case "id": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.getId(), field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "mail": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.getMail(), field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "mailEnabled": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.getMailEnabled(), field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "onPremisesSecurityIdentifier": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.getOnPremisesSecurityIdentifier(), field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "proxyAddresses": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.getProxyAddresses(), field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "description": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.getDescription(), field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "securityEnabled": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.getSecurityEnabled(), field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "classification": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.getClassification(), field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "groupTypes": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.getGroupTypes(), field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "preferredLanguage": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.getPreferredLanguage(), field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "securityIdentifier": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.getSecurityIdentifier(), field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "theme": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.getTheme(), field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "visibility": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.getVisibility(), field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "mailNickname": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.getMailNickname(), field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "displayName": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.getDisplayName(), field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "allowExternalSenders": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.getAllowExternalSenders(), field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "autoSubscribeNewMembers": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.getAutoSubscribeNewMembers(), field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "preferredDataLocation": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.getPreferredDataLocation(), field.getName(), field.getType()).build());
                        continue block42;
                    }
                }
            }
            block43: for (Attribute toAttribute : attrs) {
                String attributeName = toAttribute.getName();
                for (String attributeToGetName : attributesToGet) {
                    if (!attributeName.equals(attributeToGetName)) continue;
                    builder.addAttribute(new Attribute[]{toAttribute});
                    continue block43;
                }
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.error((Throwable)ex, "While converting to attributes", new Object[0]);
        }
        if (attributesToGet.contains("objectId")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"objectId", (Object[])new Object[]{group.getId()})});
        }
        if (attributesToGet.contains(PredefinedAttributes.GROUPS_NAME)) {
            List groupNames = this.client.getAuthenticated().getAllGroupsForGroup(group.getId()).stream().map(Group::getMailNickname).collect(Collectors.toList());
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)PredefinedAttributes.GROUPS_NAME, groupNames)});
        }
        return builder.build();
    }

    private ConnectorObject fromLicense(SubscribedSku subscribedSku, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(new ObjectClass("azureLicense"));
        builder.setUid(subscribedSku.getId());
        builder.setName(String.valueOf(subscribedSku.getSkuId()));
        try {
            HashSet<Attribute> attrs = new HashSet<Attribute>();
            Field[] fields = SubscribedSku.class.getDeclaredFields();
            block22: for (Field field : fields) {
                field.setAccessible(true);
                switch (field.getName()) {
                    case "id": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(subscribedSku.getId(), field.getName(), field.getType()).build());
                        continue block22;
                    }
                    case "appliesTo": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(subscribedSku.getAppliesTo(), field.getName(), field.getType()).build());
                        continue block22;
                    }
                    case "capabilityStatus": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(subscribedSku.getCapabilityStatus(), field.getName(), field.getType()).build());
                        continue block22;
                    }
                    case "consumedUnits": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(subscribedSku.getConsumedUnits(), field.getName(), field.getType()).build());
                        continue block22;
                    }
                    case "prepaidUnits": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(subscribedSku.getPrepaidUnits(), field.getName(), field.getType()).build());
                        continue block22;
                    }
                    case "servicePlans": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(subscribedSku.getServicePlans(), field.getName(), field.getType()).build());
                        continue block22;
                    }
                    case "skuPartNumber": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(subscribedSku.getSkuPartNumber(), field.getName(), field.getType()).build());
                        continue block22;
                    }
                    case "oDataType": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(subscribedSku.getOdataType(), field.getName(), field.getType()).build());
                        continue block22;
                    }
                }
            }
            block23: for (Attribute toAttribute : attrs) {
                String attributeName = toAttribute.getName();
                for (String attributeToGetName : attributesToGet) {
                    if (!attributeName.equals(attributeToGetName)) continue;
                    builder.addAttribute(new Attribute[]{toAttribute});
                    continue block23;
                }
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.error((Throwable)ex, "While converting to attributes", new Object[0]);
        }
        if (attributesToGet.contains("azureLicense")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"azureLicense", (Object[])new Object[]{subscribedSku.getId()})});
        }
        return builder.build();
    }
}

