/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.internal.util.CertificateParser;
import com.yubico.webauthn.data.AttestationType;
import com.yubico.webauthn.data.AuthenticatorRegistrationExtensionOutputs;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ClientRegistrationExtensionOutputs;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public final class RegistrationResult {
    @NonNull
    private final PublicKeyCredentialDescriptor keyId;
    @NonNull
    private final ByteArray aaguid;
    private final boolean attestationTrusted;
    @NonNull
    private final AttestationType attestationType;
    private final List<X509Certificate> attestationTrustPath;
    @NonNull
    private final ByteArray publicKeyCose;
    private final long signatureCount;
    private final ClientRegistrationExtensionOutputs clientExtensionOutputs;
    private final AuthenticatorRegistrationExtensionOutputs authenticatorExtensionOutputs;

    private RegistrationResult(@NonNull PublicKeyCredentialDescriptor keyId, @NonNull ByteArray aaguid, boolean attestationTrusted, @NonNull AttestationType attestationType, List<X509Certificate> attestationTrustPath, @NonNull ByteArray publicKeyCose, Long signatureCount, ClientRegistrationExtensionOutputs clientExtensionOutputs, AuthenticatorRegistrationExtensionOutputs authenticatorExtensionOutputs) {
        if (keyId == null) {
            throw new NullPointerException("keyId is marked non-null but is null");
        }
        if (aaguid == null) {
            throw new NullPointerException("aaguid is marked non-null but is null");
        }
        if (attestationType == null) {
            throw new NullPointerException("attestationType is marked non-null but is null");
        }
        if (publicKeyCose == null) {
            throw new NullPointerException("publicKeyCose is marked non-null but is null");
        }
        this.keyId = keyId;
        this.aaguid = aaguid;
        this.attestationTrusted = attestationTrusted;
        this.attestationType = attestationType;
        this.attestationTrustPath = attestationTrustPath;
        this.publicKeyCose = publicKeyCose;
        this.signatureCount = signatureCount == null ? 0L : signatureCount;
        this.clientExtensionOutputs = clientExtensionOutputs == null || clientExtensionOutputs.getExtensionIds().isEmpty() ? null : clientExtensionOutputs;
        this.authenticatorExtensionOutputs = authenticatorExtensionOutputs;
    }

    @JsonCreator
    private static RegistrationResult fromJson(@JsonProperty(value="keyId") @NonNull PublicKeyCredentialDescriptor keyId, @JsonProperty(value="aaguid") @NonNull ByteArray aaguid, @JsonProperty(value="attestationTrusted") boolean attestationTrusted, @JsonProperty(value="attestationType") @NonNull AttestationType attestationType, @JsonProperty(value="attestationTrustPath") List<String> attestationTrustPath, @JsonProperty(value="publicKeyCose") @NonNull ByteArray publicKeyCose, @JsonProperty(value="signatureCount") Long signatureCount, @JsonProperty(value="clientExtensionOutputs") ClientRegistrationExtensionOutputs clientExtensionOutputs, @JsonProperty(value="authenticatorExtensionOutputs") AuthenticatorRegistrationExtensionOutputs authenticatorExtensionOutputs) {
        if (keyId == null) {
            throw new NullPointerException("keyId is marked non-null but is null");
        }
        if (aaguid == null) {
            throw new NullPointerException("aaguid is marked non-null but is null");
        }
        if (attestationType == null) {
            throw new NullPointerException("attestationType is marked non-null but is null");
        }
        if (publicKeyCose == null) {
            throw new NullPointerException("publicKeyCose is marked non-null but is null");
        }
        return new RegistrationResult(keyId, aaguid, attestationTrusted, attestationType, attestationTrustPath.stream().map(pem -> {
            try {
                return CertificateParser.parsePem((String)pem);
            }
            catch (CertificateException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList()), publicKeyCose, signatureCount, clientExtensionOutputs, authenticatorExtensionOutputs);
    }

    @JsonIgnore
    public Optional<List<X509Certificate>> getAttestationTrustPath() {
        return Optional.ofNullable(this.attestationTrustPath);
    }

    @JsonProperty(value="attestationTrustPath")
    private Optional<List<String>> getAttestationTrustPathJson() {
        return this.getAttestationTrustPath().map(x5c -> x5c.stream().map(cert -> {
            try {
                return new ByteArray(cert.getEncoded()).getBase64();
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList()));
    }

    public Optional<ClientRegistrationExtensionOutputs> getClientExtensionOutputs() {
        return Optional.ofNullable(this.clientExtensionOutputs);
    }

    public Optional<AuthenticatorRegistrationExtensionOutputs> getAuthenticatorExtensionOutputs() {
        return Optional.ofNullable(this.authenticatorExtensionOutputs);
    }

    public Optional<Boolean> isDiscoverable() {
        return this.getClientExtensionOutputs().flatMap(outputs -> outputs.getCredProps()).flatMap(credProps -> credProps.getRk());
    }

    static RegistrationResultBuilder.MandatoryStages builder() {
        return new RegistrationResultBuilder.MandatoryStages();
    }

    @Generated
    public RegistrationResultBuilder toBuilder() {
        return new RegistrationResultBuilder().keyId(this.keyId).aaguid(this.aaguid).attestationTrusted(this.attestationTrusted).attestationType(this.attestationType).attestationTrustPath(this.attestationTrustPath).publicKeyCose(this.publicKeyCose).signatureCount(this.signatureCount).clientExtensionOutputs(this.clientExtensionOutputs).authenticatorExtensionOutputs(this.authenticatorExtensionOutputs);
    }

    @NonNull
    @Generated
    public PublicKeyCredentialDescriptor getKeyId() {
        return this.keyId;
    }

    @NonNull
    @Generated
    public ByteArray getAaguid() {
        return this.aaguid;
    }

    @Generated
    public boolean isAttestationTrusted() {
        return this.attestationTrusted;
    }

    @NonNull
    @Generated
    public AttestationType getAttestationType() {
        return this.attestationType;
    }

    @NonNull
    @Generated
    public ByteArray getPublicKeyCose() {
        return this.publicKeyCose;
    }

    @Generated
    public long getSignatureCount() {
        return this.signatureCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegistrationResult)) {
            return false;
        }
        RegistrationResult other = (RegistrationResult)o;
        if (this.isAttestationTrusted() != other.isAttestationTrusted()) {
            return false;
        }
        if (this.getSignatureCount() != other.getSignatureCount()) {
            return false;
        }
        PublicKeyCredentialDescriptor this$keyId = this.getKeyId();
        PublicKeyCredentialDescriptor other$keyId = other.getKeyId();
        if (this$keyId == null ? other$keyId != null : !((Object)this$keyId).equals(other$keyId)) {
            return false;
        }
        ByteArray this$aaguid = this.getAaguid();
        ByteArray other$aaguid = other.getAaguid();
        if (this$aaguid == null ? other$aaguid != null : !((Object)this$aaguid).equals(other$aaguid)) {
            return false;
        }
        AttestationType this$attestationType = this.getAttestationType();
        AttestationType other$attestationType = other.getAttestationType();
        if (this$attestationType == null ? other$attestationType != null : !((Object)((Object)this$attestationType)).equals((Object)other$attestationType)) {
            return false;
        }
        Optional<List<X509Certificate>> this$attestationTrustPath = this.getAttestationTrustPath();
        Optional<List<X509Certificate>> other$attestationTrustPath = other.getAttestationTrustPath();
        if (this$attestationTrustPath == null ? other$attestationTrustPath != null : !((Object)this$attestationTrustPath).equals(other$attestationTrustPath)) {
            return false;
        }
        ByteArray this$publicKeyCose = this.getPublicKeyCose();
        ByteArray other$publicKeyCose = other.getPublicKeyCose();
        if (this$publicKeyCose == null ? other$publicKeyCose != null : !((Object)this$publicKeyCose).equals(other$publicKeyCose)) {
            return false;
        }
        Optional<ClientRegistrationExtensionOutputs> this$clientExtensionOutputs = this.getClientExtensionOutputs();
        Optional<ClientRegistrationExtensionOutputs> other$clientExtensionOutputs = other.getClientExtensionOutputs();
        if (this$clientExtensionOutputs == null ? other$clientExtensionOutputs != null : !((Object)this$clientExtensionOutputs).equals(other$clientExtensionOutputs)) {
            return false;
        }
        Optional<AuthenticatorRegistrationExtensionOutputs> this$authenticatorExtensionOutputs = this.getAuthenticatorExtensionOutputs();
        Optional<AuthenticatorRegistrationExtensionOutputs> other$authenticatorExtensionOutputs = other.getAuthenticatorExtensionOutputs();
        return !(this$authenticatorExtensionOutputs == null ? other$authenticatorExtensionOutputs != null : !((Object)this$authenticatorExtensionOutputs).equals(other$authenticatorExtensionOutputs));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAttestationTrusted() ? 79 : 97);
        long $signatureCount = this.getSignatureCount();
        result = result * 59 + (int)($signatureCount >>> 32 ^ $signatureCount);
        PublicKeyCredentialDescriptor $keyId = this.getKeyId();
        result = result * 59 + ($keyId == null ? 43 : ((Object)$keyId).hashCode());
        ByteArray $aaguid = this.getAaguid();
        result = result * 59 + ($aaguid == null ? 43 : ((Object)$aaguid).hashCode());
        AttestationType $attestationType = this.getAttestationType();
        result = result * 59 + ($attestationType == null ? 43 : ((Object)((Object)$attestationType)).hashCode());
        Optional<List<X509Certificate>> $attestationTrustPath = this.getAttestationTrustPath();
        result = result * 59 + ($attestationTrustPath == null ? 43 : ((Object)$attestationTrustPath).hashCode());
        ByteArray $publicKeyCose = this.getPublicKeyCose();
        result = result * 59 + ($publicKeyCose == null ? 43 : ((Object)$publicKeyCose).hashCode());
        Optional<ClientRegistrationExtensionOutputs> $clientExtensionOutputs = this.getClientExtensionOutputs();
        result = result * 59 + ($clientExtensionOutputs == null ? 43 : ((Object)$clientExtensionOutputs).hashCode());
        Optional<AuthenticatorRegistrationExtensionOutputs> $authenticatorExtensionOutputs = this.getAuthenticatorExtensionOutputs();
        result = result * 59 + ($authenticatorExtensionOutputs == null ? 43 : ((Object)$authenticatorExtensionOutputs).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RegistrationResult(keyId=" + this.getKeyId() + ", aaguid=" + this.getAaguid() + ", attestationTrusted=" + this.isAttestationTrusted() + ", attestationType=" + (Object)((Object)this.getAttestationType()) + ", attestationTrustPath=" + this.getAttestationTrustPath() + ", publicKeyCose=" + this.getPublicKeyCose() + ", signatureCount=" + this.getSignatureCount() + ", clientExtensionOutputs=" + this.getClientExtensionOutputs() + ", authenticatorExtensionOutputs=" + this.getAuthenticatorExtensionOutputs() + ")";
    }

    static class RegistrationResultBuilder {
        @Generated
        private PublicKeyCredentialDescriptor keyId;
        @Generated
        private ByteArray aaguid;
        @Generated
        private boolean attestationTrusted;
        @Generated
        private AttestationType attestationType;
        @Generated
        private List<X509Certificate> attestationTrustPath;
        @Generated
        private ByteArray publicKeyCose;
        @Generated
        private long signatureCount;
        @Generated
        private ClientRegistrationExtensionOutputs clientExtensionOutputs;
        @Generated
        private AuthenticatorRegistrationExtensionOutputs authenticatorExtensionOutputs;

        @Generated
        RegistrationResultBuilder() {
        }

        @Generated
        public RegistrationResultBuilder keyId(@NonNull PublicKeyCredentialDescriptor keyId) {
            if (keyId == null) {
                throw new NullPointerException("keyId is marked non-null but is null");
            }
            this.keyId = keyId;
            return this;
        }

        @Generated
        public RegistrationResultBuilder aaguid(@NonNull ByteArray aaguid) {
            if (aaguid == null) {
                throw new NullPointerException("aaguid is marked non-null but is null");
            }
            this.aaguid = aaguid;
            return this;
        }

        @Generated
        public RegistrationResultBuilder attestationTrusted(boolean attestationTrusted) {
            this.attestationTrusted = attestationTrusted;
            return this;
        }

        @Generated
        public RegistrationResultBuilder attestationType(@NonNull AttestationType attestationType) {
            if (attestationType == null) {
                throw new NullPointerException("attestationType is marked non-null but is null");
            }
            this.attestationType = attestationType;
            return this;
        }

        @Generated
        public RegistrationResultBuilder attestationTrustPath(List<X509Certificate> attestationTrustPath) {
            this.attestationTrustPath = attestationTrustPath;
            return this;
        }

        @Generated
        public RegistrationResultBuilder publicKeyCose(@NonNull ByteArray publicKeyCose) {
            if (publicKeyCose == null) {
                throw new NullPointerException("publicKeyCose is marked non-null but is null");
            }
            this.publicKeyCose = publicKeyCose;
            return this;
        }

        @Generated
        public RegistrationResultBuilder signatureCount(long signatureCount) {
            this.signatureCount = signatureCount;
            return this;
        }

        @Generated
        public RegistrationResultBuilder clientExtensionOutputs(ClientRegistrationExtensionOutputs clientExtensionOutputs) {
            this.clientExtensionOutputs = clientExtensionOutputs;
            return this;
        }

        @Generated
        public RegistrationResultBuilder authenticatorExtensionOutputs(AuthenticatorRegistrationExtensionOutputs authenticatorExtensionOutputs) {
            this.authenticatorExtensionOutputs = authenticatorExtensionOutputs;
            return this;
        }

        @Generated
        public RegistrationResult build() {
            return new RegistrationResult(this.keyId, this.aaguid, this.attestationTrusted, this.attestationType, this.attestationTrustPath, this.publicKeyCose, this.signatureCount, this.clientExtensionOutputs, this.authenticatorExtensionOutputs);
        }

        @Generated
        public String toString() {
            return "RegistrationResult.RegistrationResultBuilder(keyId=" + this.keyId + ", aaguid=" + this.aaguid + ", attestationTrusted=" + this.attestationTrusted + ", attestationType=" + (Object)((Object)this.attestationType) + ", attestationTrustPath=" + this.attestationTrustPath + ", publicKeyCose=" + this.publicKeyCose + ", signatureCount=" + this.signatureCount + ", clientExtensionOutputs=" + this.clientExtensionOutputs + ", authenticatorExtensionOutputs=" + this.authenticatorExtensionOutputs + ")";
        }

        static class MandatoryStages {
            private RegistrationResultBuilder builder = new RegistrationResultBuilder();

            MandatoryStages() {
            }

            Step2 keyId(PublicKeyCredentialDescriptor keyId) {
                this.builder.keyId(keyId);
                return new Step2();
            }

            class Step8 {
                Step8() {
                }

                RegistrationResultBuilder authenticatorExtensionOutputs(AuthenticatorRegistrationExtensionOutputs authenticatorExtensionOutputs) {
                    return MandatoryStages.this.builder.authenticatorExtensionOutputs(authenticatorExtensionOutputs);
                }
            }

            class Step7 {
                Step7() {
                }

                Step8 clientExtensionOutputs(ClientRegistrationExtensionOutputs clientExtensionOutputs) {
                    MandatoryStages.this.builder.clientExtensionOutputs(clientExtensionOutputs);
                    return new Step8();
                }
            }

            class Step6 {
                Step6() {
                }

                Step7 signatureCount(long signatureCount) {
                    MandatoryStages.this.builder.signatureCount(signatureCount);
                    return new Step7();
                }
            }

            class Step5 {
                Step5() {
                }

                Step6 publicKeyCose(ByteArray publicKeyCose) {
                    MandatoryStages.this.builder.publicKeyCose(publicKeyCose);
                    return new Step6();
                }
            }

            class Step4 {
                Step4() {
                }

                Step5 attestationType(AttestationType attestationType) {
                    MandatoryStages.this.builder.attestationType(attestationType);
                    return new Step5();
                }
            }

            class Step3 {
                Step3() {
                }

                Step4 attestationTrusted(boolean attestationTrusted) {
                    MandatoryStages.this.builder.attestationTrusted(attestationTrusted);
                    return new Step4();
                }
            }

            class Step2 {
                Step2() {
                }

                Step3 aaguid(ByteArray aaguid) {
                    MandatoryStages.this.builder.aaguid(aaguid);
                    return new Step3();
                }
            }
        }
    }
}

