/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.surrogate.SurrogateAuthenticationProperties;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.expiration.HardTimeoutExpirationPolicy;
import org.apereo.cas.ticket.expiration.SurrogateSessionExpirationPolicy;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class SurrogateAuthenticationExpirationPolicyBuilder
implements ExpirationPolicyBuilder<TicketGrantingTicket> {
    private static final long serialVersionUID = -3597980180617072826L;
    protected final ExpirationPolicyBuilder<TicketGrantingTicket> ticketGrantingTicketExpirationPolicyBuilder;
    protected final CasConfigurationProperties casProperties;

    public ExpirationPolicy buildTicketExpirationPolicy() {
        return this.toTicketExpirationPolicy();
    }

    public ExpirationPolicy toTicketExpirationPolicy() {
        SurrogateAuthenticationProperties su = this.casProperties.getAuthn().getSurrogate();
        HardTimeoutExpirationPolicy surrogatePolicy = new HardTimeoutExpirationPolicy(su.getTgt().getTimeToKillInSeconds());
        SurrogateSessionExpirationPolicy policy = new SurrogateSessionExpirationPolicy();
        policy.addPolicy("SURROGATE", (ExpirationPolicy)surrogatePolicy);
        policy.addPolicy("DEFAULT", this.ticketGrantingTicketExpirationPolicyBuilder.buildTicketExpirationPolicy());
        return policy;
    }

    @Generated
    public SurrogateAuthenticationExpirationPolicyBuilder(ExpirationPolicyBuilder<TicketGrantingTicket> ticketGrantingTicketExpirationPolicyBuilder, CasConfigurationProperties casProperties) {
        this.ticketGrantingTicketExpirationPolicyBuilder = ticketGrantingTicketExpirationPolicyBuilder;
        this.casProperties = casProperties;
    }

    @Generated
    public String toString() {
        return "SurrogateAuthenticationExpirationPolicyBuilder(ticketGrantingTicketExpirationPolicyBuilder=" + this.ticketGrantingTicketExpirationPolicyBuilder + ", casProperties=" + this.casProperties + ")";
    }

    @Generated
    public ExpirationPolicyBuilder<TicketGrantingTicket> getTicketGrantingTicketExpirationPolicyBuilder() {
        return this.ticketGrantingTicketExpirationPolicyBuilder;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }
}

