/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.client.v2;

import com.yubico.client.v2.ResponseStatus;
import com.yubico.client.v2.VerificationResponse;
import com.yubico.client.v2.exceptions.YubicoVerificationException;
import com.yubico.client.v2.impl.VerificationResponseImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerificationRequester {
    private final ExecutorCompletionService<VerificationResponse> completionService;

    public VerificationRequester() {
        ThreadPoolExecutor pool = new ThreadPoolExecutor(0, 100, 250L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
        this.completionService = new ExecutorCompletionService(pool);
    }

    @Deprecated
    public VerificationResponse fetch(List<String> urls, String userAgent) throws YubicoVerificationException {
        return this.fetch(urls, userAgent, 5);
    }

    /*
     * WARNING - void declaration
     */
    public VerificationResponse fetch(List<String> urls, String userAgent, int maxRetries) throws YubicoVerificationException {
        if (maxRetries < 0) {
            throw new IllegalArgumentException("negative maxRetries is not valid.");
        }
        ArrayList<Future<VerificationResponse>> tasks = new ArrayList<Future<VerificationResponse>>();
        for (String url : urls) {
            tasks.add(this.completionService.submit(this.createTask(userAgent, url, maxRetries)));
        }
        VerificationResponse response = null;
        try {
            int tasksDone = 0;
            Object var7_10 = null;
            Future<VerificationResponse> futureResponse = this.completionService.poll(1L, TimeUnit.MINUTES);
            while (futureResponse != null) {
                try {
                    ++tasksDone;
                    tasks.remove(futureResponse);
                    response = futureResponse.get();
                    if (!response.getStatus().equals((Object)ResponseStatus.REPLAYED_REQUEST) && !response.getStatus().equals((Object)ResponseStatus.BACKEND_ERROR)) {
                        break;
                    }
                }
                catch (CancellationException ignored) {
                    --tasksDone;
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                }
                if (tasksDone >= urls.size()) break;
                futureResponse = this.completionService.poll(1L, TimeUnit.MINUTES);
            }
            if (futureResponse == null || response == null) {
                void var7_11;
                if (var7_11 != null) {
                    throw new YubicoVerificationException("Exception while executing validation.", (Throwable)var7_11);
                }
                throw new YubicoVerificationException("Validation timeout.");
            }
        }
        catch (InterruptedException e) {
            throw new YubicoVerificationException("Validation interrupted.", e);
        }
        for (Future future : tasks) {
            future.cancel(true);
        }
        return response;
    }

    protected VerifyTask createTask(String userAgent, String url, int maxRetries) {
        return new VerifyTask(url, userAgent, maxRetries);
    }

    static class VerifyTask
    implements Callable<VerificationResponse> {
        private final Logger log = LoggerFactory.getLogger(VerifyTask.class);
        private final String url;
        private final String userAgent;
        private final int maxRetries;

        public VerifyTask(String url, String userAgent, int maxRetries) {
            if (maxRetries < 0) {
                throw new IllegalArgumentException("negative maxRetries is not valid.");
            }
            this.url = url;
            this.userAgent = userAgent;
            this.maxRetries = maxRetries;
        }

        @Override
        public VerificationResponse call() throws Exception {
            URL url = new URL(this.url);
            try {
                return new VerificationResponseImpl(this.getResponseStream(url));
            }
            catch (IOException e) {
                this.log.warn("Exception when requesting {}.", (Object)url.getHost(), (Object)e);
                throw e;
            }
        }

        protected InputStream getResponseStream(URL url) throws IOException {
            int attempt = 0;
            while (true) {
                try {
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestProperty("User-Agent", this.userAgent);
                    conn.setConnectTimeout(15000);
                    conn.setReadTimeout(15000);
                    return conn.getInputStream();
                }
                catch (IOException e) {
                    this.log.warn("Exception when requesting {}, retrying.", (Object)url.getHost(), (Object)e);
                    IOException lastException = e;
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (++attempt <= this.maxRetries) continue;
                    throw lastException;
                }
                break;
            }
        }
    }
}

