/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.config.builder;

import java.util.HashMap;
import java.util.Map;
import org.pac4j.config.client.PropertiesConstants;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.http.credentials.authenticator.test.SimpleTestTokenAuthenticator;
import org.pac4j.http.credentials.authenticator.test.SimpleTestUsernamePasswordAuthenticator;

public abstract class AbstractBuilder
implements PropertiesConstants {
    protected static final int MAX_NUM_CLIENTS = 100;
    protected static final int MAX_NUM_AUTHENTICATORS = 10;
    protected static final int MAX_NUM_CUSTOM_PROPERTIES = 5;
    protected static final int MAX_NUM_ENCODERS = 10;
    protected final Map<String, String> properties;
    protected final Map<String, Authenticator> authenticators;

    protected AbstractBuilder(Map<String, String> properties) {
        this.properties = properties;
        this.authenticators = new HashMap<String, Authenticator>();
    }

    protected AbstractBuilder(Map<String, String> properties, Map<String, Authenticator> authenticators) {
        this.properties = properties;
        this.authenticators = authenticators;
    }

    protected String concat(String value, int num) {
        return value.concat((String)(num == 0 ? "" : "." + num));
    }

    protected String getProperty(String name) {
        return this.properties.get(name);
    }

    protected String getProperty(String name, int num) {
        return this.getProperty(this.concat(name, num));
    }

    protected boolean containsProperty(String name, int num) {
        return this.properties.containsKey(this.concat(name, num));
    }

    protected boolean getPropertyAsBoolean(String name, int num) {
        return Boolean.valueOf(this.getProperty(name, num));
    }

    protected int getPropertyAsInteger(String name, int num) {
        return Integer.parseInt(this.getProperty(name, num));
    }

    protected long getPropertyAsLong(String name, int num) {
        return Long.parseLong(this.getProperty(name, num));
    }

    protected Authenticator getAuthenticator(String name) {
        if ("testToken".equals(name)) {
            return new SimpleTestTokenAuthenticator();
        }
        if ("testUsernamePassword".equals(name)) {
            return new SimpleTestUsernamePasswordAuthenticator();
        }
        return this.authenticators.get(name);
    }
}

