/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.core.definition.digester;

import java.util.Map;
import org.apache.commons.digester3.Rule;
import org.apache.tiles.api.Attribute;
import org.apache.tiles.api.Definition;
import org.apache.tiles.core.definition.digester.DigesterDefinitionsReader;
import org.xml.sax.Attributes;

class AddNestedDefinitionRule
extends Rule {
    private int anonymousDefinitionIndex = 1;
    private final DigesterDefinitionsReader definitionsReader;

    public AddNestedDefinitionRule(DigesterDefinitionsReader definitionsReader) {
        this.definitionsReader = definitionsReader;
    }

    public void begin(String namespace, String name, Attributes attributes) {
        Definition definition = (Definition)this.definitionsReader.digester.peek(0);
        if (definition.getName() == null) {
            definition.setName(this.getNextUniqueDefinitionName(this.definitionsReader.definitions));
        }
        Attribute attribute = (Attribute)this.definitionsReader.digester.peek(1);
        attribute.setValue(definition.getName());
        attribute.setRenderer("definition");
    }

    protected String getNextUniqueDefinitionName(Map<String, Definition> definitions) {
        String candidate;
        do {
            candidate = "$anonymousDefinition" + this.anonymousDefinitionIndex;
            ++this.anonymousDefinitionIndex;
        } while (definitions.containsKey(candidate));
        return candidate;
    }
}

