/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

public class ReportExecutionStatus {
    private final Status status;
    private final Integer totalPageCount;
    private final int currentPageCount;
    private final Throwable error;

    public static ReportExecutionStatus finished(int pageCount) {
        return new ReportExecutionStatus(Status.FINISHED, pageCount, pageCount, null);
    }

    public static ReportExecutionStatus canceled(int pageCount) {
        return new ReportExecutionStatus(Status.CANCELED, null, pageCount, null);
    }

    public static ReportExecutionStatus error(int pageCount, Throwable error) {
        return new ReportExecutionStatus(Status.ERROR, null, pageCount, error);
    }

    public static ReportExecutionStatus running(int pageCount) {
        return new ReportExecutionStatus(Status.RUNNING, null, pageCount, null);
    }

    protected ReportExecutionStatus(Status status, Integer totalPageCount, int currentPageCount, Throwable error) {
        this.status = status;
        this.totalPageCount = totalPageCount;
        this.currentPageCount = currentPageCount;
        this.error = error;
    }

    public Status getStatus() {
        return this.status;
    }

    public Integer getTotalPageCount() {
        return this.totalPageCount;
    }

    public int getCurrentPageCount() {
        return this.currentPageCount;
    }

    public Throwable getError() {
        return this.error;
    }

    public static enum Status {
        RUNNING,
        FINISHED,
        ERROR,
        CANCELED;

    }
}

