/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import net.sf.jasperreports.engine.export.FileXmlResourceHandler;
import net.sf.jasperreports.engine.export.XmlResourceHandler;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import net.sf.jasperreports.export.XmlExporterOutput;

public class SimpleXmlExporterOutput
extends SimpleWriterExporterOutput
implements XmlExporterOutput {
    private static final String XML_FILES_SUFFIX = "_files";
    private XmlResourceHandler imageHandler;
    private boolean imageHandlerSet;
    private Boolean isEmbeddingImages;
    private final File destFile;

    public SimpleXmlExporterOutput(StringBuffer sbuffer) {
        super(sbuffer);
        this.destFile = null;
    }

    public SimpleXmlExporterOutput(StringBuilder sbuilder) {
        super(sbuilder);
        this.destFile = null;
    }

    public SimpleXmlExporterOutput(Writer writer) {
        super(writer);
        this.destFile = null;
    }

    public SimpleXmlExporterOutput(OutputStream outputStream) {
        super(outputStream);
        this.destFile = null;
    }

    public SimpleXmlExporterOutput(OutputStream outputStream, String encoding) {
        super(outputStream, encoding);
        this.destFile = null;
    }

    public SimpleXmlExporterOutput(File file) {
        super(file);
        this.destFile = file;
    }

    public SimpleXmlExporterOutput(File file, String encoding) {
        super(file, encoding);
        this.destFile = file;
    }

    public SimpleXmlExporterOutput(String fileName) {
        super(fileName);
        this.destFile = fileName == null ? null : new File(fileName);
    }

    public SimpleXmlExporterOutput(String fileName, String encoding) {
        super(fileName, encoding);
        this.destFile = fileName == null ? null : new File(fileName);
    }

    @Override
    public XmlResourceHandler getImageHandler() {
        if (!this.imageHandlerSet && this.imageHandler == null && this.destFile != null) {
            File imagesFolder = new File(this.destFile.getParent(), this.destFile.getName() + XML_FILES_SUFFIX);
            this.imageHandler = new FileXmlResourceHandler(imagesFolder, imagesFolder.getName() + "/{0}");
        }
        return this.imageHandler;
    }

    public void setImageHandler(XmlResourceHandler imageHandler) {
        this.imageHandler = imageHandler;
        this.imageHandlerSet = true;
    }

    @Override
    public Boolean isEmbeddingImages() {
        return this.isEmbeddingImages;
    }

    public void setEmbeddingImages(Boolean isEmbeddingImages) {
        this.isEmbeddingImages = isEmbeddingImages;
    }
}

