/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.xml.ReportWriter;
import net.sf.jasperreports.engine.xml.ReportWriterFactory;

public class JRXmlWriter {
    public static final String PROPERTY_REPORT_VERSION = "net.sf.jasperreports.report.version";
    public static final String EXCEPTION_MESSAGE_KEY_FILE_WRITE_ERROR = "xml.writer.file.write.error";
    public static final String EXCEPTION_MESSAGE_KEY_OUTPUT_STREAM_WRITE_ERROR = "xml.writer.output.stream.write.error";
    public static final String EXCEPTION_MESSAGE_KEY_REPORT_DESIGN_WRITE_ERROR = "xml.writer.report.design.write.error";
    public static final String EXCEPTION_MESSAGE_KEY_UNSUPPORTED_CHART_TYPE = "xml.writer.unsupported.chart.type";
    public static final String PREFIX_EXCLUDE_PROPERTIES = "net.sf.jasperreports.jrxml.writer.exclude.properties.";
    public static final String PROPERTY_EXCLUDE_UUIDS = "net.sf.jasperreports.jrxml.writer.exclude.uuids";
    private JasperReportsContext jasperReportsContext;
    private JRReport report;

    public JRXmlWriter(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public JRReport getReport() {
        return this.report;
    }

    public String write(JRReport report, String encoding) {
        StringWriter buffer = new StringWriter();
        try {
            this.writeReport(report, encoding, buffer);
        }
        catch (IOException e) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_REPORT_DESIGN_WRITE_ERROR, null, e);
        }
        return buffer.toString();
    }

    public void write(JRReport report, String destFileName, String encoding) throws JRException {
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(destFileName)), encoding);){
            this.writeReport(report, encoding, out);
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_FILE_WRITE_ERROR, new Object[]{destFileName}, e);
        }
    }

    public void write(JRReport report, OutputStream outputStream, String encoding) throws JRException {
        try {
            OutputStreamWriter out = new OutputStreamWriter(outputStream, encoding);
            this.writeReport(report, encoding, out);
        }
        catch (Exception e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_OUTPUT_STREAM_WRITE_ERROR, new Object[]{report.getName()}, e);
        }
    }

    public static String writeReport(JRReport report, String encoding) {
        return new JRXmlWriter(DefaultJasperReportsContext.getInstance()).write(report, encoding);
    }

    public static void writeReport(JRReport report, String destFileName, String encoding) throws JRException {
        new JRXmlWriter(DefaultJasperReportsContext.getInstance()).write(report, destFileName, encoding);
    }

    public static void writeReport(JRReport report, OutputStream outputStream, String encoding) throws JRException {
        new JRXmlWriter(DefaultJasperReportsContext.getInstance()).write(report, outputStream, encoding);
    }

    protected void writeReport(JRReport report, String encoding, Writer out) throws IOException {
        List<ReportWriterFactory> writerFactories = this.jasperReportsContext.getExtensions(ReportWriterFactory.class);
        for (ReportWriterFactory writerFactory : writerFactories) {
            ReportWriter reportWriter = writerFactory.createReportWriter(this.jasperReportsContext);
            boolean written = reportWriter.writeReport(report, encoding, out);
            if (!written) continue;
            return;
        }
        String version = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(PROPERTY_REPORT_VERSION);
        throw new JRRuntimeException("No report writer found for version " + version + ".");
    }
}

