/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.print;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleGraphics2DExporterOutput;
import net.sf.jasperreports.export.SimpleGraphics2DReportConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRPrinterAWT
implements Printable {
    private static final Log log = LogFactory.getLog(JRPrinterAWT.class);
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_PAGE_RANGE = "print.invalid.page.range";
    public static final String EXCEPTION_MESSAGE_KEY_ERROR_PRINTING_REPORT = "print.error.printing.report";
    private JasperReportsContext jasperReportsContext;
    private JasperPrint jasperPrint;
    private int pageOffset;

    protected JRPrinterAWT(JasperPrint jrPrint) throws JRException {
        this(DefaultJasperReportsContext.getInstance(), jrPrint);
    }

    public JRPrinterAWT(JasperReportsContext jasperReportsContext, JasperPrint jasperPrint) throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
        this.jasperReportsContext = jasperReportsContext;
        this.jasperPrint = jasperPrint;
    }

    public static boolean printPages(JasperPrint jrPrint, int firstPageIndex, int lastPageIndex, boolean withPrintDialog) throws JRException {
        JRPrinterAWT printer = new JRPrinterAWT(jrPrint);
        return printer.printPages(firstPageIndex, lastPageIndex, withPrintDialog);
    }

    public static Image printPageToImage(JasperPrint jrPrint, int pageIndex, float zoom) throws JRException {
        JRPrinterAWT printer = new JRPrinterAWT(jrPrint);
        return printer.printPageToImage(pageIndex, zoom);
    }

    public boolean printPages(int firstPageIndex, int lastPageIndex, boolean withPrintDialog) throws JRException {
        boolean isOK = true;
        if (firstPageIndex < 0 || firstPageIndex > lastPageIndex || lastPageIndex >= this.jasperPrint.getPages().size()) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_INVALID_PAGE_RANGE, firstPageIndex, lastPageIndex, this.jasperPrint.getPages().size());
        }
        this.pageOffset = firstPageIndex;
        PrinterJob printJob = PrinterJob.getPrinterJob();
        JRPrinterAWT.initPrinterJobFields(printJob);
        PageFormat pageFormat = printJob.defaultPage();
        Paper paper = pageFormat.getPaper();
        printJob.setJobName("JasperReports - " + this.jasperPrint.getName());
        switch (this.jasperPrint.getOrientation()) {
            case LANDSCAPE: {
                pageFormat.setOrientation(0);
                paper.setSize(this.jasperPrint.getPageHeight(), this.jasperPrint.getPageWidth());
                paper.setImageableArea(0.0, 0.0, this.jasperPrint.getPageHeight(), this.jasperPrint.getPageWidth());
                break;
            }
            default: {
                pageFormat.setOrientation(1);
                paper.setSize(this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
                paper.setImageableArea(0.0, 0.0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
            }
        }
        pageFormat.setPaper(paper);
        Book book = new Book();
        book.append(this, pageFormat, lastPageIndex - firstPageIndex + 1);
        printJob.setPageable(book);
        try {
            if (withPrintDialog) {
                if (printJob.printDialog()) {
                    printJob.print();
                } else {
                    isOK = false;
                }
            } else {
                printJob.print();
            }
        }
        catch (Exception ex) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_ERROR_PRINTING_REPORT, null, ex);
        }
        return isOK;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (Thread.interrupted()) {
            throw new PrinterException("Current thread interrupted.");
        }
        if ((pageIndex += this.pageOffset) < 0 || pageIndex >= this.jasperPrint.getPages().size()) {
            return 1;
        }
        try {
            JRGraphics2DExporter exporter = new JRGraphics2DExporter(this.jasperReportsContext);
            exporter.setExporterInput(new SimpleExporterInput(this.jasperPrint));
            SimpleGraphics2DExporterOutput output = new SimpleGraphics2DExporterOutput();
            output.setGraphics2D((Graphics2D)graphics);
            exporter.setExporterOutput(output);
            SimpleGraphics2DReportConfiguration configuration = new SimpleGraphics2DReportConfiguration();
            configuration.setPageIndex(pageIndex);
            exporter.setConfiguration(configuration);
            exporter.exportReport();
        }
        catch (JRException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Print failed.", (Throwable)e);
            }
            throw new PrinterException(e.getMessage());
        }
        return 0;
    }

    public Image printPageToImage(int pageIndex, float zoom) throws JRException {
        PrintPageFormat pageFormat = this.jasperPrint.getPageFormat(pageIndex);
        int rasterWidth = (int)Math.ceil((float)pageFormat.getPageWidth().intValue() * zoom);
        int rasterHeight = (int)Math.ceil((float)pageFormat.getPageHeight().intValue() * zoom);
        BufferedImage pageImage = new BufferedImage(rasterWidth, rasterHeight, 1);
        Graphics imageGraphics = ((Image)pageImage).getGraphics();
        Graphics graphics = imageGraphics.create();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, rasterWidth, rasterHeight);
        JRGraphics2DExporter exporter = new JRGraphics2DExporter(this.jasperReportsContext);
        exporter.setExporterInput(new SimpleExporterInput(this.jasperPrint));
        SimpleGraphics2DExporterOutput output = new SimpleGraphics2DExporterOutput();
        output.setGraphics2D((Graphics2D)imageGraphics);
        exporter.setExporterOutput(output);
        SimpleGraphics2DReportConfiguration configuration = new SimpleGraphics2DReportConfiguration();
        configuration.setPageIndex(pageIndex);
        configuration.setZoomRatio(Float.valueOf(zoom));
        configuration.setWhitePageBackground(false);
        exporter.setConfiguration(configuration);
        exporter.exportReport();
        return pageImage;
    }

    public static void initPrinterJobFields(PrinterJob job) {
        try {
            job.setPrintService(job.getPrintService());
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
    }
}

