/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.experimental;

import java.util.Arrays;
import java.util.Map;
import org.apache.storm.shade.org.jgrapht.Graph;
import org.apache.storm.shade.org.jgrapht.VertexFactory;
import org.apache.storm.shade.org.jgrapht.experimental.RandomGraphHelper;
import org.apache.storm.shade.org.jgrapht.generate.GraphGenerator;

public class UniformRandomGraphGenerator
implements GraphGenerator {
    private final int numEdges;
    private final int numVertices;

    public UniformRandomGraphGenerator(int numVertices, int numEdges) {
        if (numVertices < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        if (numEdges < 0 || numEdges > numVertices * (numVertices - 1) / 2) {
            throw new IllegalArgumentException("illegal number of edges");
        }
        this.numVertices = numVertices;
        this.numEdges = numEdges;
    }

    public void generateGraph(Graph target, VertexFactory vertexFactory, Map resultMap) {
        Object[] vertices = RandomGraphHelper.addVertices(target, vertexFactory, this.numVertices);
        RandomGraphHelper.addEdges(target, Arrays.asList(vertices), Arrays.asList(vertices), this.numEdges);
    }
}

