/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.sasl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.apache.storm.security.auth.ReqContext;
import org.apache.storm.security.auth.sasl.PasswordProvider;
import org.apache.storm.security.auth.sasl.SaslTransportPlugin;
import org.apache.storm.streams.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSaslServerCallbackHandler
implements CallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleSaslServerCallbackHandler.class);
    private final List<PasswordProvider> providers;
    private final boolean impersonationAllowed;

    public SimpleSaslServerCallbackHandler(boolean impersonationAllowed, PasswordProvider ... providers) {
        this(impersonationAllowed, Arrays.asList(providers));
    }

    public SimpleSaslServerCallbackHandler(boolean impersonationAllowed, List<PasswordProvider> providers) {
        this.impersonationAllowed = impersonationAllowed;
        this.providers = new ArrayList<PasswordProvider>(providers);
    }

    private static void log(String type, AuthorizeCallback ac, NameCallback nc, PasswordCallback pc, RealmCallback rc) {
        if (LOG.isDebugEnabled()) {
            Object acs = "null";
            if (ac != null) {
                acs = "athz: " + ac.getAuthorizationID() + " athn: " + ac.getAuthenticationID() + " authorized: " + ac.getAuthorizedID();
            }
            Object ncs = "null";
            if (nc != null) {
                ncs = "default: " + nc.getDefaultName() + " name: " + nc.getName();
            }
            Object pcs = "null";
            if (pc != null) {
                char[] pwd = pc.getPassword();
                pcs = "password: " + (String)(pwd == null ? "null" : "not null " + pwd.length);
            }
            Object rcs = "null";
            if (rc != null) {
                rcs = "default: " + rc.getDefaultText() + " text: " + rc.getText();
            }
            LOG.debug("{}\nAC: {}\nNC: {}\nPC: {}\nRC: {}", new Object[]{type, acs, ncs, pcs, rcs});
        }
    }

    private Pair<String, Boolean> translateName(String orig) {
        for (PasswordProvider provider : this.providers) {
            try {
                String ret = provider.userName(orig);
                if (ret == null) continue;
                return Pair.of(ret, provider.isImpersonationAllowed());
            }
            catch (Exception e) {
                LOG.debug("{} could not read name from {}", new Object[]{provider, orig, e});
            }
        }
        return Pair.of(orig, false);
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException, IOException {
        NameCallback nc = null;
        PasswordCallback pc = null;
        AuthorizeCallback ac = null;
        TextInputCallback rc = null;
        for (Callback callback : callbacks) {
            if (callback instanceof AuthorizeCallback) {
                ac = (AuthorizeCallback)callback;
                continue;
            }
            if (callback instanceof NameCallback) {
                nc = (NameCallback)callback;
                continue;
            }
            if (callback instanceof PasswordCallback) {
                pc = (PasswordCallback)callback;
                continue;
            }
            if (callback instanceof RealmCallback) {
                rc = (RealmCallback)callback;
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized SASL Callback");
        }
        SimpleSaslServerCallbackHandler.log("GOT", ac, nc, pc, rc);
        if (nc != null) {
            String userName = nc.getDefaultName();
            boolean passwordFound = false;
            for (PasswordProvider provider : this.providers) {
                Optional<char[]> password = provider.getPasswordFor(userName);
                if (!password.isPresent()) continue;
                pc.setPassword(password.get());
                nc.setName(provider.userName(userName));
                passwordFound = true;
                break;
            }
            if (!passwordFound) {
                LOG.warn("No password found for user: {}", (Object)userName);
                throw new IOException("NOT ALLOWED.");
            }
        }
        if (rc != null) {
            rc.setText(rc.getDefaultText());
        }
        if (ac != null) {
            String zid;
            boolean allowImpersonation = this.impersonationAllowed;
            String nid = ac.getAuthenticationID();
            if (nid != null) {
                Pair<String, Boolean> tmp = this.translateName(nid);
                nid = tmp.getFirst();
                boolean bl = allowImpersonation = allowImpersonation && tmp.getSecond() != false;
            }
            if ((zid = ac.getAuthorizationID()) != null) {
                Pair<String, Boolean> tmp = this.translateName(zid);
                zid = tmp.getFirst();
                allowImpersonation = allowImpersonation && tmp.getSecond() != false;
            }
            LOG.debug("Successfully authenticated client: authenticationID = {} authorizationID = {}", (Object)nid, (Object)zid);
            if (zid == null) {
                ac.setAuthorizedID(nid);
                zid = nid;
            } else {
                ac.setAuthorizedID(zid);
            }
            if (!Objects.equals(nid, zid)) {
                LOG.info("Impersonation attempt  authenticationID = {} authorizationID = {}", (Object)nid, (Object)zid);
                if (!allowImpersonation) {
                    throw new IllegalArgumentException(ac.getAuthenticationID() + " attempting to impersonate " + ac.getAuthorizationID() + ".  This is not allowed.");
                }
                ReqContext.context().setRealPrincipal(new SaslTransportPlugin.User(nid));
            } else {
                ReqContext.context().setRealPrincipal(null);
            }
            ac.setAuthorized(true);
        }
        SimpleSaslServerCallbackHandler.log("FINISHED", ac, nc, pc, (RealmCallback)rc);
    }
}

