/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics2.cgroup;

import com.codahale.metrics.Gauge;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.storm.container.cgroup.SubSystemType;
import org.apache.storm.container.cgroup.core.CpuacctCore;
import org.apache.storm.metrics2.WorkerMetricRegistrant;
import org.apache.storm.metrics2.cgroup.CGroupMetricsBase;
import org.apache.storm.task.TopologyContext;

public class CGroupCpu
extends CGroupMetricsBase
implements WorkerMetricRegistrant {
    private int userHz = -1;

    public CGroupCpu(Map<String, Object> conf) {
        super(conf, SubSystemType.cpuacct);
    }

    @Override
    public void registerMetrics(TopologyContext topologyContext) {
        if (this.enabled) {
            topologyContext.registerGauge("CGroupCpu.user-ms", new Gauge<Long>(){

                public Long getValue() {
                    CpuacctCore cpu = (CpuacctCore)CGroupCpu.this.core;
                    try {
                        Map<CpuacctCore.StatType, Long> stat = cpu.getCpuStat();
                        long userHz = stat.get((Object)CpuacctCore.StatType.user);
                        long hz = CGroupCpu.this.getUserHz();
                        return userHz * 1000L / hz;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to get metric value", e);
                    }
                }
            });
            topologyContext.registerGauge("CGroupCpu.sys-ms", new Gauge<Long>(){

                public Long getValue() {
                    CpuacctCore cpu = (CpuacctCore)CGroupCpu.this.core;
                    try {
                        Map<CpuacctCore.StatType, Long> stat = cpu.getCpuStat();
                        long systemHz = stat.get((Object)CpuacctCore.StatType.system);
                        long hz = CGroupCpu.this.getUserHz();
                        return systemHz * 1000L / hz;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to get metric value", e);
                    }
                }
            });
        }
    }

    private synchronized int getUserHz() throws IOException {
        if (this.userHz < 0) {
            ProcessBuilder pb = new ProcessBuilder("getconf", "CLK_TCK");
            Process p = pb.start();
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = in.readLine().trim();
            this.userHz = Integer.valueOf(line);
        }
        return this.userHz;
    }
}

