/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.BitwiseXor;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.BitAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.BitXorAgg$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the bitwise XOR of all non-null input values, or null if none.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (3), (5) AS tab(col);\n       6\n  ", group="agg_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0005\u0005Ee\u0001B\f\u0019\u0001\u001eB\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0001\")Q\t\u0001C\u0001\r\")\u0011\n\u0001C!\u0015\")1\u000b\u0001C!)\")A\f\u0001C);\"9\u0001\rAA\u0001\n\u0003\t\u0007bB2\u0001#\u0003%\t\u0001\u001a\u0005\b_\u0002\t\t\u0011\"\u0011q\u0011\u001dA\b!!A\u0005\u0002eDq! \u0001\u0002\u0002\u0013\u0005a\u0010C\u0005\u0002\n\u0001\t\t\u0011\"\u0011\u0002\f!I\u0011\u0011\u0004\u0001\u0002\u0002\u0013\u0005\u00111\u0004\u0005\n\u0003K\u0001\u0011\u0011!C!\u0003OA\u0011\"a\u000b\u0001\u0003\u0003%\t%!\f\b\u0013\u0005E\u0003$!A\t\u0002\u0005Mc\u0001C\f\u0019\u0003\u0003E\t!!\u0016\t\r\u0015\u000bB\u0011AA7\u0011%\ty'EA\u0001\n\u000b\n\t\bC\u0005\u0002tE\t\t\u0011\"!\u0002v!I\u0011\u0011P\t\u0002\u0002\u0013\u0005\u00151\u0010\u0005\n\u0003\u000f\u000b\u0012\u0011!C\u0005\u0003\u0013\u0013\u0011BQ5u1>\u0014\u0018iZ4\u000b\u0005eQ\u0012!C1hOJ,w-\u0019;f\u0015\tYB$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u000f\u001f\u0003!\u0019\u0017\r^1msN$(BA\u0010!\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003C\t\nQa\u001d9be.T!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sO\u000e\u00011\u0003\u0002\u0001)YI\u0002\"!\u000b\u0016\u000e\u0003aI!a\u000b\r\u0003\u0019\tKG/Q4he\u0016<\u0017\r^3\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0003\u000fA\u0013x\u000eZ;diB\u00111g\u000f\b\u0003ier!!\u000e\u001d\u000e\u0003YR!a\u000e\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0013B\u0001\u001e/\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001P\u001f\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005ir\u0013!B2iS2$W#\u0001!\u0011\u0005\u0005\u0013U\"\u0001\u000e\n\u0005\rS\"AC#yaJ,7o]5p]\u000611\r[5mI\u0002\na\u0001P5oSRtDCA$I!\tI\u0003\u0001C\u0003?\u0007\u0001\u0007\u0001)\u0001\u0005o_\u0012,g*Y7f+\u0005Y\u0005C\u0001'Q\u001d\tie\n\u0005\u00026]%\u0011qJL\u0001\u0007!J,G-\u001a4\n\u0005E\u0013&AB*ue&twM\u0003\u0002P]\u0005Y!-\u001b;Pa\u0016\u0014\u0018\r^8s)\r)\u0006L\u0017\t\u0003\u0003ZK!a\u0016\u000e\u0003!\tKg.\u0019:z\u0003JLG\u000f[7fi&\u001c\u0007\"B-\u0006\u0001\u0004\u0001\u0015\u0001\u00027fMRDQaW\u0003A\u0002\u0001\u000bQA]5hQR\fAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGC\u0001!_\u0011\u0015yf\u00011\u0001A\u0003!qWm^\"iS2$\u0017\u0001B2paf$\"a\u00122\t\u000fy:\u0001\u0013!a\u0001\u0001\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A3+\u0005\u000137&A4\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017!C;oG\",7m[3e\u0015\tag&\u0001\u0006b]:|G/\u0019;j_:L!A\\5\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002cB\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u0005Y\u0006twMC\u0001w\u0003\u0011Q\u0017M^1\n\u0005E\u001b\u0018\u0001\u00049s_\u0012,8\r^!sSRLX#\u0001>\u0011\u00055Z\u0018B\u0001?/\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\ry\u0018Q\u0001\t\u0004[\u0005\u0005\u0011bAA\u0002]\t\u0019\u0011I\\=\t\u0011\u0005\u001d1\"!AA\u0002i\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0007!\u0015\ty!!\u0006\u0000\u001b\t\t\tBC\u0002\u0002\u00149\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9\"!\u0005\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003;\t\u0019\u0003E\u0002.\u0003?I1!!\t/\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\u0002\u000e\u0003\u0003\u0005\ra`\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\rF\u0002r\u0003SA\u0001\"a\u0002\u000f\u0003\u0003\u0005\rA_\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005u\u0011q\u0006\u0005\t\u0003\u000fy\u0011\u0011!a\u0001\u007f\"\u001a\u0002!a\r\u0002:\u0005m\u0012qHA!\u0003\u000b\n9%a\u0013\u0002NA\u0019\u0011)!\u000e\n\u0007\u0005]\"DA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005u\u0012!V0G+:\u001bu\fK3yaJL\u0003%\f\u0011SKR,(O\\:!i\",\u0007EY5uo&\u001cX\r\t-P%\u0002zg\rI1mY\u0002rwN\\\u0017ok2d\u0007%\u001b8qkR\u0004c/\u00197vKNd\u0003e\u001c:!]VdG\u000eI5gA9|g.\u001a\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\u0011\u0002/*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3m\u001c7*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)g%b\u0003\u0005K\u001b*A\u0005\u001b\u0006\u0005^1cQ\r|G.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!m)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002J\u0005I\u0011mZ4`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003\u001f\nQa\r\u00181]A\n\u0011BQ5u1>\u0014\u0018iZ4\u0011\u0005%\n2#B\t\u0002X\u0005\r\u0004CBA-\u0003?\u0002u)\u0004\u0002\u0002\\)\u0019\u0011Q\f\u0018\u0002\u000fI,h\u000e^5nK&!\u0011\u0011MA.\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\t\u0005\u0003K\nY'\u0004\u0002\u0002h)\u0019\u0011\u0011N;\u0002\u0005%|\u0017b\u0001\u001f\u0002hQ\u0011\u00111K\u0001\ti>\u001cFO]5oOR\t\u0011/A\u0003baBd\u0017\u0010F\u0002H\u0003oBQA\u0010\u000bA\u0002\u0001\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002~\u0005\r\u0005\u0003B\u0017\u0002\u0000\u0001K1!!!/\u0005\u0019y\u0005\u000f^5p]\"A\u0011QQ\u000b\u0002\u0002\u0003\u0007q)A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a#\u0011\u0007I\fi)C\u0002\u0002\u0010N\u0014aa\u00142kK\u000e$\b")
public class BitXorAgg
extends BitAggregate {
    private final Expression child;

    public static Option<Expression> unapply(BitXorAgg x$0) {
        return BitXorAgg$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<BitXorAgg, A> g) {
        return BitXorAgg$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, BitXorAgg> compose(Function1<A$, Expression> g) {
        return BitXorAgg$.MODULE$.compose(g);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public String nodeName() {
        return "bit_xor";
    }

    @Override
    public BinaryArithmetic bitOperator(Expression left, Expression right) {
        return new BitwiseXor(left, right);
    }

    @Override
    public Expression withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public BitXorAgg copy(Expression child) {
        return new BitXorAgg(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "BitXorAgg";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitXorAgg;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitXorAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitXorAgg bitXorAgg = (BitXorAgg)x$1;
        Expression expression = this.child();
        Expression expression2 = bitXorAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitXorAgg.canEqual(this)) return false;
        return true;
    }

    public BitXorAgg(Expression child) {
        this.child = child;
    }
}

