/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.hive;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.examples.sql.hive.SparkHiveExample;
import org.apache.spark.examples.sql.hive.SparkHiveExample$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class SparkHiveExample$ {
    public static final SparkHiveExample$ MODULE$ = new SparkHiveExample$();

    public void main(String[] args) {
        String warehouseLocation = new File("spark-warehouse").getAbsolutePath();
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Spark Hive Example").config("spark.sql.warehouse.dir", warehouseLocation).enableHiveSupport().getOrCreate();
        spark.sql("CREATE TABLE IF NOT EXISTS src (key INT, value STRING) USING hive");
        spark.sql("LOAD DATA LOCAL INPATH 'examples/src/main/resources/kv1.txt' INTO TABLE src");
        spark.sql("SELECT * FROM src").show();
        spark.sql("SELECT COUNT(*) FROM src").show();
        Dataset sqlDF = spark.sql("SELECT key, value FROM src WHERE key < 10 ORDER BY key");
        Dataset stringsDS = sqlDF.map((Function1 & Serializable)x0$1 -> {
            Some some;
            Row row = x0$1;
            if (row != null && !(some = Row$.MODULE$.unapplySeq(row)).isEmpty() && some.get() != null && ((SeqOps)some.get()).lengthCompare(2) == 0) {
                Object key = ((SeqOps)some.get()).apply(0);
                Object value = ((SeqOps)some.get()).apply(1);
                if (key instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt((Object)key);
                    if (value instanceof String) {
                        String string = (String)value;
                        return "Key: " + n + ", Value: " + string;
                    }
                }
            }
            throw new MatchError((Object)row);
        }, spark.implicits().newStringEncoder());
        stringsDS.show();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_sql_hive_SparkHiveExample$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.sql.hive.SparkHiveExample.Record").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_sql_hive_SparkHiveExample$$typecreator5$1() {
            }
        }
        Dataset recordsDF = spark.createDataFrame((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100).map((Function1 & Serializable)i -> SparkHiveExample$.$anonfun$main$2(BoxesRunTime.unboxToInt((Object)i))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_sql_hive_SparkHiveExample$$typecreator5$1()));
        recordsDF.createOrReplaceTempView("records");
        spark.sql("SELECT * FROM records r JOIN src s ON r.key = s.key").show();
        spark.sql("CREATE TABLE hive_records(key int, value string) STORED AS PARQUET");
        Dataset df = spark.table("src");
        df.write().mode(SaveMode.Overwrite).saveAsTable("hive_records");
        spark.sql("SELECT * FROM hive_records").show();
        String dataDir = "/tmp/parquet_data";
        spark.range(10L).write().parquet(dataDir);
        spark.sql("CREATE EXTERNAL TABLE hive_bigints(id bigint) STORED AS PARQUET LOCATION '" + dataDir + "'");
        spark.sql("SELECT * FROM hive_bigints").show();
        spark.conf().set("hive.exec.dynamic.partition", "true");
        spark.conf().set("hive.exec.dynamic.partition.mode", "nonstrict");
        df.write().partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key"})).format("hive").saveAsTable("hive_part_tbl");
        spark.sql("SELECT * FROM hive_part_tbl").show();
        spark.stop();
    }

    public static final /* synthetic */ SparkHiveExample.Record $anonfun$main$2(int i) {
        return new SparkHiveExample.Record(i, "val_" + i);
    }

    private SparkHiveExample$() {
    }
}

