/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArrayBasedSimpleHigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.ArraySort$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.SimpleHigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NullType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr, func) - Sorts the input array. If func is omitted, sort\n    in ascending order. The elements of the input array must be orderable.\n    NaN is greater than any non-NaN elements for double/float type.\n    Null elements will be placed at the end of the returned array.\n    Since 3.0.0 this function also sorts and returns the array based on the\n    given comparator function. The comparator will take two arguments representing\n    two elements of the array.\n    It returns a negative integer, 0, or a positive integer as the first element is less than,\n    equal to, or greater than the second element. If the comparator function returns null,\n    the function will fail and raise an error.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(array(5, 6, 1), (left, right) -> case when left < right then -1 when left > right then 1 else 0 end);\n       [1,5,6]\n      > SELECT _FUNC_(array('bc', 'ab', 'dc'), (left, right) -> case when left is null and right is null then 0 when left is null then -1 when right is null then 1 when left < right then 1 when left > right then -1 else 0 end);\n       [\"dc\",\"bc\",\"ab\"]\n      > SELECT _FUNC_(array('b', 'd', null, 'c', 'a'));\n       [\"a\",\"b\",\"c\",\"d\",null]\n  ", since="2.4.0", group="lambda_funcs")
@ScalaSignature(bytes="\u0006\u0005\t]d\u0001\u0002\u0016,\u0001bB\u0001\u0002\u0017\u0001\u0003\u0016\u0004%\t!\u0017\u0005\t5\u0002\u0011\t\u0012)A\u0005s!A1\f\u0001BK\u0002\u0013\u0005\u0011\f\u0003\u0005]\u0001\tE\t\u0015!\u0003:\u0011!i\u0006A!f\u0001\n\u0003q\u0006\u0002\u00032\u0001\u0005#\u0005\u000b\u0011B0\t\u000b\r\u0004A\u0011\u00013\t\u000b\r\u0004A\u0011A5\t\u000b\r\u0004A\u0011\u00017\t\u00119\u0004\u0001R1A\u0005\u0002=DQA\u001f\u0001\u0005BmDaa \u0001\u0005B\u0005\u0005\u0001bBA\b\u0001\u0011E\u0013\u0011\u0003\u0005\r\u0003_\u0001\u0001\u0013!EDB\u0013%\u0011\u0011\u0007\u0005\u000b\u0003w\u0001\u0001R1A\u0005\u0002\u0005u\u0002BCA!\u0001!\u0015\r\u0011\"\u0001\u0002>!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0003bBA6\u0001\u0011\u0005\u0013Q\u000e\u0005\b\u0003k\u0002A\u0011IA<\u0011\u001d\tI\t\u0001C)\u0003\u0017C\u0011\"!&\u0001\u0003\u0003%\t!a&\t\u0013\u0005}\u0005!%A\u0005\u0002\u0005\u0005\u0006\"CA\\\u0001E\u0005I\u0011AAQ\u0011%\tI\fAI\u0001\n\u0003\tY\fC\u0005\u0002@\u0002\t\t\u0011\"\u0011\u0002B\"I\u0011Q\u001a\u0001\u0002\u0002\u0013\u0005\u0011q\u001a\u0005\n\u0003/\u0004\u0011\u0011!C\u0001\u00033D\u0011\"a8\u0001\u0003\u0003%\t%!9\t\u0013\u0005=\b!!A\u0005\u0002\u0005E\b\"CA{\u0001\u0005\u0005I\u0011IA|\u0011%\tY\u0010AA\u0001\n\u0003\nipB\u0004\u0003\"-B\tAa\t\u0007\r)Z\u0003\u0012\u0001B\u0013\u0011\u0019\u0019\u0017\u0005\"\u0001\u00038!9!\u0011H\u0011\u0005\u0002\tm\u0002bBA#C\u0011\u0005!\u0011\t\u0005\n\u0005\u0017\n#\u0019!C\u0001\u0005\u001bB\u0001Ba\u0014\"A\u0003%\u0011\u0011\u0006\u0005\n\u0005s\t\u0013\u0011!CA\u0005#B\u0011B!\u0017\"\u0003\u0003%\tIa\u0017\t\u0013\t5\u0014%!A\u0005\n\t=$!C!se\u0006L8k\u001c:u\u0015\taS&A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u00180\u0003!\u0019\u0017\r^1msN$(B\u0001\u00192\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003eM\nQa\u001d9be.T!\u0001N\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0014aA8sO\u000e\u00011C\u0002\u0001:{\u00013E\n\u0005\u0002;w5\t1&\u0003\u0002=W\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ir\u0014BA ,\u0005\r\n%O]1z\u0005\u0006\u001cX\rZ*j[BdW\rS5hQ\u0016\u0014xJ\u001d3fe\u001a+hn\u0019;j_:\u0004\"!\u0011#\u000e\u0003\tS!aQ\u0016\u0002\u000f\r|G-Z4f]&\u0011QI\u0011\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0011qIS\u0007\u0002\u0011*\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0011\n9\u0001K]8ek\u000e$\bCA'V\u001d\tq5K\u0004\u0002P%6\t\u0001K\u0003\u0002Ro\u00051AH]8pizJ\u0011!S\u0005\u0003)\"\u000bq\u0001]1dW\u0006<W-\u0003\u0002W/\na1+\u001a:jC2L'0\u00192mK*\u0011A\u000bS\u0001\tCJ<W/\\3oiV\t\u0011(A\u0005be\u001e,X.\u001a8uA\u0005Aa-\u001e8di&|g.A\u0005gk:\u001cG/[8oA\u0005I\u0012\r\u001c7po:+H\u000e\\\"p[B\f'/[:p]J+7/\u001e7u+\u0005y\u0006CA$a\u0013\t\t\u0007JA\u0004C_>dW-\u00198\u00025\u0005dGn\\<Ok2d7i\\7qCJL7o\u001c8SKN,H\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\u0011)gm\u001a5\u0011\u0005i\u0002\u0001\"\u0002-\b\u0001\u0004I\u0004\"B.\b\u0001\u0004I\u0004\"B/\b\u0001\u0004yFcA3kW\")\u0001\f\u0003a\u0001s!)1\f\u0003a\u0001sQ\u0011Q-\u001c\u0005\u00061&\u0001\r!O\u0001\fK2,W.\u001a8u)f\u0004X-F\u0001q!\t\tH/D\u0001s\u0015\t\u0019x&A\u0003usB,7/\u0003\u0002ve\nAA)\u0019;b)f\u0004X\r\u000b\u0002\u000boB\u0011q\t_\u0005\u0003s\"\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001 \t\u0003cvL!A :\u0003\u0013\u0005\u0013(/Y=UsB,\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAA\u0002!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005[\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002\u000e\u0005\u001d!a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u0019\tLg\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007\u0015\f\u0019\u0002C\u0004\u0002\u00165\u0001\r!a\u0006\u0002\u0003\u0019\u0004\u0002bRA\rs\u0005u\u0011\u0011F\u0005\u0004\u00037A%!\u0003$v]\u000e$\u0018n\u001c83!\u0015i\u0015qDA\u0012\u0013\r\t\tc\u0016\u0002\u0004'\u0016\f\b#B$\u0002&A|\u0016bAA\u0014\u0011\n1A+\u001e9mKJ\u00022AOA\u0016\u0013\r\tic\u000b\u0002\u000f\u0019\u0006l'\rZ1Gk:\u001cG/[8o\u0003\u0011AH%M\u0019\u0016\u0005\u0005M\u0002cB$\u0002&\u0005U\u0012Q\u0007\t\u0004u\u0005]\u0012bAA\u001dW\t\u0019b*Y7fI2\u000bWN\u00193b-\u0006\u0014\u0018.\u00192mK\u0006aa-\u001b:ti\u0016cW-\u001c,beV\u0011\u0011Q\u0007\u0015\u0003\u001f]\fQb]3d_:$W\t\\3n-\u0006\u0014\bF\u0001\tx\u0003)\u0019w.\u001c9be\u0006$xN\u001d\u000b\u0005\u0003\u0013\ny\u0006\u0005\u0004\u0002L\u0005U\u0013\u0011L\u0007\u0003\u0003\u001bRA!a\u0014\u0002R\u0005!Q\u000f^5m\u0015\t\t\u0019&\u0001\u0003kCZ\f\u0017\u0002BA,\u0003\u001b\u0012!bQ8na\u0006\u0014\u0018\r^8s!\r9\u00151L\u0005\u0004\u0003;B%aA!os\"9\u0011\u0011M\tA\u0002\u0005\r\u0014\u0001C5oaV$(k\\<\u0011\t\u0005\u0015\u0014qM\u0007\u0002[%\u0019\u0011\u0011N\u0017\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0007\u00033\ny'!\u001d\t\u000f\u0005\u0005$\u00031\u0001\u0002d!9\u00111\u000f\nA\u0002\u0005e\u0013!D1sOVlWM\u001c;WC2,X-\u0001\u0005o_\u0012,g*Y7f+\t\tI\b\u0005\u0003\u0002|\u0005\re\u0002BA?\u0003\u007f\u0002\"a\u0014%\n\u0007\u0005\u0005\u0005*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000b\u000b9I\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0003C\u0015aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015)\u0017QRAI\u0011\u0019\ty\t\u0006a\u0001s\u00059a.Z<MK\u001a$\bBBAJ)\u0001\u0007\u0011(\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000f\u0015\fI*a'\u0002\u001e\"9\u0001,\u0006I\u0001\u0002\u0004I\u0004bB.\u0016!\u0003\u0005\r!\u000f\u0005\b;V\u0001\n\u00111\u0001`\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a)+\u0007e\n)k\u000b\u0002\u0002(B!\u0011\u0011VAZ\u001b\t\tYK\u0003\u0003\u0002.\u0006=\u0016!C;oG\",7m[3e\u0015\r\t\t\fS\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA[\u0003W\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002>*\u001aq,!*\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\r\u0005\u0003\u0002F\u0006-WBAAd\u0015\u0011\tI-!\u0015\u0002\t1\fgnZ\u0005\u0005\u0003\u000b\u000b9-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002RB\u0019q)a5\n\u0007\u0005U\u0007JA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002Z\u0005m\u0007\"CAo7\u0005\u0005\t\u0019AAi\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u001d\t\u0007\u0003K\fY/!\u0017\u000e\u0005\u0005\u001d(bAAu\u0011\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u0018q\u001d\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002`\u0003gD\u0011\"!8\u001e\u0003\u0003\u0005\r!!\u0017\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u0007\fI\u0010C\u0005\u0002^z\t\t\u00111\u0001\u0002R\u00061Q-];bYN$2aXA\u0000\u0011%\tinHA\u0001\u0002\u0004\tI\u0006K\n\u0001\u0005\u0007\u0011IAa\u0003\u0003\u0010\tE!Q\u0003B\f\u00057\u0011i\u0002E\u0002;\u0005\u000bI1Aa\u0002,\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#A!\u0004\u0002\u000b\u000b{f)\u0016(D?\"*\u0007\u0010\u001d:-A\u0019,hnY\u0015![\u0001\u001avN\u001d;tAQDW\rI5oaV$\b%\u0019:sCft\u0003%\u00134!MVt7\rI5tA=l\u0017\u000e\u001e;fI2\u00023o\u001c:u\u0015\u0001\u0002\u0003\u0005I5oA\u0005\u001c8-\u001a8eS:<\u0007e\u001c:eKJt\u0003\u0005\u00165fA\u0015dW-\\3oiN\u0004sN\u001a\u0011uQ\u0016\u0004\u0013N\u001c9vi\u0002\n'O]1zA5,8\u000f\u001e\u0011cK\u0002z'\u000fZ3sC\ndWM\f\u0006!A\u0001\u0002c*\u0019(!SN\u0004sM]3bi\u0016\u0014\b\u0005\u001e5b]\u0002\ng.\u001f\u0011o_:lc*\u0019(!K2,W.\u001a8ug\u00022wN\u001d\u0011e_V\u0014G.Z\u0018gY>\fG\u000f\t;za\u0016t#\u0002\t\u0011!A9+H\u000e\u001c\u0011fY\u0016lWM\u001c;tA]LG\u000e\u001c\u0011cK\u0002\u0002H.Y2fI\u0002\nG\u000f\t;iK\u0002*g\u000e\u001a\u0011pM\u0002\"\b.\u001a\u0011sKR,(O\\3eA\u0005\u0014(/Y=/\u0015\u0001\u0002\u0003\u0005I*j]\u000e,\u0007e\r\u00181]A\u0002C\u000f[5tA\u0019,hn\u0019;j_:\u0004\u0013\r\\:pAM|'\u000f^:!C:$\u0007E]3ukJt7\u000f\t;iK\u0002\n'O]1zA\t\f7/\u001a3!_:\u0004C\u000f[3\u000bA\u0001\u0002\u0003eZ5wK:\u00043m\\7qCJ\fGo\u001c:!MVt7\r^5p]:\u0002C\u000b[3!G>l\u0007/\u0019:bi>\u0014\be^5mY\u0002\"\u0018m[3!i^|\u0007%\u0019:hk6,g\u000e^:!e\u0016\u0004(/Z:f]RLgn\u001a\u0006!A\u0001\u0002Co^8!K2,W.\u001a8ug\u0002zg\r\t;iK\u0002\n'O]1z])\u0001\u0003\u0005\t\u0011Ji\u0002\u0012X\r^;s]N\u0004\u0013\r\t8fO\u0006$\u0018N^3!S:$XmZ3sY\u0001\u0002D\u0006I8sA\u0005\u0004\u0003o\\:ji&4X\rI5oi\u0016<WM\u001d\u0011bg\u0002\"\b.\u001a\u0011gSJ\u001cH\u000fI3mK6,g\u000e\u001e\u0011jg\u0002bWm]:!i\"\fg\u000e\f\u0006!A\u0001\u0002S-];bY\u0002\"x\u000e\f\u0011pe\u0002:'/Z1uKJ\u0004C\u000f[1oAQDW\rI:fG>tG\rI3mK6,g\u000e\u001e\u0018!\u0013\u001a\u0004C\u000f[3!G>l\u0007/\u0019:bi>\u0014\bEZ;oGRLwN\u001c\u0011sKR,(O\\:!]VdG\u000e\f\u0006!A\u0001\u0002C\u000f[3!MVt7\r^5p]\u0002:\u0018\u000e\u001c7!M\u0006LG\u000eI1oI\u0002\u0012\u0018-[:fA\u0005t\u0007%\u001a:s_Jt#\u0002\t\u0011!A\u0005AQ\r_1na2,7/\t\u0002\u0003\u0014\u0005\u0019iN\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u001b-AYb\u0003%M\u0015-A!bWM\u001a;-AILw\r\u001b;*A5r\u0004eY1tK\u0002:\b.\u001a8!Y\u00164G\u000f\t\u001f!e&<\u0007\u000e\u001e\u0011uQ\u0016t\u0007%L\u0019!o\",g\u000e\t7fMR\u0004c\b\t:jO\"$\b\u0005\u001e5f]\u0002\n\u0004%\u001a7tK\u0002\u0002\u0004%\u001a8eSmR\u0001\u0005\t\u0011!A\u0001\u00023,\r\u00176YYj&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\bf\n2dO1\u0002s%\u00192(Y\u0001:CmY\u0014*Y\u0001BC.\u001a4uY\u0001\u0012\u0018n\u001a5uS\u0001jc\bI2bg\u0016\u0004s\u000f[3oA1,g\r\u001e\u0011jg\u0002rW\u000f\u001c7!C:$\u0007E]5hQR\u0004\u0013n\u001d\u0011ok2d\u0007\u0005\u001e5f]\u0002\u0002\u0004e\u001e5f]\u0002bWM\u001a;!SN\u0004c.\u001e7mAQDWM\u001c\u0011.c\u0001:\b.\u001a8!e&<\u0007\u000e\u001e\u0011jg\u0002rW\u000f\u001c7!i\",g\u000eI\u0019!o\",g\u000e\t7fMR\u0004C\b\t:jO\"$\b\u0005\u001e5f]\u0002\n\u0004e\u001e5f]\u0002bWM\u001a;!}\u0001\u0012\u0018n\u001a5uAQDWM\u001c\u0011.c\u0001*Gn]3!a\u0001*g\u000eZ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0013Cm\u0019\u0012-E\t\u001c'\u0005\f\u0012bE\nj&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\bf\n2(Y\u0001:Cm\n\u0017!]VdG\u000e\f\u0011(G\u001eb\u0003eJ1(S%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0017\u0012bE1\u0012#M\t\u0017#G\nb#\u0005\u001a\u0012-]VdG.\u0018\u0006!A\u0005)1/\u001b8dK\u0006\u0012!\u0011D\u0001\u0006e9\"d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005?\tA\u0002\\1nE\u0012\fwLZ;oGN\f\u0011\"\u0011:sCf\u001cvN\u001d;\u0011\u0005i\n3#B\u0011\u0003(\t5\u0002cA$\u0003*%\u0019!1\u0006%\u0003\r\u0005s\u0017PU3g!\u0011\u0011yC!\u000e\u000e\u0005\tE\"\u0002\u0002B\u001a\u0003#\n!![8\n\u0007Y\u0013\t\u0004\u0006\u0002\u0003$\u0005)\u0011\r\u001d9msR)QM!\u0010\u0003@!)\u0001l\ta\u0001s!)1l\ta\u0001sQ)\u0011Ha\u0011\u0003H!1!Q\t\u0013A\u0002e\nA\u0001\\3gi\"1!\u0011\n\u0013A\u0002e\nQA]5hQR\f\u0011\u0003Z3gCVdGoQ8na\u0006\u0014\u0018\r^8s+\t\tI#\u0001\neK\u001a\fW\u000f\u001c;D_6\u0004\u0018M]1u_J\u0004CcB3\u0003T\tU#q\u000b\u0005\u00061\u001e\u0002\r!\u000f\u0005\u00067\u001e\u0002\r!\u000f\u0005\u0006;\u001e\u0002\raX\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011iF!\u001b\u0011\u000b\u001d\u0013yFa\u0019\n\u0007\t\u0005\u0004J\u0001\u0004PaRLwN\u001c\t\u0007\u000f\n\u0015\u0014(O0\n\u0007\t\u001d\u0004J\u0001\u0004UkBdWm\r\u0005\t\u0005WB\u0013\u0011!a\u0001K\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tE\u0004\u0003BAc\u0005gJAA!\u001e\u0002H\n1qJ\u00196fGR\u0004")
public class ArraySort
extends Expression
implements ArrayBasedSimpleHigherOrderFunction,
CodegenFallback,
Serializable {
    private transient DataType elementType;
    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$11;
    private transient NamedLambdaVariable firstElemVar;
    private transient NamedLambdaVariable secondElemVar;
    private final Expression argument;
    private final Expression function;
    private final boolean allowNullComparisonResult;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private boolean argumentsResolved;
    private boolean resolved;
    private transient Seq<Expression> functionsForEval;
    private Expression canonicalized;
    private volatile transient byte bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(ArraySort x$0) {
        return ArraySort$.MODULE$.unapply(x$0);
    }

    public static LambdaFunction defaultComparator() {
        return ArraySort$.MODULE$.defaultComparator();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public AbstractDataType argumentType() {
        return ArrayBasedSimpleHigherOrderFunction.argumentType$(this);
    }

    @Override
    public Seq<Expression> arguments() {
        return SimpleHigherOrderFunction.arguments$(this);
    }

    @Override
    public Seq<AbstractDataType> argumentTypes() {
        return SimpleHigherOrderFunction.argumentTypes$(this);
    }

    @Override
    public Seq<Expression> functions() {
        return SimpleHigherOrderFunction.functions$(this);
    }

    @Override
    public AbstractDataType functionType() {
        return SimpleHigherOrderFunction.functionType$(this);
    }

    @Override
    public Seq<AbstractDataType> functionTypes() {
        return SimpleHigherOrderFunction.functionTypes$(this);
    }

    @Override
    public Expression functionForEval() {
        return SimpleHigherOrderFunction.functionForEval$(this);
    }

    @Override
    public Expression left() {
        return SimpleHigherOrderFunction.left$(this);
    }

    @Override
    public Expression right() {
        return SimpleHigherOrderFunction.right$(this);
    }

    @Override
    public Object eval(InternalRow inputRow) {
        return SimpleHigherOrderFunction.eval$(this, inputRow);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public boolean nullable() {
        return HigherOrderFunction.nullable$(this);
    }

    @Override
    public TypeCheckResult checkArgumentDataTypes() {
        return HigherOrderFunction.checkArgumentDataTypes$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return HigherOrderFunction.inputTypes$(this);
    }

    @Override
    public final HigherOrderFunction bind(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        return HigherOrderFunction.bind$(this, f);
    }

    private Seq<Expression> children$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if ((byte)(this.bitmap$trans$0 & 8) == 0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean argumentsResolved$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.argumentsResolved = HigherOrderFunction.argumentsResolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.argumentsResolved;
    }

    @Override
    public boolean argumentsResolved() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.argumentsResolved$lzycompute();
        }
        return this.argumentsResolved;
    }

    private boolean resolved$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.resolved = HigherOrderFunction.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    private Seq<Expression> functionsForEval$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.functionsForEval = HigherOrderFunction.functionsForEval$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.functionsForEval;
    }

    @Override
    public Seq<Expression> functionsForEval() {
        if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
            return this.functionsForEval$lzycompute();
        }
        return this.functionsForEval;
    }

    private Expression canonicalized$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.canonicalized = HigherOrderFunction.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$HigherOrderFunction$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression argument() {
        return this.argument;
    }

    @Override
    public Expression function() {
        return this.function;
    }

    public boolean allowNullComparisonResult() {
        return this.allowNullComparisonResult;
    }

    private DataType elementType$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.elementType = ((ArrayType)this.argument().dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.elementType;
    }

    public DataType elementType() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    public ArrayType dataType() {
        return (ArrayType)this.argument().dataType();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult = this.checkArgumentDataTypes();
        if (TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult)) {
            DataType dataType = this.argument().dataType();
            if (dataType instanceof ArrayType) {
                DataType dataType2 = this.function().dataType();
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (!(dataType2 != null ? !dataType2.equals(integerType$) : integerType$ != null)) {
                    return TypeCheckResult$TypeCheckSuccess$.MODULE$;
                }
                return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_RETURN_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)Cast$.MODULE$.toSQLId(this.function().prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)this.function().dataType()))}))));
            }
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)Cast$.MODULE$.ordinalNumber(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)ArrayType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)Cast$.MODULE$.toSQLExpr(this.argument())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)this.argument().dataType()))}))));
        }
        return typeCheckResult;
    }

    @Override
    public ArraySort bindInternal(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        DataType dataType = this.argument().dataType();
        if (!(dataType instanceof ArrayType)) {
            throw new MatchError((Object)dataType);
        }
        ArrayType arrayType = (ArrayType)dataType;
        DataType elementType = arrayType.elementType();
        boolean containsNull = arrayType.containsNull();
        Tuple2 tuple2 = new Tuple2((Object)elementType, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull));
        DataType elementType2 = (DataType)tuple2._1();
        boolean containsNull2 = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)elementType2, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull2));
        Tuple2 tuple23 = new Tuple2((Object)elementType2, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull2));
        LambdaFunction x$1 = (LambdaFunction)f.apply((Object)this.function(), (Object)Nil$.MODULE$.$colon$colon((Object)tuple23).$colon$colon((Object)tuple22));
        Expression x$2 = this.copy$default$1();
        boolean x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$11$lzycompute() {
        block5: {
            ArraySort arraySort = this;
            synchronized (arraySort) {
                NamedLambdaVariable namedLambdaVariable;
                NamedExpression secondElemVar;
                block7: {
                    Expression expression;
                    block6: {
                        SeqOps seqOps;
                        LambdaFunction lambdaFunction;
                        Seq<NamedExpression> seq;
                        if ((byte)(this.bitmap$0 & 1) != 0) break block5;
                        expression = this.function();
                        if (!(expression instanceof LambdaFunction) || (seq = (lambdaFunction = (LambdaFunction)expression).arguments()) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) break block6;
                        NamedExpression firstElemVar = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                        secondElemVar = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                        if (!(firstElemVar instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable = (NamedLambdaVariable)firstElemVar;
                        if (secondElemVar instanceof NamedLambdaVariable) break block7;
                    }
                    throw new MatchError((Object)expression);
                }
                NamedLambdaVariable namedLambdaVariable2 = (NamedLambdaVariable)secondElemVar;
                this.x$11 = new Tuple2((Object)namedLambdaVariable, (Object)namedLambdaVariable2);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$11;
    }

    private /* synthetic */ Tuple2 x$11() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.x$11$lzycompute();
        }
        return this.x$11;
    }

    private NamedLambdaVariable firstElemVar$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.firstElemVar = (NamedLambdaVariable)this.x$11()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.firstElemVar;
    }

    public NamedLambdaVariable firstElemVar() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.firstElemVar$lzycompute();
        }
        return this.firstElemVar;
    }

    private NamedLambdaVariable secondElemVar$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.secondElemVar = (NamedLambdaVariable)this.x$11()._2();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.secondElemVar;
    }

    public NamedLambdaVariable secondElemVar() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.secondElemVar$lzycompute();
        }
        return this.secondElemVar;
    }

    public Comparator<Object> comparator(InternalRow inputRow) {
        Expression f = this.functionForEval();
        return (o1, o2) -> {
            this.firstElemVar().value().set(o1);
            this.secondElemVar().value().set(o2);
            Object cmp = f.eval(inputRow);
            if (!this.allowNullComparisonResult() && cmp == null) {
                throw QueryExecutionErrors$.MODULE$.comparatorReturnsNull(o1.toString(), o1.toString());
            }
            return BoxesRunTime.unboxToInt((Object)cmp);
        };
    }

    @Override
    public Object nullSafeEval(InternalRow inputRow, Object argumentValue) {
        Object[] arr = (Object[])((ArrayData)argumentValue).toArray(this.elementType(), ClassTag$.MODULE$.AnyRef());
        DataType dataType = this.elementType();
        NullType$ nullType$ = NullType$.MODULE$;
        if (dataType == null ? nullType$ != null : !dataType.equals(nullType$)) {
            Arrays.sort(arr, this.comparator(inputRow));
        }
        return new GenericArrayData(arr);
    }

    @Override
    public String nodeName() {
        return "array_sort";
    }

    @Override
    public ArraySort withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public ArraySort copy(Expression argument, Expression function, boolean allowNullComparisonResult) {
        return new ArraySort(argument, function, allowNullComparisonResult);
    }

    public Expression copy$default$1() {
        return this.argument();
    }

    public Expression copy$default$2() {
        return this.function();
    }

    public boolean copy$default$3() {
        return this.allowNullComparisonResult();
    }

    @Override
    public String productPrefix() {
        return "ArraySort";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.argument();
            }
            case 1: {
                return this.function();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.allowNullComparisonResult());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraySort;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "argument";
            }
            case 1: {
                return "function";
            }
            case 2: {
                return "allowNullComparisonResult";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraySort)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraySort arraySort = (ArraySort)x$1;
        if (this.allowNullComparisonResult() != arraySort.allowNullComparisonResult()) return false;
        Expression expression = this.argument();
        Expression expression2 = arraySort.argument();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.function();
        Expression expression4 = arraySort.function();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arraySort.canEqual(this)) return false;
        return true;
    }

    public ArraySort(Expression argument, Expression function, boolean allowNullComparisonResult) {
        this.argument = argument;
        this.function = function;
        this.allowNullComparisonResult = allowNullComparisonResult;
        ExpectsInputTypes.$init$(this);
        HigherOrderFunction.$init$(this);
        BinaryLike.$init$(this);
        SimpleHigherOrderFunction.$init$(this);
        ArrayBasedSimpleHigherOrderFunction.$init$(this);
        CodegenFallback.$init$(this);
        Statics.releaseFence();
    }

    public ArraySort(Expression argument, Expression function) {
        this(argument, function, BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_ALLOW_NULL_COMPARISON_RESULT_IN_ARRAY_SORT())));
    }

    public ArraySort(Expression argument) {
        this(argument, ArraySort$.MODULE$.defaultComparator());
    }
}

