/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.pipelines.graph.GraphExecution;
import org.apache.spark.sql.pipelines.graph.GraphExecution$;
import org.apache.spark.sql.pipelines.graph.GraphExecution$RetryFlowExecution$;
import org.apache.spark.sql.pipelines.graph.PipelineUpdateContext;
import org.apache.spark.sql.pipelines.graph.ResolvedFlow;
import org.apache.spark.sql.pipelines.graph.RunTerminationException;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class PipelinesErrors$
implements Logging {
    public static final PipelinesErrors$ MODULE$ = new PipelinesErrors$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ArrayBuffer<Throwable> getExceptionChain(Throwable originalErr) {
        ArrayBuffer exceptionChain = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        for (Throwable lastException = originalErr; lastException != null; lastException = lastException.getCause()) {
            exceptionChain.$plus$eq((Object)lastException);
        }
        return exceptionChain;
    }

    private boolean checkCauses(Throwable throwable, Function1<Throwable, Object> check) {
        return this.getExceptionChain(throwable).exists(check);
    }

    public void checkStreamingErrorsAndRetry(Throwable ex2, PipelineUpdateContext env, GraphExecution graphExecution, ResolvedFlow flow, boolean shouldRethrow, int prevFailureCount, int maxRetries, Function0<BoxedUnit> onRetry) {
        if (this.checkCauses(ex2, (Function1<Throwable, Object>)(Function1 & Serializable)ex -> BoxesRunTime.boxToBoolean((boolean)PipelinesErrors$.$anonfun$checkStreamingErrorsAndRetry$1(ex)))) {
            String message = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |Flow '" + flow.displayName() + "' had streaming sources added or removed. Please perform a\n         |full refresh in order to rebuild '" + flow.displayName() + "' against the current set of\n         |sources.\n         |"));
            env.flowProgressEventLogger().recordFailed(flow, ex2, false, (Option<String>)Option$.MODULE$.apply((Object)message));
            return;
        }
        if (flow.once() && ex2 == null) {
            return;
        }
        GraphExecution.FlowExecutionAction actionFromError = GraphExecution$.MODULE$.determineFlowExecutionActionFromError((Function0<Throwable>)(Function0 & Serializable)() -> ex2, (Function0<String>)(Function0 & Serializable)() -> flow.displayName(), (Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> prevFailureCount + 1, (Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> maxRetries);
        GraphExecution.FlowExecutionAction flowExecutionAction = actionFromError;
        if (GraphExecution$RetryFlowExecution$.MODULE$.equals(flowExecutionAction)) {
            onRetry.apply$mcV$sp();
            return;
        }
        if (flowExecutionAction instanceof GraphExecution.StopFlowExecution) {
            GraphExecution.StopFlowExecution stopFlowExecution = (GraphExecution.StopFlowExecution)flowExecutionAction;
            GraphExecution.FlowExecutionStopReason reason = stopFlowExecution.reason();
            String msg = reason.failureMessage();
            if (reason.warnInsteadOfError()) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> msg, reason.cause());
                env.flowProgressEventLogger().recordStop(flow, (Option<String>)Option$.MODULE$.apply((Object)msg), (Option<Throwable>)Option$.MODULE$.apply((Object)reason.cause()));
            } else {
                this.logError((Function0<String>)(Function0 & Serializable)() -> reason.failureMessage(), reason.cause());
                env.flowProgressEventLogger().recordFailed(flow, reason.cause(), false, (Option<String>)Option$.MODULE$.apply((Object)msg));
            }
            if (shouldRethrow) {
                throw new RunTerminationException(reason.runTerminationReason());
            }
            return;
        }
        throw new MatchError((Object)flowExecutionAction);
    }

    public static final /* synthetic */ boolean $anonfun$checkStreamingErrorsAndRetry$1(Throwable ex) {
        return ex instanceof AssertionError && ex.getMessage() != null && ex.getMessage().contains("sources in the checkpoint offsets and now there are") && ex.getMessage().contains("sources requested by the query. Cannot continue.");
    }

    private PipelinesErrors$() {
    }
}

