/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.recommendation;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasBlockSize;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.recommendation.ALSModel$;
import org.apache.spark.ml.recommendation.ALSModel$ALSModelReader$;
import org.apache.spark.ml.recommendation.ALSModel$ALSModelWriter$;
import org.apache.spark.ml.recommendation.ALSModelParams;
import org.apache.spark.ml.recommendation.FeatureData;
import org.apache.spark.ml.util.BaseReadWrite;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ArrayImplicits$;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JObject;
import org.json4s.JsonDSL$;
import org.json4s.MonadicJValue$;
import org.sparkproject.guava.collect.Ordering;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\rd\u0001B\u001c9\u0001\rC\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0005\u0016\u0005\tW\u0002\u0011\t\u0011)A\u0005+\"AQ\u000e\u0001BC\u0002\u0013\u0005a\u000e\u0003\u0005u\u0001\t\u0005\t\u0015!\u0003p\u0011!1\bA!b\u0001\n\u00039\b\"CA\n\u0001\t\u0005\t\u0015!\u0003y\u0011%\ti\u0002\u0001BC\u0002\u0013\u0005q\u000fC\u0005\u0002 \u0001\u0011\t\u0011)A\u0005q\"A\u00111\u0005\u0001\u0005\u0002i\n)\u0003\u0003\u0005\u0002$\u0001!\tAOA\u001a\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u0011\u0001\t\u0003\t\u0019\u0005C\u0004\u0002J\u0001!\t!a\u0013\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0004\"CA7\u0001\t\u0007I\u0011BA8\u0011!\ti\b\u0001Q\u0001\n\u0005E\u0004bBA@\u0001\u0011\u0005\u0013\u0011\u0011\u0005\b\u0003[\u0003A\u0011IAX\u0011\u001d\t\u0019\r\u0001C!\u0003\u000bDq!!8\u0001\t\u0003\ny\u000eC\u0004\u0002n\u0002!\t%a<\t\u000f\u0005M\b\u0001\"\u0001\u0002v\"9\u0011Q \u0001\u0005\u0002\u0005}\bb\u0002B\u000b\u0001\u0011\u0005!q\u0003\u0005\b\u0005?\u0001A\u0011\u0001B\u0011\u0011\u001d\u0011\u0019\u0004\u0001C\u0005\u0005kAqAa\u0013\u0001\t\u0013\u0011i\u0005C\u0004\u0003h\u0001!IA!\u001b\t\u0011\t%\u0005\u0001\"\u0011=\u0005\u0017;qA!&9\u0011\u0003\u00119J\u0002\u00048q!\u0005!\u0011\u0014\u0005\b\u0003G\u0001C\u0011\u0001B\\\u0011!\u0011I\f\tC\u0001u\tm\u0006\u0002\u0003BlA\u0011\u0005!H!7\t\u0013\t\u0015\bE1A\u0005\n\t\u001d\b\u0002\u0003BzA\u0001\u0006IA!;\t\u0013\tU\bE1A\u0005\n\t\u001d\b\u0002\u0003B|A\u0001\u0006IA!;\t\u0015\te\bE1A\u0005\u0006a\u0012Y\u0010\u0003\u0005\u0003\u0000\u0002\u0002\u000bQ\u0002B\u007f\u0011!\u0019\t\u0001\tC\u0001q\r\r\u0001bBB\u000eA\u0011\u00053Q\u0004\u0005\b\u0007O\u0001C\u0011IB\u0015\r\u001d\u0019\t\u0004\t\u0001!\u0007gA\u0011b!\u000e.\u0005\u0003\u0005\u000b\u0011\u0002%\t\u000f\u0005\rR\u0006\"\u0001\u00048!91qH\u0017\u0005R\r\u0005cABB#A\u0011\u00199\u0005C\u0004\u0002$E\"\ta!\u0013\t\u0013\r5\u0013G1A\u0005\n\t\u001d\b\u0002CB(c\u0001\u0006IA!;\t\u000f\r\u001d\u0012\u0007\"\u0011\u0004R!I1Q\u000b\u0011\u0002\u0002\u0013%1q\u000b\u0002\t\u00032\u001bVj\u001c3fY*\u0011\u0011HO\u0001\u000fe\u0016\u001cw.\\7f]\u0012\fG/[8o\u0015\tYD(\u0001\u0002nY*\u0011QHP\u0001\u0006gB\f'o\u001b\u0006\u0003\u007f\u0001\u000ba!\u00199bG\",'\"A!\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001!%*\u0014\t\u0004\u000b\u001aCU\"\u0001\u001e\n\u0005\u001dS$!B'pI\u0016d\u0007CA%\u0001\u001b\u0005A\u0004CA%L\u0013\ta\u0005H\u0001\bB\u0019Nku\u000eZ3m!\u0006\u0014\u0018-\\:\u0011\u00059\u000bV\"A(\u000b\u0005AS\u0014\u0001B;uS2L!AU(\u0003\u00155cuK]5uC\ndW-A\u0002vS\u0012,\u0012!\u0016\t\u0003-~s!aV/\u0011\u0005a[V\"A-\u000b\u0005i\u0013\u0015A\u0002\u001fs_>$hHC\u0001]\u0003\u0015\u00198-\u00197b\u0013\tq6,\u0001\u0004Qe\u0016$WMZ\u0005\u0003A\u0006\u0014aa\u0015;sS:<'B\u00010\\Q\r\t1-\u001b\t\u0003I\u001el\u0011!\u001a\u0006\u0003Mr\n!\"\u00198o_R\fG/[8o\u0013\tAWMA\u0003TS:\u001cW-I\u0001k\u0003\u0015\td\u0006\u000e\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007\t\u0019\u0017.\u0001\u0003sC:\\W#A8\u0011\u0005A\fX\"A.\n\u0005I\\&aA%oi\"\u001a1aY5\u0002\u000bI\fgn\u001b\u0011)\u0007\u0011\u0019\u0017.A\u0006vg\u0016\u0014h)Y2u_J\u001cX#\u0001=\u0011\u0007e\fiAD\u0002{\u0003\u000fq1a_A\u0002\u001d\ra\u0018\u0011\u0001\b\u0003{~t!\u0001\u0017@\n\u0003\u0005K!a\u0010!\n\u0005ur\u0014bAA\u0003y\u0005\u00191/\u001d7\n\t\u0005%\u00111B\u0001\ba\u0006\u001c7.Y4f\u0015\r\t)\u0001P\u0005\u0005\u0003\u001f\t\tBA\u0005ECR\fgI]1nK*!\u0011\u0011BA\u0006\u00031)8/\u001a:GC\u000e$xN]:!Q\r1\u0011q\u0003\t\u0004a\u0006e\u0011bAA\u000e7\nIAO]1og&,g\u000e^\u0001\fSR,WNR1di>\u00148/\u0001\u0007ji\u0016lg)Y2u_J\u001c\b\u0005K\u0002\t\u0003/\ta\u0001P5oSRtD#\u0003%\u0002(\u0005-\u0012qFA\u0019\u0011\u0015\u0019\u0016\u00021\u0001VQ\u0011\t9cY5\t\u000b5L\u0001\u0019A8)\t\u0005-2-\u001b\u0005\u0006m&\u0001\r\u0001\u001f\u0005\u0007\u0003;I\u0001\u0019\u0001=\u0015\u0003!\u000b!b]3u+N,'oQ8m)\u0011\tI$a\u000f\u000e\u0003\u0001Aa!!\u0010\f\u0001\u0004)\u0016!\u0002<bYV,\u0007fA\u0006dS\u0006Q1/\u001a;Ji\u0016l7i\u001c7\u0015\t\u0005e\u0012Q\t\u0005\u0007\u0003{a\u0001\u0019A+)\u00071\u0019\u0017.\u0001\ttKR\u0004&/\u001a3jGRLwN\\\"pYR!\u0011\u0011HA'\u0011\u0019\ti$\u0004a\u0001+\"\"QbYA)C\t\t\u0019&A\u00032]Mr\u0003'\u0001\u000btKR\u001cu\u000e\u001c3Ti\u0006\u0014Ho\u0015;sCR,w-\u001f\u000b\u0005\u0003s\tI\u0006\u0003\u0004\u0002>9\u0001\r!\u0016\u0015\u0005\u001d\r\fi&\t\u0002\u0002`\u0005)!G\f\u001a/a\u0005a1/\u001a;CY>\u001c7nU5{KR!\u0011\u0011HA3\u0011\u0019\tid\u0004a\u0001_\"\"qbYA5C\t\tY'A\u00034]Ar\u0003'A\u0004qe\u0016$\u0017n\u0019;\u0016\u0005\u0005E\u0004\u0003BA:\u0003sj!!!\u001e\u000b\t\u0005]\u00141B\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0002|\u0005U$aE+tKJ$UMZ5oK\u00124UO\\2uS>t\u0017\u0001\u00039sK\u0012L7\r\u001e\u0011\u0002\u0013Q\u0014\u0018M\\:g_JlGc\u0001=\u0002\u0004\"9\u0011Q\u0011\nA\u0002\u0005\u001d\u0015a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003\u0013\u000b)\n\u0005\u0004\u0002\f\u00065\u0015\u0011S\u0007\u0003\u0003\u0017IA!a$\u0002\f\t9A)\u0019;bg\u0016$\b\u0003BAJ\u0003+c\u0001\u0001\u0002\u0007\u0002\u0018\u0006\r\u0015\u0011!A\u0001\u0006\u0003\tIJA\u0002`II\nB!a'\u0002\"B\u0019\u0001/!(\n\u0007\u0005}5LA\u0004O_RD\u0017N\\4\u0011\u0007A\f\u0019+C\u0002\u0002&n\u00131!\u00118zQ\u0011\u00112-!+\"\u0005\u0005-\u0016!\u0002\u001a/a9\u0002\u0014a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\t\u0005E\u0016Q\u0018\t\u0005\u0003g\u000bI,\u0004\u0002\u00026*!\u0011qWA\u0006\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tY,!.\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002@N\u0001\r!!-\u0002\rM\u001c\u0007.Z7bQ\u0011\u00192-!\u0015\u0002\t\r|\u0007/\u001f\u000b\u0004\u0011\u0006\u001d\u0007bBAe)\u0001\u0007\u00111Z\u0001\u0006Kb$(/\u0019\t\u0005\u0003\u001b\f\u0019.\u0004\u0002\u0002P*\u0019\u0011\u0011\u001b\u001e\u0002\u000bA\f'/Y7\n\t\u0005U\u0017q\u001a\u0002\t!\u0006\u0014\u0018-\\'ba\"\"AcYAmC\t\tY.A\u00032]Ur\u0003'A\u0003xe&$X-\u0006\u0002\u0002bB\u0019a*a9\n\u0007\u0005\u0015xJ\u0001\u0005N\u0019^\u0013\u0018\u000e^3sQ\u0011)2-!;\"\u0005\u0005-\u0018!B\u0019/m9\u0002\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003UCCAF2\u0002j\u0005!\"/Z2p[6,g\u000e\u001a$pe\u0006cG.V:feN$2\u0001_A|\u0011\u0019\tIp\u0006a\u0001_\u0006Aa.^7Ji\u0016l7\u000f\u000b\u0003\u0018G\u0006u\u0013A\u0006:fG>lW.\u001a8e\r>\u0014Xk]3s'V\u00147/\u001a;\u0015\u000ba\u0014\tA!\u0004\t\u000f\u0005\u0015\u0005\u00041\u0001\u0003\u0004A\"!Q\u0001B\u0005!\u0019\tY)!$\u0003\bA!\u00111\u0013B\u0005\t1\u0011YA!\u0001\u0002\u0002\u0003\u0005)\u0011AAM\u0005\ryFe\r\u0005\u0007\u0003sD\u0002\u0019A8)\ta\u0019'\u0011C\u0011\u0003\u0005'\tQA\r\u00184]A\nAC]3d_6lWM\u001c3G_J\fE\u000e\\%uK6\u001cHc\u0001=\u0003\u001a!1!1D\rA\u0002=\f\u0001B\\;n+N,'o\u001d\u0015\u00053\r\fi&\u0001\fsK\u000e|W.\\3oI\u001a{'/\u0013;f[N+(m]3u)\u0015A(1\u0005B\u0018\u0011\u001d\t)I\u0007a\u0001\u0005K\u0001DAa\n\u0003,A1\u00111RAG\u0005S\u0001B!a%\u0003,\u0011a!Q\u0006B\u0012\u0003\u0003\u0005\tQ!\u0001\u0002\u001a\n\u0019q\f\n\u001b\t\r\tm!\u00041\u0001pQ\u0011Q2M!\u0005\u0002+\u001d,GoU8ve\u000e,g)Y2u_J\u001cVOY:fiR9\u0001Pa\u000e\u0003D\t\u001d\u0003bBAC7\u0001\u0007!\u0011\b\u0019\u0005\u0005w\u0011y\u0004\u0005\u0004\u0002\f\u00065%Q\b\t\u0005\u0003'\u0013y\u0004\u0002\u0007\u0003B\t]\u0012\u0011!A\u0001\u0006\u0003\tIJA\u0002`IUBaA!\u0012\u001c\u0001\u0004A\u0018a\u00024bGR|'o\u001d\u0005\u0007\u0005\u0013Z\u0002\u0019A+\u0002\r\r|G.^7o\u0003=\u0011XmY8n[\u0016tGMR8s\u00032dG#\u0004=\u0003P\tM#q\u000bB.\u0005?\u0012\u0019\u0007\u0003\u0004\u0003Rq\u0001\r\u0001_\u0001\u000bgJ\u001cg)Y2u_J\u001c\bB\u0002B+9\u0001\u0007\u00010\u0001\u0006egR4\u0015m\u0019;peNDaA!\u0017\u001d\u0001\u0004)\u0016aD:sG>+H\u000f];u\u0007>dW/\u001c8\t\r\tuC\u00041\u0001V\u0003=!7\u000f^(viB,HoQ8mk6t\u0007B\u0002B19\u0001\u0007q.A\u0002ok6DaA!\u001a\u001d\u0001\u0004y\u0017!\u00032m_\u000e\\7+\u001b>f\u0003!\u0011Gn\\2lS\u001aLHC\u0002B6\u0005\u0003\u00139\t\u0005\u0004\u0002\f\u00065%Q\u000e\t\ba\n=$1\u000fB=\u0013\r\u0011\th\u0017\u0002\u0007)V\u0004H.\u001a\u001a\u0011\tA\u0014)h\\\u0005\u0004\u0005oZ&!B!se\u0006L\b#\u00029\u0003v\tm\u0004c\u00019\u0003~%\u0019!qP.\u0003\u000b\u0019cw.\u0019;\t\u000f\t\u0015S\u00041\u0001\u0003\u0004B1\u00111RAG\u0005\u000b\u0003b\u0001\u001dB8_\ne\u0004B\u0002B3;\u0001\u0007q.A\u0007fgRLW.\u0019;fINK'0Z\u000b\u0003\u0005\u001b\u00032\u0001\u001dBH\u0013\r\u0011\tj\u0017\u0002\u0005\u0019>tw\r\u000b\u0003\u0001G\u0006E\u0013\u0001C!M'6{G-\u001a7\u0011\u0005%\u00033c\u0002\u0011\u0003\u001c\n\u0005&q\u0015\t\u0004a\nu\u0015b\u0001BP7\n1\u0011I\\=SK\u001a\u0004BA\u0014BR\u0011&\u0019!QU(\u0003\u00155c%+Z1eC\ndW\r\u0005\u0003\u0003*\nMVB\u0001BV\u0015\u0011\u0011iKa,\u0002\u0005%|'B\u0001BY\u0003\u0011Q\u0017M^1\n\t\tU&1\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0005/\u000bQb]3sS\u0006d\u0017N_3ECR\fGC\u0002B_\u0005\u0007\u0014i\rE\u0002q\u0005\u007fK1A!1\\\u0005\u0011)f.\u001b;\t\u000f\t\u0015'\u00051\u0001\u0003H\u0006!A-\u0019;b!\rI%\u0011Z\u0005\u0004\u0005\u0017D$a\u0003$fCR,(/\u001a#bi\u0006DqAa4#\u0001\u0004\u0011\t.A\u0002e_N\u0004BA!+\u0003T&!!Q\u001bBV\u0005A!\u0015\r^1PkR\u0004X\u000f^*ue\u0016\fW.A\beKN,'/[1mSj,G)\u0019;b)\u0011\u00119Ma7\t\u000f\tu7\u00051\u0001\u0003`\u0006\u0019A-[:\u0011\t\t%&\u0011]\u0005\u0005\u0005G\u0014YKA\bECR\f\u0017J\u001c9viN#(/Z1n\u0003\rq\u0015MT\u000b\u0003\u0005S\u0004BAa;\u0003r6\u0011!Q\u001e\u0006\u0005\u0005_\u0014y+\u0001\u0003mC:<\u0017b\u00011\u0003n\u0006!a*\u0019(!\u0003\u0011!%o\u001c9\u0002\u000b\u0011\u0013x\u000e\u001d\u0011\u00029M,\b\u000f]8si\u0016$7i\u001c7e'R\f'\u000f^*ue\u0006$XmZ5fgV\u0011!Q \t\u0006a\nU$\u0011^\u0001\u001egV\u0004\bo\u001c:uK\u0012\u001cu\u000e\u001c3Ti\u0006\u0014Ho\u0015;sCR,w-[3tA\u0005i1m\u001c7mK\u000e$x\f^8q?.$\u0002b!\u0002\u0004\f\r=1\u0011\u0003\t\u0005\u0003\u0017\u001b9!\u0003\u0003\u0004\n\u0005-!AB\"pYVlg\u000eC\u0004\u0004\u000e)\u0002\ra!\u0002\u0002\u0003\u0015DaA!\u0019+\u0001\u0004y\u0007bBB\nU\u0001\u00071QC\u0001\be\u00164XM]:f!\r\u00018qC\u0005\u0004\u00073Y&a\u0002\"p_2,\u0017M\\\u0001\u0005e\u0016\fG-\u0006\u0002\u0004 A!aj!\tI\u0013\r\u0019\u0019c\u0014\u0002\t\u001b2\u0013V-\u00193fe\"\"1fYAu\u0003\u0011aw.\u00193\u0015\u0007!\u001bY\u0003\u0003\u0004\u0004.1\u0002\r!V\u0001\u0005a\u0006$\b\u000e\u000b\u0003-G\u0006%(AD!M'6{G-\u001a7Xe&$XM]\n\u0004[\u0005\u0005\u0018\u0001C5ogR\fgnY3\u0015\t\re2Q\b\t\u0004\u0007wiS\"\u0001\u0011\t\r\rUr\u00061\u0001I\u0003!\u0019\u0018M^3J[BdG\u0003\u0002B_\u0007\u0007Baa!\f1\u0001\u0004)&AD!M'6{G-\u001a7SK\u0006$WM]\n\u0004c\r}ACAB&!\r\u0019Y$M\u0001\nG2\f7o\u001d(b[\u0016\f!b\u00197bgNt\u0015-\\3!)\rA51\u000b\u0005\u0007\u0007[)\u0004\u0019A+\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\re\u0003\u0003\u0002Bv\u00077JAa!\u0018\u0003n\n1qJ\u00196fGRDC\u0001I2\u0002j\"\"qdYAu\u0001")
public class ALSModel
extends Model<ALSModel>
implements ALSModelParams,
MLWritable {
    private final String uid;
    private final int rank;
    private final transient Dataset<Row> userFactors;
    private final transient Dataset<Row> itemFactors;
    private final UserDefinedFunction predict;
    private Param<String> userCol;
    private Param<String> itemCol;
    private Param<String> coldStartStrategy;
    private IntParam blockSize;
    private Param<String> predictionCol;

    public static ALSModel load(String path) {
        return ALSModel$.MODULE$.load(path);
    }

    public static MLReader<ALSModel> read() {
        return ALSModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public String getUserCol() {
        return ALSModelParams.getUserCol$(this);
    }

    @Override
    public String getItemCol() {
        return ALSModelParams.getItemCol$(this);
    }

    @Override
    public Column checkIntegers(Dataset<?> dataset, String colName) {
        return ALSModelParams.checkIntegers$(this, dataset, colName);
    }

    @Override
    public String getColdStartStrategy() {
        return ALSModelParams.getColdStartStrategy$(this);
    }

    @Override
    public final int getBlockSize() {
        return HasBlockSize.getBlockSize$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public Param<String> userCol() {
        return this.userCol;
    }

    @Override
    public Param<String> itemCol() {
        return this.itemCol;
    }

    @Override
    public Param<String> coldStartStrategy() {
        return this.coldStartStrategy;
    }

    @Override
    public void org$apache$spark$ml$recommendation$ALSModelParams$_setter_$userCol_$eq(Param<String> x$1) {
        this.userCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$recommendation$ALSModelParams$_setter_$itemCol_$eq(Param<String> x$1) {
        this.itemCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$recommendation$ALSModelParams$_setter_$coldStartStrategy_$eq(Param<String> x$1) {
        this.coldStartStrategy = x$1;
    }

    @Override
    public final IntParam blockSize() {
        return this.blockSize;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasBlockSize$_setter_$blockSize_$eq(IntParam x$1) {
        this.blockSize = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public int rank() {
        return this.rank;
    }

    public Dataset<Row> userFactors() {
        return this.userFactors;
    }

    public Dataset<Row> itemFactors() {
        return this.itemFactors;
    }

    public ALSModel setUserCol(String value) {
        return (ALSModel)this.set(this.userCol(), value);
    }

    public ALSModel setItemCol(String value) {
        return (ALSModel)this.set(this.itemCol(), value);
    }

    public ALSModel setPredictionCol(String value) {
        return (ALSModel)this.set(this.predictionCol(), value);
    }

    public ALSModel setColdStartStrategy(String value) {
        return (ALSModel)this.set(this.coldStartStrategy(), value);
    }

    public ALSModel setBlockSize(int value) {
        return (ALSModel)this.set(this.blockSize(), BoxesRunTime.boxToInteger((int)value));
    }

    private UserDefinedFunction predict() {
        return this.predict;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema());
        Column validatedUsers = this.checkIntegers(dataset, this.$(this.userCol()));
        Column validatedItems = this.checkIntegers(dataset, this.$(this.itemCol()));
        String validatedInputAlias = Identifiable$.MODULE$.randomUID("__als_validated_input");
        String itemFactorsAlias = Identifiable$.MODULE$.randomUID("__als_item_factors");
        String userFactorsAlias = Identifiable$.MODULE$.randomUID("__als_user_factors");
        Dataset predictions = dataset.withColumns((Seq)new .colon.colon((Object)this.$(this.userCol()), (List)new .colon.colon((Object)this.$(this.itemCol()), (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)validatedUsers, (List)new .colon.colon((Object)validatedItems, (List)Nil$.MODULE$))).alias(validatedInputAlias).join(this.userFactors().alias(userFactorsAlias), functions$.MODULE$.col(validatedInputAlias + "." + this.$(this.userCol())).$eq$eq$eq((Object)functions$.MODULE$.col(userFactorsAlias + ".id")), "left").join(this.itemFactors().alias(itemFactorsAlias), functions$.MODULE$.col(validatedInputAlias + "." + this.$(this.itemCol())).$eq$eq$eq((Object)functions$.MODULE$.col(itemFactorsAlias + ".id")), "left").select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(validatedInputAlias + ".*"), this.predict().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(userFactorsAlias + ".features"), functions$.MODULE$.col(itemFactorsAlias + ".features")})).alias(this.$(this.predictionCol()))}));
        String string = this.getColdStartStrategy();
        String string2 = ALSModel$.MODULE$.org$apache$spark$ml$recommendation$ALSModel$$Drop();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return predictions.na().drop("all", (Seq)new .colon.colon((Object)this.$(this.predictionCol()), (List)Nil$.MODULE$));
        }
        String string4 = ALSModel$.MODULE$.org$apache$spark$ml$recommendation$ALSModel$$NaN();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return predictions;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public StructType transformSchema(StructType schema) {
        SchemaUtils$.MODULE$.checkNumericType(schema, this.$(this.userCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        SchemaUtils$.MODULE$.checkNumericType(schema, this.$(this.itemCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        return SchemaUtils$.MODULE$.appendColumn(schema, this.$(this.predictionCol()), (DataType)FloatType$.MODULE$, SchemaUtils$.MODULE$.appendColumn$default$4());
    }

    @Override
    public ALSModel copy(ParamMap extra) {
        ALSModel copied = new ALSModel(this.uid(), this.rank(), this.userFactors(), this.itemFactors());
        return (ALSModel)((Model)this.copyValues(copied, extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new ALSModelWriter(this);
    }

    @Override
    public String toString() {
        return "ALSModel: uid=" + this.uid() + ", rank=" + this.rank();
    }

    public Dataset<Row> recommendForAllUsers(int numItems) {
        return this.recommendForAll(this.userFactors(), this.itemFactors(), this.$(this.userCol()), this.$(this.itemCol()), numItems, BoxesRunTime.unboxToInt((Object)this.$(this.blockSize())));
    }

    public Dataset<Row> recommendForUserSubset(Dataset<?> dataset, int numItems) {
        Dataset<Row> srcFactorSubset = this.getSourceFactorSubset(dataset, this.userFactors(), this.$(this.userCol()));
        return this.recommendForAll(srcFactorSubset, this.itemFactors(), this.$(this.userCol()), this.$(this.itemCol()), numItems, BoxesRunTime.unboxToInt((Object)this.$(this.blockSize())));
    }

    public Dataset<Row> recommendForAllItems(int numUsers) {
        return this.recommendForAll(this.itemFactors(), this.userFactors(), this.$(this.itemCol()), this.$(this.userCol()), numUsers, BoxesRunTime.unboxToInt((Object)this.$(this.blockSize())));
    }

    public Dataset<Row> recommendForItemSubset(Dataset<?> dataset, int numUsers) {
        Dataset<Row> srcFactorSubset = this.getSourceFactorSubset(dataset, this.itemFactors(), this.$(this.itemCol()));
        return this.recommendForAll(srcFactorSubset, this.userFactors(), this.$(this.itemCol()), this.$(this.userCol()), numUsers, BoxesRunTime.unboxToInt((Object)this.$(this.blockSize())));
    }

    private Dataset<Row> getSourceFactorSubset(Dataset<?> dataset, Dataset<Row> factors, String column) {
        return factors.join(dataset.select(column, (Seq)Nil$.MODULE$), factors.apply("id").$eq$eq$eq((Object)dataset.apply(column)), "left_semi").select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{factors.apply("id"), factors.apply("features")}));
    }

    private Dataset<Row> recommendForAll(Dataset<Row> srcFactors, Dataset<Row> dstFactors, String srcOutputColumn, String dstOutputColumn, int num, int blockSize) {
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator20$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator20$1(ALSModel $outer) {
            }
        }
        String ratingColumn = "rating";
        String recommendColumn = "recommendations";
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator5$1(ALSModel $outer) {
            }
        }
        Dataset<Tuple2<int[], float[]>> srcFactorsBlocked = this.blockify((Dataset<Tuple2<Object, float[]>>)srcFactors.as(srcFactors.sparkSession().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator5$1(null)))), blockSize);
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator10$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator10$1(ALSModel $outer) {
            }
        }
        Dataset<Tuple2<int[], float[]>> dstFactorsBlocked = this.blockify((Dataset<Tuple2<Object, float[]>>)dstFactors.as(srcFactors.sparkSession().implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator10$1(null)))), blockSize);
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator15$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator15$1(ALSModel $outer) {
            }
        }
        Dataset ratings = srcFactorsBlocked.crossJoin(dstFactorsBlocked).as(srcFactors.sparkSession().implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator15$1(null)))).mapPartitions((Function1 & Serializable)iter -> {
            ObjectRef scores = ObjectRef.create(null);
            ObjectRef idxOrd = ObjectRef.create(null);
            return iter.flatMap((Function1 & Serializable)x0$1 -> {
                Tuple4 tuple4 = x0$1;
                if (tuple4 != null) {
                    int[] srcIds = (int[])tuple4._1();
                    float[] srcMat = (float[])tuple4._2();
                    int[] dstIds = (int[])tuple4._3();
                    float[] dstMat = (float[])tuple4._4();
                    Predef$.MODULE$.require(srcMat.length == srcIds.length * this.rank());
                    Predef$.MODULE$.require(dstMat.length == dstIds.length * this.rank());
                    int m = srcIds.length;
                    int n = dstIds.length;
                    if ((float[])scores$1.elem == null || ((float[])scores$1.elem).length < n) {
                        scores$1.elem = (float[])Array$.MODULE$.ofDim(n, (ClassTag)ClassTag$.MODULE$.Float());
                        idxOrd$1.elem = new Ordering<Object>(null, scores){
                            private final ObjectRef scores$1;

                            public int compare(int left, int right) {
                                return scala.package$.MODULE$.Ordering().apply((scala.math.Ordering)Ordering.DeprecatedFloatOrdering$.MODULE$).compare((Object)BoxesRunTime.boxToFloat((float)((float[])this.scores$1.elem)[left]), (Object)BoxesRunTime.boxToFloat((float)((float[])this.scores$1.elem)[right]));
                            }
                            {
                                this.scores$1 = scores$1;
                            }
                        };
                    }
                    return scala.package$.MODULE$.Iterator().range(0, m).flatMap((Function1 & Serializable)i -> ALSModel.$anonfun$recommendForAll$3(this, n, dstMat, srcMat, scores, srcIds, idxOrd, num, dstIds, BoxesRunTime.unboxToInt((Object)i)));
                }
                throw new MatchError((Object)tuple4);
            });
        }, srcFactors.sparkSession().implicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator20$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{srcOutputColumn, dstOutputColumn, ratingColumn}));
        ArrayType arrayType = ArrayType$.MODULE$.apply((DataType)new StructType().add(dstOutputColumn, (DataType)IntegerType$.MODULE$).add(ratingColumn, (DataType)FloatType$.MODULE$));
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        JavaUniverse $u6 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator25$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator25$1(ALSModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator30$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator30$1(ALSModel $outer) {
            }
        }
        return ratings.groupBy(srcOutputColumn, (Seq)Nil$.MODULE$).agg(ALSModel$.MODULE$.collect_top_k(functions$.MODULE$.struct(ratingColumn, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{dstOutputColumn})), num, false), (Seq)Nil$.MODULE$).as(srcFactors.sparkSession().implicits().newProductEncoder(((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator25$1(null)))).map((Function1 & Serializable)t -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)t._1$mcI$sp()), ((IterableOps)t._2()).map((Function1 & Serializable)p -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)p._2$mcI$sp()), p._1()))), srcFactors.sparkSession().implicits().newProductEncoder(((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator30$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{srcOutputColumn, recommendColumn})).withColumn(recommendColumn, functions$.MODULE$.col(recommendColumn).cast((DataType)arrayType));
    }

    private Dataset<Tuple2<int[], float[]>> blockify(Dataset<Tuple2<Object, float[]>> factors, int blockSize) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator5$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator5$2(ALSModel $outer) {
            }
        }
        return factors.mapPartitions((Function1 & Serializable)iter -> iter.grouped(blockSize).map((Function1 & Serializable)block -> new Tuple2(((IterableOnceOps)block.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1._1$mcI$sp()))).toArray((ClassTag)ClassTag$.MODULE$.Int()), ((IterableOnceOps)block.flatMap((Function1 & Serializable)x$2 -> Predef$.MODULE$.wrapFloatArray((float[])x$2._2()))).toArray((ClassTag)ClassTag$.MODULE$.Float()))), factors.sparkSession().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator5$2(null))));
    }

    @Override
    public long estimatedSize() {
        long userCount = this.userFactors().count();
        long itemCount = this.itemFactors().count();
        return (userCount + itemCount) * (long)(this.rank() + 1) * 4L;
    }

    public static final /* synthetic */ float $anonfun$predict$1(ALSModel $this, Seq featuresA, Seq featuresB) {
        if (featuresA != null && featuresB != null) {
            float dotProduct = 0.0f;
            for (int i = 0; i < $this.rank(); ++i) {
                dotProduct += BoxesRunTime.unboxToFloat((Object)featuresA.apply(i)) * BoxesRunTime.unboxToFloat((Object)featuresB.apply(i));
            }
            return dotProduct;
        }
        return Float.NaN;
    }

    public static final /* synthetic */ Tuple3 $anonfun$recommendForAll$4(int srcId$1, int[] dstIds$1, ObjectRef scores$1, int j) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)srcId$1), (Object)BoxesRunTime.boxToInteger((int)dstIds$1[j]), (Object)BoxesRunTime.boxToFloat((float)((float[])scores$1.elem)[j]));
    }

    public static final /* synthetic */ Iterator $anonfun$recommendForAll$3(ALSModel $this, int n$1, float[] dstMat$1, float[] srcMat$1, ObjectRef scores$1, int[] srcIds$1, ObjectRef idxOrd$1, int num$1, int[] dstIds$1, int i) {
        BLAS$.MODULE$.javaBLAS().sgemv("T", $this.rank(), n$1, 1.0f, dstMat$1, 0, $this.rank(), srcMat$1, i * $this.rank(), 1, 0.0f, (float[])scores$1.elem, 0, 1);
        int srcId = srcIds$1[i];
        return CollectionConverters$.MODULE$.ListHasAsScala(((Ordering)idxOrd$1.elem).greatestOf(CollectionConverters$.MODULE$.IteratorHasAsJava(scala.package$.MODULE$.Iterator().range(0, n$1)).asJava(), num$1)).asScala().iterator().map((Function1 & Serializable)j -> ALSModel.$anonfun$recommendForAll$4(srcId, dstIds$1, scores$1, BoxesRunTime.unboxToInt((Object)j)));
    }

    public ALSModel(String uid, int rank, Dataset<Row> userFactors, Dataset<Row> itemFactors) {
        this.uid = uid;
        this.rank = rank;
        this.userFactors = userFactors;
        this.itemFactors = itemFactors;
        HasPredictionCol.$init$(this);
        HasBlockSize.$init$(this);
        ALSModelParams.$init$(this);
        MLWritable.$init$(this);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator1$1(ALSModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator2$1(ALSModel $outer) {
            }
        }
        this.predict = functions$.MODULE$.udf((Function2 & Serializable)(featuresA, featuresB) -> BoxesRunTime.boxToFloat((float)ALSModel.$anonfun$predict$1(this, featuresA, featuresB)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Float(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator2$1(null)));
        Statics.releaseFence();
    }

    public ALSModel() {
        this("", -1, null, null);
    }

    private static class ALSModelReader
    extends MLReader<ALSModel> {
        private final String className = ALSModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public ALSModel load(String path) {
            Tuple2 tuple2;
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
            DefaultFormats$ format = DefaultFormats$.MODULE$;
            int rank = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata.metadata()), "rank")), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            String userPath = new Path(path, "userFactors").toString();
            String itemPath = new Path(path, "itemFactors").toString();
            if (BoxesRunTime.unboxToBoolean((Object)ReadWriteUtils$.MODULE$.localSavingModeState().get())) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ALSModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator1$2
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.recommendation.FeatureData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator1$2(ALSModelReader $outer) {
                    }
                }
                FeatureData[] userFactorsData = (FeatureData[])ReadWriteUtils$.MODULE$.loadArray(userPath, this.sparkSession(), (Function1 & Serializable)dis -> ALSModel$.MODULE$.deserializeData((DataInputStream)dis), ClassTag$.MODULE$.apply(FeatureData.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator1$2(null)));
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ALSModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator2$2
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.recommendation.FeatureData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator2$2(ALSModelReader $outer) {
                    }
                }
                Dataset userFactors = this.sparkSession().createDataFrame((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)userFactorsData).toImmutableArraySeq(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator2$2(null)));
                JavaUniverse $u3 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(ALSModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator3$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.recommendation.FeatureData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator3$1(ALSModelReader $outer) {
                    }
                }
                FeatureData[] itemFactorsData = (FeatureData[])ReadWriteUtils$.MODULE$.loadArray(itemPath, this.sparkSession(), (Function1 & Serializable)dis -> ALSModel$.MODULE$.deserializeData((DataInputStream)dis), ClassTag$.MODULE$.apply(FeatureData.class), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator3$1(null)));
                JavaUniverse $u4 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(ALSModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator4$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.recommendation.FeatureData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator4$1(ALSModelReader $outer) {
                    }
                }
                Dataset itemFactors = this.sparkSession().createDataFrame((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)itemFactorsData).toImmutableArraySeq(), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$ALSModelReader$$typecreator4$1(null)));
                v0 = new Tuple2((Object)userFactors, (Object)itemFactors);
            } else {
                Dataset userFactors = this.sparkSession().read().format("parquet").load(userPath);
                Dataset itemFactors = this.sparkSession().read().format("parquet").load(itemPath);
                v0 = tuple2 = new Tuple2((Object)userFactors, (Object)itemFactors);
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Dataset userFactors = (Dataset)tuple2._1();
            Dataset itemFactors = (Dataset)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)userFactors, (Object)itemFactors);
            Dataset userFactors2 = (Dataset)tuple22._1();
            Dataset itemFactors2 = (Dataset)tuple22._2();
            ALSModel model = new ALSModel(metadata.uid(), rank, (Dataset<Row>)userFactors2, (Dataset<Row>)itemFactors2);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class ALSModelWriter
    extends MLWriter {
        private final ALSModel instance;

        @Override
        public void saveImpl(String path) {
            Tuple2 extraMetadata = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rank"), (Object)BoxesRunTime.boxToInteger((int)this.instance.rank()));
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sparkSession(), (Option<JObject>)new Some((Object)JsonDSL$.MODULE$.pair2jvalue(extraMetadata, (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))));
            String userPath = new Path(path, "userFactors").toString();
            String itemPath = new Path(path, "itemFactors").toString();
            if (BoxesRunTime.unboxToBoolean((Object)ReadWriteUtils$.MODULE$.localSavingModeState().get())) {
                public final class Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator12$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.recommendation.FeatureData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator12$1(ALSModelWriter $outer) {
                    }
                }
                public final class Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator6$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.recommendation.FeatureData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator6$1(ALSModelWriter $outer) {
                    }
                }
                SparkSession sparkSession = BaseReadWrite.sparkSession$(this);
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ALSModelWriter.class.getClassLoader());
                public final class Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator5$3
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.recommendation.FeatureData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator5$3(ALSModelWriter $outer) {
                    }
                }
                FeatureData[] userFactorsData = (FeatureData[])this.instance.userFactors().as(sparkSession.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator5$3(null)))).collect();
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ALSModelWriter.class.getClassLoader());
                ReadWriteUtils$.MODULE$.saveArray(userPath, userFactorsData, sparkSession, (Function2 & Serializable)(data, dos) -> {
                    ALSModel$.MODULE$.serializeData(data, dos);
                    return BoxedUnit.UNIT;
                }, ReadWriteUtils$.MODULE$.saveArray$default$5(), ClassTag$.MODULE$.apply(FeatureData.class), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator6$1(null)));
                JavaUniverse $u3 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(ALSModelWriter.class.getClassLoader());
                public final class Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator11$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.recommendation.FeatureData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator11$1(ALSModelWriter $outer) {
                    }
                }
                FeatureData[] itemFactorsData = (FeatureData[])this.instance.itemFactors().as(sparkSession.implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator11$1(null)))).collect();
                JavaUniverse $u4 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(ALSModelWriter.class.getClassLoader());
                ReadWriteUtils$.MODULE$.saveArray(itemPath, itemFactorsData, sparkSession, (Function2 & Serializable)(data, dos) -> {
                    ALSModel$.MODULE$.serializeData(data, dos);
                    return BoxedUnit.UNIT;
                }, ReadWriteUtils$.MODULE$.saveArray$default$5(), ClassTag$.MODULE$.apply(FeatureData.class), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$ALSModelWriter$$typecreator12$1(null)));
                return;
            }
            this.instance.userFactors().write().format("parquet").save(userPath);
            this.instance.itemFactors().write().format("parquet").save(itemPath);
        }

        public ALSModelWriter(ALSModel instance) {
            this.instance = instance;
        }
    }
}

