/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import org.apache.spark.sql.internal.SqlApiConf$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.FixedLength;
import org.apache.spark.sql.types.MaxLength;
import org.apache.spark.sql.types.NoConstraint$;
import org.apache.spark.sql.types.StringConstraint;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.VarcharType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.math.PartialOrdering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

public final class StringHelper$
implements PartialOrdering<StringConstraint>,
Product {
    public static final StringHelper$ MODULE$ = new StringHelper$();

    static {
        PartialOrdering.$init$((PartialOrdering)MODULE$);
        Product.$init$((Product)MODULE$);
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public boolean lt(Object x, Object y) {
        return PartialOrdering.lt$((PartialOrdering)this, (Object)x, (Object)y);
    }

    public boolean gt(Object x, Object y) {
        return PartialOrdering.gt$((PartialOrdering)this, (Object)x, (Object)y);
    }

    public PartialOrdering<StringConstraint> reverse() {
        return PartialOrdering.reverse$((PartialOrdering)this);
    }

    public Option<Object> tryCompare(StringConstraint x, StringConstraint y) {
        StringConstraint stringConstraint;
        StringConstraint stringConstraint2;
        Tuple2 tuple2 = new Tuple2((Object)x, (Object)y);
        if (tuple2 != null) {
            StringConstraint stringConstraint3 = (StringConstraint)tuple2._1();
            StringConstraint stringConstraint4 = (StringConstraint)tuple2._2();
            if (NoConstraint$.MODULE$.equals(stringConstraint3) && NoConstraint$.MODULE$.equals(stringConstraint4)) {
                return new Some((Object)BoxesRunTime.boxToInteger((int)0));
            }
        }
        if (tuple2 != null && NoConstraint$.MODULE$.equals(stringConstraint2 = (StringConstraint)tuple2._1())) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)-1));
        }
        if (tuple2 != null && NoConstraint$.MODULE$.equals(stringConstraint = (StringConstraint)tuple2._2())) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)1));
        }
        if (tuple2 != null) {
            StringConstraint stringConstraint5 = (StringConstraint)tuple2._1();
            StringConstraint stringConstraint6 = (StringConstraint)tuple2._2();
            if (stringConstraint5 instanceof FixedLength) {
                FixedLength fixedLength = (FixedLength)stringConstraint5;
                int l1 = fixedLength.length();
                if (stringConstraint6 instanceof FixedLength) {
                    FixedLength fixedLength2 = (FixedLength)stringConstraint6;
                    int l2 = fixedLength2.length();
                    return new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.int2Integer(l2).compareTo(Predef$.MODULE$.int2Integer(l1))));
                }
            }
        }
        if (tuple2 != null) {
            StringConstraint stringConstraint7 = (StringConstraint)tuple2._1();
            StringConstraint stringConstraint8 = (StringConstraint)tuple2._2();
            if (stringConstraint7 instanceof FixedLength) {
                MaxLength maxLength;
                int l2;
                FixedLength fixedLength = (FixedLength)stringConstraint7;
                int l1 = fixedLength.length();
                if (stringConstraint8 instanceof MaxLength && l1 <= (l2 = (maxLength = (MaxLength)stringConstraint8).length())) {
                    return new Some((Object)BoxesRunTime.boxToInteger((int)1));
                }
            }
        }
        if (tuple2 != null) {
            StringConstraint stringConstraint9 = (StringConstraint)tuple2._1();
            StringConstraint stringConstraint10 = (StringConstraint)tuple2._2();
            if (stringConstraint9 instanceof MaxLength) {
                FixedLength fixedLength;
                int l2;
                MaxLength maxLength = (MaxLength)stringConstraint9;
                int l1 = maxLength.length();
                if (stringConstraint10 instanceof FixedLength && l1 >= (l2 = (fixedLength = (FixedLength)stringConstraint10).length())) {
                    return new Some((Object)BoxesRunTime.boxToInteger((int)-1));
                }
            }
        }
        if (tuple2 != null) {
            StringConstraint stringConstraint11 = (StringConstraint)tuple2._1();
            StringConstraint stringConstraint12 = (StringConstraint)tuple2._2();
            if (stringConstraint11 instanceof MaxLength) {
                MaxLength maxLength = (MaxLength)stringConstraint11;
                int l1 = maxLength.length();
                if (stringConstraint12 instanceof MaxLength) {
                    MaxLength maxLength2 = (MaxLength)stringConstraint12;
                    int l2 = maxLength2.length();
                    return new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.int2Integer(l2).compareTo(Predef$.MODULE$.int2Integer(l1))));
                }
            }
        }
        return None$.MODULE$;
    }

    public boolean lteq(StringConstraint x, StringConstraint y) {
        return this.tryCompare(x, y).exists((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 <= 0);
    }

    public boolean gteq(StringConstraint x, StringConstraint y) {
        return this.tryCompare(x, y).exists((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 >= 0);
    }

    public boolean equiv(StringConstraint x, StringConstraint y) {
        return this.tryCompare(x, y).contains((Object)BoxesRunTime.boxToInteger((int)0));
    }

    public boolean isPlainString(StringType s) {
        StringConstraint stringConstraint = s.constraint();
        NoConstraint$ noConstraint$ = NoConstraint$.MODULE$;
        return !(stringConstraint != null ? !stringConstraint.equals(noConstraint$) : noConstraint$ != null);
    }

    public boolean isMoreConstrained(StringType a, StringType b) {
        return this.gteq(a.constraint(), b.constraint());
    }

    /*
     * Enabled aggressive block sorting
     */
    public Option<StringType> tightestCommonString(StringType s1, StringType s2) {
        StringType stringType;
        if (s1.collationId() != s2.collationId()) {
            return None$.MODULE$;
        }
        if (!SqlApiConf$.MODULE$.get().preserveCharVarcharTypeInfo()) {
            return new Some((Object)StringType$.MODULE$.apply(s1.collationId()));
        }
        Tuple2 tuple2 = new Tuple2((Object)s1.constraint(), (Object)s2.constraint());
        if (tuple2 != null) {
            StringConstraint stringConstraint = (StringConstraint)tuple2._1();
            StringConstraint stringConstraint2 = (StringConstraint)tuple2._2();
            if (stringConstraint instanceof FixedLength) {
                FixedLength fixedLength = (FixedLength)stringConstraint;
                int l1 = fixedLength.length();
                if (stringConstraint2 instanceof FixedLength) {
                    FixedLength fixedLength2 = (FixedLength)stringConstraint2;
                    int l2 = fixedLength2.length();
                    stringType = new CharType(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(l1), l2));
                    return new Some((Object)stringType);
                }
            }
        }
        if (tuple2 != null) {
            StringConstraint stringConstraint = (StringConstraint)tuple2._1();
            StringConstraint stringConstraint3 = (StringConstraint)tuple2._2();
            if (stringConstraint instanceof MaxLength) {
                MaxLength maxLength = (MaxLength)stringConstraint;
                int l1 = maxLength.length();
                if (stringConstraint3 instanceof FixedLength) {
                    FixedLength fixedLength = (FixedLength)stringConstraint3;
                    int l2 = fixedLength.length();
                    stringType = new VarcharType(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(l1), l2));
                    return new Some((Object)stringType);
                }
            }
        }
        if (tuple2 != null) {
            StringConstraint stringConstraint = (StringConstraint)tuple2._1();
            StringConstraint stringConstraint4 = (StringConstraint)tuple2._2();
            if (stringConstraint instanceof FixedLength) {
                FixedLength fixedLength = (FixedLength)stringConstraint;
                int l1 = fixedLength.length();
                if (stringConstraint4 instanceof MaxLength) {
                    MaxLength maxLength = (MaxLength)stringConstraint4;
                    int l2 = maxLength.length();
                    stringType = new VarcharType(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(l1), l2));
                    return new Some((Object)stringType);
                }
            }
        }
        if (tuple2 != null) {
            StringConstraint stringConstraint = (StringConstraint)tuple2._1();
            StringConstraint stringConstraint5 = (StringConstraint)tuple2._2();
            if (stringConstraint instanceof MaxLength) {
                MaxLength maxLength = (MaxLength)stringConstraint;
                int l1 = maxLength.length();
                if (stringConstraint5 instanceof MaxLength) {
                    MaxLength maxLength2 = (MaxLength)stringConstraint5;
                    int l2 = maxLength2.length();
                    stringType = new VarcharType(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(l1), l2));
                    return new Some((Object)stringType);
                }
            }
        }
        stringType = StringType$.MODULE$.apply(s1.collationId());
        return new Some((Object)stringType);
    }

    public StringType removeCollation(StringType s) {
        StringType stringType = s;
        if (stringType instanceof CharType) {
            CharType charType = (CharType)stringType;
            int length = charType.length();
            return new CharType(length);
        }
        if (stringType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)stringType;
            int length = varcharType.length();
            return new VarcharType(length);
        }
        if (stringType != null) {
            return StringType$.MODULE$;
        }
        throw new MatchError((Object)stringType);
    }

    public String productPrefix() {
        return "StringHelper";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringHelper$;
    }

    public int hashCode() {
        return -83779777;
    }

    public String toString() {
        return "StringHelper";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StringHelper$.class);
    }

    private StringHelper$() {
    }
}

