/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.ui;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.execution.streaming.state.StateStoreCustomMetric;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.streaming.StateOperatorProgress;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.sql.streaming.ui.StreamingQueryTab;
import org.apache.spark.sql.streaming.ui.StreamingQueryUIData;
import org.apache.spark.sql.streaming.ui.UIUtils$;
import org.apache.spark.ui.GraphUIData;
import org.apache.spark.ui.GraphUIData$;
import org.apache.spark.ui.JsCollector;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.util.ArrayImplicits$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0005\u0005Ue!\u0002\n\u0014\u0001My\u0002\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u000bE\u0002A\u0011\u0001\u001a\t\u000fU\u0002!\u0019!C\u0005m!1a\n\u0001Q\u0001\n]Bqa\u0014\u0001C\u0002\u0013%\u0001\u000b\u0003\u0004a\u0001\u0001\u0006I!\u0015\u0005\u0006C\u0002!\tA\u0019\u0005\u0006m\u0002!\te\u001e\u0005\u0006s\u0002!\tA\u001f\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011\u001d\tI\u0002\u0001C\u0001\u00037Aq!a\b\u0001\t\u0003\t\t\u0003C\u0004\u0002H\u0001!\t!!\u0013\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0004bBAA\u0001\u0011\u0005\u00111\u0011\u0005\b\u0003\u001b\u0003A\u0011AAH\u0005q\u0019FO]3b[&tw-U;fef\u001cF/\u0019;jgRL7m\u001d)bO\u0016T!\u0001F\u000b\u0002\u0005UL'B\u0001\f\u0018\u0003%\u0019HO]3b[&twM\u0003\u0002\u00193\u0005\u00191/\u001d7\u000b\u0005iY\u0012!B:qCJ\\'B\u0001\u000f\u001e\u0003\u0019\t\u0007/Y2iK*\ta$A\u0002pe\u001e\u001c2\u0001\u0001\u0011&!\t\t3%D\u0001#\u0015\t!\u0012$\u0003\u0002%E\tIq+\u001a2V\u0013B\u000bw-\u001a\t\u0003M%j\u0011a\n\u0006\u0003Qe\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003U\u001d\u0012q\u0001T8hO&tw-\u0001\u0004qCJ,g\u000e^\u0002\u0001!\tqs&D\u0001\u0014\u0013\t\u00014CA\tTiJ,\u0017-\\5oOF+XM]=UC\n\fa\u0001P5oSRtDCA\u001a5!\tq\u0003\u0001C\u0003,\u0005\u0001\u0007Q&\u0001\ftkB\u0004xN\u001d;fI\u000e+8\u000f^8n\u001b\u0016$(/[2t+\u00059\u0004c\u0001\u001dC\u000b:\u0011\u0011h\u0010\b\u0003uuj\u0011a\u000f\u0006\u0003y1\na\u0001\u0010:p_Rt\u0014\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001\u000b\u0015a\u00029bG.\fw-\u001a\u0006\u0002}%\u00111\t\u0012\u0002\u0004'\u0016\f(B\u0001!B!\t1E*D\u0001H\u0015\tA\u0015*A\u0003ti\u0006$XM\u0003\u0002\u0017\u0015*\u00111jF\u0001\nKb,7-\u001e;j_:L!!T$\u0003-M#\u0018\r^3Ti>\u0014XmQ;ti>lW*\u001a;sS\u000e\fqc];qa>\u0014H/\u001a3DkN$x.\\'fiJL7m\u001d\u0011\u0002)\u0015t\u0017M\u00197fI\u000e+8\u000f^8n\u001b\u0016$(/[2t+\u0005\t\u0006c\u0001*X16\t1K\u0003\u0002U+\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003-\u0006\u000b!bY8mY\u0016\u001cG/[8o\u0013\t\u00195\u000b\u0005\u0002Z=6\t!L\u0003\u0002\\9\u0006!A.\u00198h\u0015\u0005i\u0016\u0001\u00026bm\u0006L!a\u0018.\u0003\rM#(/\u001b8h\u0003U)g.\u00192mK\u0012\u001cUo\u001d;p[6+GO]5dg\u0002\nQcZ3oKJ\fG/\u001a'pC\u0012\u0014Vm]8ve\u000e,7\u000f\u0006\u0002dUB\u0019\u0001H\u00113\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001d\f\u0015a\u0001=nY&\u0011\u0011N\u001a\u0002\u0005\u001d>$W\rC\u0003l\u000f\u0001\u0007A.A\u0004sKF,Xm\u001d;\u0011\u00055$X\"\u00018\u000b\u0005=\u0004\u0018\u0001\u00025uiBT!!\u001d:\u0002\u000fM,'O\u001e7fi*\t1/A\u0004kC.\f'\u000f^1\n\u0005Ut'A\u0005%uiB\u001cVM\u001d<mKR\u0014V-];fgR\faA]3oI\u0016\u0014HCA2y\u0011\u0015Y\u0007\u00021\u0001m\u0003=9WM\\3sCR,G+[7f\u001b\u0006\u0004HCA2|\u0011\u0015a\u0018\u00021\u0001~\u0003\u0015!\u0018.\\3t!\rA$I \t\u0004\u007f\u0006\u0005Q\"A!\n\u0007\u0005\r\u0011I\u0001\u0003M_:<\u0017AF4f]\u0016\u0014\u0018\r^3US6,G+\u001b9TiJLgnZ:\u0015\u0007\r\fI\u0001C\u0004\u0002\f)\u0001\r!!\u0004\u0002\rY\fG.^3t!\u0015y\u0018qBA\n\u0013\r\t\t\"\u0011\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0006\u007f\u0006UaP`\u0005\u0004\u0003/\t%A\u0002+va2,''A\u0010hK:,'/\u0019;f\r>\u0014X.\u0019;uK\u0012$\u0016.\\3USB\u001cFO]5oON$2aYA\u000f\u0011\u001d\tYa\u0003a\u0001\u0003\u001b\tAcZ3oKJ\fG/\u001a+j[\u0016$vNV1mk\u0016\u001cHcA2\u0002$!9\u00111\u0002\u0007A\u0002\u0005\u0015\u0002#B@\u0002\u0010\u0005\u001d\u0002CB@\u0002\u0016y\fI\u0003\u0005\u0005\u0002,\u0005E\u0012QGA\"\u001b\t\tiCC\u0002\u00020q\u000bA!\u001e;jY&!\u00111GA\u0017\u0005\ri\u0015\r\u001d\t\u0005\u0003o\tyD\u0004\u0003\u0002:\u0005m\u0002C\u0001\u001eB\u0013\r\ti$Q\u0001\u0007!J,G-\u001a4\n\u0007}\u000b\tEC\u0002\u0002>\u0005\u00032!WA#\u0013\r\t\u0019AW\u0001\u0012O\u0016tWM]1uK\n\u000b7/[2J]\u001a|GcA2\u0002L!9\u0011QJ\u0007A\u0002\u0005=\u0013AB;j\t\u0006$\u0018\rE\u0002/\u0003#J1!a\u0015\u0014\u0005Q\u0019FO]3b[&tw-U;fef,\u0016\nR1uC\u0006\tr-\u001a8fe\u0006$XmV1uKJl\u0017M]6\u0015\u0013\r\fI&!\u0018\u0002b\u0005\u0015\u0004bBA.\u001d\u0001\u0007\u0011qJ\u0001\u0006cV,'/\u001f\u0005\u0007\u0003?r\u0001\u0019\u0001@\u0002\u00195LgNQ1uG\"$\u0016.\\3\t\r\u0005\rd\u00021\u0001\u007f\u00031i\u0017\r\u001f\"bi\u000eDG+[7f\u0011\u001d\t9G\u0004a\u0001\u0003S\n1B[:D_2dWm\u0019;peB\u0019\u0011%a\u001b\n\u0007\u00055$EA\u0006Kg\u000e{G\u000e\\3di>\u0014\u0018\u0001I4f]\u0016\u0014\u0018\r^3BO\u001e\u0014XmZ1uK\u0012\u001cF/\u0019;f\u001fB,'/\u0019;peN$\"\"a\u001d\u0002z\u0005m\u0014QPA@!\r)\u0017QO\u0005\u0004\u0003o2'A\u0003(pI\u0016\u0014UO\u001a4fe\"9\u00111L\bA\u0002\u0005=\u0003BBA0\u001f\u0001\u0007a\u0010\u0003\u0004\u0002d=\u0001\rA \u0005\b\u0003Oz\u0001\u0019AA5\u0003}9WM\\3sCR,\u0017iZ4sK\u001e\fG/\u001a3DkN$x.\\'fiJL7m\u001d\u000b\u000b\u0003g\n))a\"\u0002\n\u0006-\u0005bBA.!\u0001\u0007\u0011q\n\u0005\u0007\u0003?\u0002\u0002\u0019\u0001@\t\r\u0005\r\u0004\u00031\u0001\u007f\u0011\u001d\t9\u0007\u0005a\u0001\u0003S\n\u0011cZ3oKJ\fG/Z*uCR$\u0016M\u00197f)\u0015\u0019\u0017\u0011SAJ\u0011\u001d\tY&\u0005a\u0001\u0003\u001fBQa[\tA\u00021\u0004")
public class StreamingQueryStatisticsPage
extends WebUIPage
implements Logging {
    private final StreamingQueryTab parent;
    private final scala.collection.immutable.Seq<StateStoreCustomMetric> supportedCustomMetrics;
    private final scala.collection.immutable.Seq<String> enabledCustomMetrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private scala.collection.immutable.Seq<StateStoreCustomMetric> supportedCustomMetrics() {
        return this.supportedCustomMetrics;
    }

    private scala.collection.immutable.Seq<String> enabledCustomMetrics() {
        return this.enabledCustomMetrics;
    }

    public scala.collection.immutable.Seq<Node> generateLoadResources(HttpServletRequest request) {
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("src", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(request, "/static/d3.min.js", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("href", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(request, "/static/streaming-page.css", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("src", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(request, "/static/streaming-page.js", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("type", (Seq)new Text("module"), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("src", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(request, "/static/structured-streaming-page.js", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("type", (Seq)new Text("module"), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        return NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf);
    }

    public scala.collection.immutable.Seq<Node> render(HttpServletRequest request) {
        String parameterId = request.getParameter("id");
        Predef$.MODULE$.require(parameterId != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(parameterId)), (Function0 & Serializable)() -> "Missing id parameter");
        StreamingQueryUIData query = (StreamingQueryUIData)this.parent.store().allQueryUIData().find((Function1 & Serializable)uiData -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryStatisticsPage.$anonfun$render$2(parameterId, uiData))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Failed to find streaming query " + parameterId);
        });
        scala.collection.immutable.Seq<Node> resources = this.generateLoadResources(request);
        scala.collection.immutable.Seq<Node> basicInfo = this.generateBasicInfo(query);
        scala.collection.immutable.Seq content = (scala.collection.immutable.Seq)((IterableOps)resources.$plus$plus(basicInfo)).$plus$plus(this.generateStatTable(query, request));
        return org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage(request, "Streaming Query Statistics", (Function0 & Serializable)() -> content, (SparkUITab)this.parent, org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$5(), org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$6(), org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$7());
    }

    public scala.collection.immutable.Seq<Node> generateTimeMap(scala.collection.immutable.Seq<Object> times) {
        String js = "var timeFormat = {};\n" + ((IterableOnceOps)times.map((Function1 & Serializable)time -> StreamingQueryStatisticsPage.$anonfun$generateTimeMap$1(BoxesRunTime.unboxToLong((Object)time)))).mkString("\n");
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)Unparsed$.MODULE$.apply(js));
        return new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    public scala.collection.immutable.Seq<Node> generateTimeTipStrings(Tuple2<Object, Object>[] values) {
        String js = "var timeTipStrings = {};\n" + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])values), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long batchId = tuple2._1$mcJ$sp();
                long time = tuple2._2$mcJ$sp();
                String formattedTime = org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime(time, 1L, false, org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime$default$4());
                return "timeTipStrings[" + time + "] = 'batch " + batchId + " (" + formattedTime + ")';";
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(String.class))).mkString("\n");
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)Unparsed$.MODULE$.apply(js));
        return new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    public scala.collection.immutable.Seq<Node> generateFormattedTimeTipStrings(Tuple2<Object, Object>[] values) {
        String js = "var formattedTimeTipStrings = {};\n" + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])values), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long batchId = tuple2._1$mcJ$sp();
                long time = tuple2._2$mcJ$sp();
                String formattedTime = org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime(time, 1L, false, org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime$default$4());
                return "formattedTimeTipStrings[\"" + formattedTime + "\"] = 'batch " + batchId + " (" + formattedTime + ")';";
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(String.class))).mkString("\n");
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)Unparsed$.MODULE$.apply(js));
        return new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    public scala.collection.immutable.Seq<Node> generateTimeToValues(Tuple2<Object, Map<String, Long>>[] values) {
        Tuple2[] durationDataPadding = org.apache.spark.ui.UIUtils$.MODULE$.durationDataPadding(values);
        String js = "var formattedTimeToValues = {};\n" + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])durationDataPadding), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long x = tuple2._1$mcJ$sp();
                scala.collection.immutable.Map y = (scala.collection.immutable.Map)tuple2._2();
                String s = ((IterableOnceOps)((IterableOps)y.toSeq().sortBy((Function1 & Serializable)x$2 -> (String)x$2._1(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)e -> "\"" + e._2$mcD$sp() + "\"")).mkString("[", ",", "]");
                String formattedTime = org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime(x, 1L, false, org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime$default$4());
                return "formattedTimeToValues[\"" + formattedTime + "\"] = " + s + ";";
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(String.class))).mkString("\n");
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)Unparsed$.MODULE$.apply(js));
        return new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
    }

    public scala.collection.immutable.Seq<Node> generateBasicInfo(StreamingQueryUIData uiData) {
        String string;
        if (uiData.summary().isActive()) {
            long durationMs = System.currentTimeMillis() - uiData.summary().startTimestamp();
            string = org.apache.spark.ui.UIUtils$.MODULE$.formatDurationVerbose(durationMs);
        } else {
            string = UIUtils$.MODULE$.withNoProgress(uiData, (Function0 & Serializable)() -> {
                String end = uiData.lastProgress().timestamp();
                String start = ((StreamingQueryProgress)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])uiData.recentProgress()))).timestamp();
                return org.apache.spark.ui.UIUtils$.MODULE$.formatDurationVerbose(UIUtils$.MODULE$.parseProgressTimestamp(end) - UIUtils$.MODULE$.parseProgressTimestamp(start));
            }, "-");
        }
        String duration = string;
        String name = UIUtils$.MODULE$.getQueryName(uiData);
        long numBatches = BoxesRunTime.unboxToLong((Object)UIUtils$.MODULE$.withNoProgress(uiData, (JFunction0.mcJ.sp & Serializable)() -> uiData.lastProgress().batchId() + 1L, BoxesRunTime.boxToLong((long)0L)));
        NodeBuffer $buf = new NodeBuffer();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Running batches for\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)duration);
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
        $buf2.$amp$plus((Object)new Text("\n      since\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDate(uiData.summary().startTimestamp()));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
        $buf2.$amp$plus((Object)new Text("\n      ("));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)BoxesRunTime.boxToLong((long)numBatches));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
        $buf2.$amp$plus((Object)new Text(" completed batches)\n    "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        $buf.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        NodeBuffer $buf6 = new NodeBuffer();
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Name: "));
        $buf6.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf7.toVector()));
        $buf6.$amp$plus((Object)name);
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()));
        NodeBuffer $buf8 = new NodeBuffer();
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Id: "));
        $buf8.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf9.toVector()));
        $buf8.$amp$plus((Object)uiData.summary().id());
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf8.toVector()));
        NodeBuffer $buf10 = new NodeBuffer();
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("RunId: "));
        $buf10.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf11.toVector()));
        $buf10.$amp$plus((Object)uiData.summary().runId());
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf10.toVector()));
        $buf.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        return NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf);
    }

    public scala.collection.immutable.Seq<Node> generateWatermark(StreamingQueryUIData query, long minBatchTime, long maxBatchTime, JsCollector jsCollector) {
        Predef$.MODULE$.require(query.lastProgress() != null);
        if (query.lastProgress().eventTime().containsKey("watermark")) {
            Tuple2[] watermarkData = (Tuple2[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)p -> {
                long batchTimestamp = UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp());
                long watermarkValue = UIUtils$.MODULE$.parseProgressTimestamp((String)p.eventTime().get("watermark"));
                if (watermarkValue > 0L) {
                    return new Some((Object)new Tuple2.mcJD.sp(batchTimestamp, (double)(batchTimestamp - watermarkValue) / 1000.0));
                }
                return None$.MODULE$;
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])watermarkData))) {
                double maxWatermark = ((Tuple2)Predef$.MODULE$.wrapRefArray((Object[])watermarkData).maxBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3._2$mcD$sp()), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$))._2$mcD$sp();
                GraphUIData graphUIDataForWatermark = new GraphUIData("watermark-gap-timeline", "watermark-gap-histogram", (scala.collection.immutable.Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)watermarkData).toImmutableArraySeq(), minBatchTime, maxBatchTime, 0.0, maxWatermark, "seconds", GraphUIData$.MODULE$.$lessinit$greater$default$9());
                graphUIDataForWatermark.generateDataJs(jsCollector);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n          "));
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md);
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("\n            "));
                Null$ $md2 = Null$.MODULE$;
                $md2 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md2);
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf4 = new NodeBuffer();
                NodeBuffer $buf5 = new NodeBuffer();
                $buf5.$amp$plus((Object)new Text("Global Watermark Gap "));
                $buf5.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("The gap between batch timestamp and global watermark for the batch.", "right"));
                $buf4.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
                $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
                $buf3.$amp$plus((Object)new Text("\n            "));
                $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
                $buf2.$amp$plus((Object)new Text("\n          "));
                $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
                $buf.$amp$plus((Object)new Text("\n          "));
                Null$ $md3 = Null$.MODULE$;
                $md3 = new UnprefixedAttribute("class", (Seq)new Text("watermark-gap-timeline"), (MetaData)$md3);
                NodeBuffer $buf6 = new NodeBuffer();
                $buf6.$amp$plus((Object)graphUIDataForWatermark.generateTimelineHtml(jsCollector));
                $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()));
                $buf.$amp$plus((Object)new Text("\n          "));
                Null$ $md4 = Null$.MODULE$;
                $md4 = new UnprefixedAttribute("class", (Seq)new Text("watermark-gap-histogram"), (MetaData)$md4);
                NodeBuffer $buf7 = new NodeBuffer();
                $buf7.$amp$plus((Object)graphUIDataForWatermark.generateHistogramHtml(jsCollector));
                $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf7.toVector()));
                $buf.$amp$plus((Object)new Text("\n        "));
                return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
            }
            return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        }
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    public NodeBuffer generateAggregatedStateOperators(StreamingQueryUIData query, long minBatchTime, long maxBatchTime, JsCollector jsCollector) {
        Predef$.MODULE$.require(query.lastProgress() != null);
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])query.lastProgress().stateOperators()))) {
            Tuple2[] numRowsTotalData = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)p -> new Tuple2.mcJD.sp(UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()), (double)BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])p.stateOperators()), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.numRowsTotal()), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))), ClassTag$.MODULE$.apply(Tuple2.class));
            double maxNumRowsTotal = ((Tuple2)Predef$.MODULE$.wrapRefArray((Object[])numRowsTotalData).maxBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)x$5._2$mcD$sp()), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$))._2$mcD$sp();
            Tuple2[] numRowsUpdatedData = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)p -> new Tuple2.mcJD.sp(UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()), (double)BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])p.stateOperators()), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.numRowsUpdated()), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))), ClassTag$.MODULE$.apply(Tuple2.class));
            double maxNumRowsUpdated = ((Tuple2)Predef$.MODULE$.wrapRefArray((Object[])numRowsUpdatedData).maxBy((Function1 & Serializable)x$7 -> BoxesRunTime.boxToDouble((double)x$7._2$mcD$sp()), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$))._2$mcD$sp();
            Tuple2[] numRowsRemovedData = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)p -> new Tuple2.mcJD.sp(UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()), (double)BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])p.stateOperators()), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.numRowsRemoved()), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))), ClassTag$.MODULE$.apply(Tuple2.class));
            double maxNumRowsRemoved = ((Tuple2)Predef$.MODULE$.wrapRefArray((Object[])numRowsRemovedData).maxBy((Function1 & Serializable)x$9 -> BoxesRunTime.boxToDouble((double)x$9._2$mcD$sp()), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$))._2$mcD$sp();
            Tuple2[] memoryUsedBytesData = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)p -> new Tuple2.mcJD.sp(UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()), (double)BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])p.stateOperators()), (Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.memoryUsedBytes()), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))), ClassTag$.MODULE$.apply(Tuple2.class));
            double maxMemoryUsedBytes = ((Tuple2)Predef$.MODULE$.wrapRefArray((Object[])memoryUsedBytesData).maxBy((Function1 & Serializable)x$11 -> BoxesRunTime.boxToDouble((double)x$11._2$mcD$sp()), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$))._2$mcD$sp();
            Tuple2[] numRowsDroppedByWatermarkData = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)p -> new Tuple2.mcJD.sp(UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()), (double)BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])p.stateOperators()), (Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.numRowsDroppedByWatermark()), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))), ClassTag$.MODULE$.apply(Tuple2.class));
            double maxNumRowsDroppedByWatermark = ((Tuple2)Predef$.MODULE$.wrapRefArray((Object[])numRowsDroppedByWatermarkData).maxBy((Function1 & Serializable)x$13 -> BoxesRunTime.boxToDouble((double)x$13._2$mcD$sp()), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$))._2$mcD$sp();
            GraphUIData graphUIDataForNumberTotalRows = new GraphUIData("aggregated-num-total-state-rows-timeline", "aggregated-num-total-state-rows-histogram", (scala.collection.immutable.Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)numRowsTotalData).toImmutableArraySeq(), minBatchTime, maxBatchTime, 0.0, maxNumRowsTotal, "records", GraphUIData$.MODULE$.$lessinit$greater$default$9());
            graphUIDataForNumberTotalRows.generateDataJs(jsCollector);
            GraphUIData graphUIDataForNumberUpdatedRows = new GraphUIData("aggregated-num-updated-state-rows-timeline", "aggregated-num-updated-state-rows-histogram", (scala.collection.immutable.Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)numRowsUpdatedData).toImmutableArraySeq(), minBatchTime, maxBatchTime, 0.0, maxNumRowsUpdated, "records", GraphUIData$.MODULE$.$lessinit$greater$default$9());
            graphUIDataForNumberUpdatedRows.generateDataJs(jsCollector);
            GraphUIData graphUIDataForNumberRemovedRows = new GraphUIData("aggregated-num-removed-state-rows-timeline", "aggregated-num-removed-state-rows-histogram", (scala.collection.immutable.Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)numRowsRemovedData).toImmutableArraySeq(), minBatchTime, maxBatchTime, 0.0, maxNumRowsRemoved, "records", GraphUIData$.MODULE$.$lessinit$greater$default$9());
            graphUIDataForNumberRemovedRows.generateDataJs(jsCollector);
            GraphUIData graphUIDataForMemoryUsedBytes = new GraphUIData("aggregated-state-memory-used-bytes-timeline", "aggregated-state-memory-used-bytes-histogram", (scala.collection.immutable.Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)memoryUsedBytesData).toImmutableArraySeq(), minBatchTime, maxBatchTime, 0.0, maxMemoryUsedBytes, "bytes", GraphUIData$.MODULE$.$lessinit$greater$default$9());
            graphUIDataForMemoryUsedBytes.generateDataJs(jsCollector);
            GraphUIData graphUIDataForNumRowsDroppedByWatermark = new GraphUIData("aggregated-num-rows-dropped-by-watermark-timeline", "aggregated-num-rows-dropped-by-watermark-histogram", (scala.collection.immutable.Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)numRowsDroppedByWatermarkData).toImmutableArraySeq(), minBatchTime, maxBatchTime, 0.0, maxNumRowsDroppedByWatermark, "records", GraphUIData$.MODULE$.$lessinit$greater$default$9());
            graphUIDataForNumRowsDroppedByWatermark.generateDataJs(jsCollector);
            NodeBuffer $buf = new NodeBuffer();
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n          "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n            "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md2);
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf5 = new NodeBuffer();
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("Aggregated Number Of Total State Rows "));
            $buf6.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Aggregated number of total state rows.", "right"));
            $buf5.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()));
            $buf4.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
            $buf4.$amp$plus((Object)new Text("\n            "));
            $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
            $buf2.$amp$plus((Object)new Text("\n          "));
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("class", "aggregated-num-total-state-rows-timeline", (MetaData)$md3);
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)graphUIDataForNumberTotalRows.generateTimelineHtml(jsCollector));
            $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf7.toVector()));
            $buf2.$amp$plus((Object)new Text("\n          "));
            Null$ $md4 = Null$.MODULE$;
            $md4 = new UnprefixedAttribute("class", "aggregated-num-total-state-rows-histogram", (MetaData)$md4);
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus((Object)graphUIDataForNumberTotalRows.generateHistogramHtml(jsCollector));
            $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf8.toVector()));
            $buf2.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
            NodeBuffer $buf9 = new NodeBuffer();
            $buf9.$amp$plus((Object)new Text("\n          "));
            Null$ $md5 = Null$.MODULE$;
            $md5 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md5);
            NodeBuffer $buf10 = new NodeBuffer();
            $buf10.$amp$plus((Object)new Text("\n            "));
            Null$ $md6 = Null$.MODULE$;
            $md6 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md6);
            NodeBuffer $buf11 = new NodeBuffer();
            $buf11.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf12 = new NodeBuffer();
            NodeBuffer $buf13 = new NodeBuffer();
            $buf13.$amp$plus((Object)new Text("Aggregated Number Of Updated State Rows "));
            $buf13.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Aggregated number of updated state rows.", "right"));
            $buf12.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf13.toVector()));
            $buf11.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf12.toVector()));
            $buf11.$amp$plus((Object)new Text("\n            "));
            $buf10.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf11.toVector()));
            $buf10.$amp$plus((Object)new Text("\n          "));
            $buf9.$amp$plus((Object)new Elem(null, "td", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf10.toVector()));
            $buf9.$amp$plus((Object)new Text("\n          "));
            Null$ $md7 = Null$.MODULE$;
            $md7 = new UnprefixedAttribute("class", "aggregated-num-updated-state-rows-timeline", (MetaData)$md7);
            NodeBuffer $buf14 = new NodeBuffer();
            $buf14.$amp$plus((Object)graphUIDataForNumberUpdatedRows.generateTimelineHtml(jsCollector));
            $buf9.$amp$plus((Object)new Elem(null, "td", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf14.toVector()));
            $buf9.$amp$plus((Object)new Text("\n          "));
            Null$ $md8 = Null$.MODULE$;
            $md8 = new UnprefixedAttribute("class", "aggregated-num-updated-state-rows-histogram", (MetaData)$md8);
            NodeBuffer $buf15 = new NodeBuffer();
            $buf15.$amp$plus((Object)graphUIDataForNumberUpdatedRows.generateHistogramHtml(jsCollector));
            $buf9.$amp$plus((Object)new Elem(null, "td", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf15.toVector()));
            $buf9.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf9.toVector()));
            NodeBuffer $buf16 = new NodeBuffer();
            $buf16.$amp$plus((Object)new Text("\n          "));
            Null$ $md9 = Null$.MODULE$;
            $md9 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md9);
            NodeBuffer $buf17 = new NodeBuffer();
            $buf17.$amp$plus((Object)new Text("\n            "));
            Null$ $md10 = Null$.MODULE$;
            $md10 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md10);
            NodeBuffer $buf18 = new NodeBuffer();
            $buf18.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf19 = new NodeBuffer();
            NodeBuffer $buf20 = new NodeBuffer();
            $buf20.$amp$plus((Object)new Text("Aggregated Number Of Removed State Rows"));
            $buf20.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Aggregated number of state rows removed from the state. Normally it means the number of rows evicted from the state because watermark has passed, except in flatMapGroupsWithState, where users can manually remove the state.", "right"));
            $buf19.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf20.toVector()));
            $buf18.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf19.toVector()));
            $buf18.$amp$plus((Object)new Text("\n            "));
            $buf17.$amp$plus((Object)new Elem(null, "div", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf18.toVector()));
            $buf17.$amp$plus((Object)new Text("\n          "));
            $buf16.$amp$plus((Object)new Elem(null, "td", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf17.toVector()));
            $buf16.$amp$plus((Object)new Text("\n          "));
            Null$ $md11 = Null$.MODULE$;
            $md11 = new UnprefixedAttribute("class", "aggregated-num-removed-state-rows-timeline", (MetaData)$md11);
            NodeBuffer $buf21 = new NodeBuffer();
            $buf21.$amp$plus((Object)graphUIDataForNumberRemovedRows.generateTimelineHtml(jsCollector));
            $buf16.$amp$plus((Object)new Elem(null, "td", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf21.toVector()));
            $buf16.$amp$plus((Object)new Text("\n          "));
            Null$ $md12 = Null$.MODULE$;
            $md12 = new UnprefixedAttribute("class", "aggregated-num-removed-state-rows-histogram", (MetaData)$md12);
            NodeBuffer $buf22 = new NodeBuffer();
            $buf22.$amp$plus((Object)graphUIDataForNumberRemovedRows.generateHistogramHtml(jsCollector));
            $buf16.$amp$plus((Object)new Elem(null, "td", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf22.toVector()));
            $buf16.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf16.toVector()));
            NodeBuffer $buf23 = new NodeBuffer();
            $buf23.$amp$plus((Object)new Text("\n          "));
            Null$ $md13 = Null$.MODULE$;
            $md13 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md13);
            NodeBuffer $buf24 = new NodeBuffer();
            $buf24.$amp$plus((Object)new Text("\n            "));
            Null$ $md14 = Null$.MODULE$;
            $md14 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md14);
            NodeBuffer $buf25 = new NodeBuffer();
            $buf25.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf26 = new NodeBuffer();
            NodeBuffer $buf27 = new NodeBuffer();
            $buf27.$amp$plus((Object)new Text("Aggregated State Memory Used In Bytes "));
            $buf27.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Aggregated state memory used in bytes.", "right"));
            $buf26.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf27.toVector()));
            $buf25.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf26.toVector()));
            $buf25.$amp$plus((Object)new Text("\n            "));
            $buf24.$amp$plus((Object)new Elem(null, "div", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf25.toVector()));
            $buf24.$amp$plus((Object)new Text("\n          "));
            $buf23.$amp$plus((Object)new Elem(null, "td", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf24.toVector()));
            $buf23.$amp$plus((Object)new Text("\n          "));
            Null$ $md15 = Null$.MODULE$;
            $md15 = new UnprefixedAttribute("class", "aggregated-state-memory-used-bytes-timeline", (MetaData)$md15);
            NodeBuffer $buf28 = new NodeBuffer();
            $buf28.$amp$plus((Object)graphUIDataForMemoryUsedBytes.generateTimelineHtml(jsCollector));
            $buf23.$amp$plus((Object)new Elem(null, "td", (MetaData)$md15, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf28.toVector()));
            $buf23.$amp$plus((Object)new Text("\n          "));
            Null$ $md16 = Null$.MODULE$;
            $md16 = new UnprefixedAttribute("class", "aggregated-state-memory-used-bytes-histogram", (MetaData)$md16);
            NodeBuffer $buf29 = new NodeBuffer();
            $buf29.$amp$plus((Object)graphUIDataForMemoryUsedBytes.generateHistogramHtml(jsCollector));
            $buf23.$amp$plus((Object)new Elem(null, "td", (MetaData)$md16, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf29.toVector()));
            $buf23.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf23.toVector()));
            NodeBuffer $buf30 = new NodeBuffer();
            $buf30.$amp$plus((Object)new Text("\n          "));
            Null$ $md17 = Null$.MODULE$;
            $md17 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md17);
            NodeBuffer $buf31 = new NodeBuffer();
            $buf31.$amp$plus((Object)new Text("\n            "));
            Null$ $md18 = Null$.MODULE$;
            $md18 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md18);
            NodeBuffer $buf32 = new NodeBuffer();
            $buf32.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf33 = new NodeBuffer();
            NodeBuffer $buf34 = new NodeBuffer();
            $buf34.$amp$plus((Object)new Text("Aggregated Number Of Late Rows Dropped By Watermark "));
            $buf34.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Accumulates all late input rows being dropped in stateful operators by watermark. This only represents the late rows ever reached to stateful operators, not rows from the source. A row could be filtered out at an earlier stage.", "right"));
            $buf33.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf34.toVector()));
            $buf32.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf33.toVector()));
            $buf32.$amp$plus((Object)new Text("\n            "));
            $buf31.$amp$plus((Object)new Elem(null, "div", (MetaData)$md18, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf32.toVector()));
            $buf31.$amp$plus((Object)new Text("\n          "));
            $buf30.$amp$plus((Object)new Elem(null, "td", (MetaData)$md17, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf31.toVector()));
            $buf30.$amp$plus((Object)new Text("\n          "));
            Null$ $md19 = Null$.MODULE$;
            $md19 = new UnprefixedAttribute("class", "aggregated-num-rows-dropped-by-watermark-timeline", (MetaData)$md19);
            NodeBuffer $buf35 = new NodeBuffer();
            $buf35.$amp$plus((Object)graphUIDataForNumRowsDroppedByWatermark.generateTimelineHtml(jsCollector));
            $buf30.$amp$plus((Object)new Elem(null, "td", (MetaData)$md19, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf35.toVector()));
            $buf30.$amp$plus((Object)new Text("\n          "));
            Null$ $md20 = Null$.MODULE$;
            $md20 = new UnprefixedAttribute("class", "aggregated-num-rows-dropped-by-watermark-histogram", (MetaData)$md20);
            NodeBuffer $buf36 = new NodeBuffer();
            $buf36.$amp$plus((Object)graphUIDataForNumRowsDroppedByWatermark.generateHistogramHtml(jsCollector));
            $buf30.$amp$plus((Object)new Elem(null, "td", (MetaData)$md20, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf36.toVector()));
            $buf30.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf30.toVector()));
            NodeBuffer result = $buf;
            Object object = this.enabledCustomMetrics().nonEmpty() ? result.$plus$plus$eq((IterableOnce)this.generateAggregatedCustomMetrics(query, minBatchTime, maxBatchTime, jsCollector)) : BoxedUnit.UNIT;
            return result;
        }
        return new NodeBuffer();
    }

    public NodeBuffer generateAggregatedCustomMetrics(StreamingQueryUIData query, long minBatchTime, long maxBatchTime, JsCollector jsCollector) {
        NodeBuffer result = new NodeBuffer();
        Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])query.lastProgress().stateOperators())));
        ((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(((StateOperatorProgress)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])query.lastProgress().stateOperators()))).customMetrics().keySet()).asScala().filter((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryStatisticsPage.$anonfun$generateAggregatedCustomMetrics$1(this, m)))).map((Function1 & Serializable)metricName -> {
            Tuple2[] data = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)p -> new Tuple2.mcJD.sp(UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()), BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])p.stateOperators()), (Function1 & Serializable)x$14 -> BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Long2long((Long)x$14.customMetrics().get(metricName))), (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$))), ClassTag$.MODULE$.apply(Tuple2.class));
            double max = ((Tuple2)Predef$.MODULE$.wrapRefArray((Object[])data).maxBy((Function1 & Serializable)x$15 -> BoxesRunTime.boxToDouble((double)x$15._2$mcD$sp()), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$))._2$mcD$sp();
            StateStoreCustomMetric metric = (StateStoreCustomMetric)this.supportedCustomMetrics().find((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryStatisticsPage.$anonfun$generateAggregatedCustomMetrics$6(metricName, x$16))).get();
            GraphUIData graphUIData = new GraphUIData("aggregated-" + metricName + "-timeline", "aggregated-" + metricName + "-histogram", (scala.collection.immutable.Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)data).toImmutableArraySeq(), minBatchTime, maxBatchTime, 0.0, max, "", GraphUIData$.MODULE$.$lessinit$greater$default$9());
            graphUIData.generateDataJs(jsCollector);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n            "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n              "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("style", (Seq)new Text("width: 240px;"), (MetaData)$md2);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf4 = new NodeBuffer();
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("Aggregated Custom Metric "));
            $buf5.$amp$plus((Object)String.valueOf(metricName));
            $buf5.$amp$plus((Object)new Text(" "));
            $buf5.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip(metric.desc(), "right"));
            $buf4.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
            $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
            $buf3.$amp$plus((Object)new Text("\n              "));
            $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
            $buf2.$amp$plus((Object)new Text("\n            "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
            $buf.$amp$plus((Object)new Text("\n            "));
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("class", "aggregated-" + metricName + "-timeline", (MetaData)$md3);
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)graphUIData.generateTimelineHtml(jsCollector));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()));
            $buf.$amp$plus((Object)new Text("\n            "));
            Null$ $md4 = Null$.MODULE$;
            $md4 = new UnprefixedAttribute("class", "aggregated-" + metricName + "-histogram", (MetaData)$md4);
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)graphUIData.generateHistogramHtml(jsCollector));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf7.toVector()));
            $buf.$amp$plus((Object)new Text("\n          "));
            return (NodeBuffer)result.$plus$plus$eq((IterableOnce)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector()));
        });
        return result;
    }

    public scala.collection.immutable.Seq<Node> generateStatTable(StreamingQueryUIData query, HttpServletRequest request) {
        Elem elem;
        Tuple2[] batchToTimestamps = (Tuple2[])UIUtils$.MODULE$.withNoProgress(query, (Function0 & Serializable)() -> (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)p -> new Tuple2.mcJJ.sp(p.batchId(), UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp())), ClassTag$.MODULE$.apply(Tuple2.class)), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
        long[] batchTimes = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])batchToTimestamps), (Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17._2$mcJ$sp()), (ClassTag)ClassTag$.MODULE$.Long());
        long minBatchTime = BoxesRunTime.unboxToLong((Object)UIUtils$.MODULE$.withNoProgress(query, (JFunction0.mcJ.sp & Serializable)() -> UIUtils$.MODULE$.parseProgressTimestamp(((StreamingQueryProgress)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()))).timestamp()), BoxesRunTime.boxToLong((long)0L)));
        long maxBatchTime = BoxesRunTime.unboxToLong((Object)UIUtils$.MODULE$.withNoProgress(query, (JFunction0.mcJ.sp & Serializable)() -> UIUtils$.MODULE$.parseProgressTimestamp(query.lastProgress().timestamp()), BoxesRunTime.boxToLong((long)0L)));
        double maxRecordRate = BoxesRunTime.unboxToDouble((Object)UIUtils$.MODULE$.withNoProgress(query, (JFunction0.mcD.sp & Serializable)() -> BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)x$18 -> BoxesRunTime.boxToDouble((double)x$18.inputRowsPerSecond()), (ClassTag)ClassTag$.MODULE$.Double())).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)), BoxesRunTime.boxToDouble((double)0.0)));
        long minRecordRate = 0L;
        double maxProcessRate = BoxesRunTime.unboxToDouble((Object)UIUtils$.MODULE$.withNoProgress(query, (JFunction0.mcD.sp & Serializable)() -> BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)x$19 -> BoxesRunTime.boxToDouble((double)x$19.processedRowsPerSecond()), (ClassTag)ClassTag$.MODULE$.Double())).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)), BoxesRunTime.boxToDouble((double)0.0)));
        long minProcessRate = 0L;
        long maxRows = BoxesRunTime.unboxToLong((Object)UIUtils$.MODULE$.withNoProgress(query, (JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)x$20 -> BoxesRunTime.boxToLong((long)x$20.numInputRows()), (ClassTag)ClassTag$.MODULE$.Long())).max((Ordering)Ordering.Long$.MODULE$)), BoxesRunTime.boxToLong((long)0L)));
        long minRows = 0L;
        long maxBatchDuration = BoxesRunTime.unboxToLong((Object)UIUtils$.MODULE$.withNoProgress(query, (JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)x$21 -> BoxesRunTime.boxToLong((long)x$21.batchDuration()), (ClassTag)ClassTag$.MODULE$.Long())).max((Ordering)Ordering.Long$.MODULE$)), BoxesRunTime.boxToLong((long)0L)));
        long minBatchDuration = 0L;
        Tuple2[] inputRateData = (Tuple2[])UIUtils$.MODULE$.withNoProgress(query, (Function0 & Serializable)() -> (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)p -> new Tuple2.mcJD.sp(UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()), UIUtils$.MODULE$.withNumberInvalid((Function0<Object>)(JFunction0.mcD.sp & Serializable)() -> p.inputRowsPerSecond())), ClassTag$.MODULE$.apply(Tuple2.class)), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2[] processRateData = (Tuple2[])UIUtils$.MODULE$.withNoProgress(query, (Function0 & Serializable)() -> (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)p -> new Tuple2.mcJD.sp(UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()), UIUtils$.MODULE$.withNumberInvalid((Function0<Object>)(JFunction0.mcD.sp & Serializable)() -> p.processedRowsPerSecond())), ClassTag$.MODULE$.apply(Tuple2.class)), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2[] inputRowsData = (Tuple2[])UIUtils$.MODULE$.withNoProgress(query, (Function0 & Serializable)() -> (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)p -> new Tuple2.mcJD.sp(UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()), UIUtils$.MODULE$.withNumberInvalid((Function0<Object>)(JFunction0.mcD.sp & Serializable)() -> p.numInputRows())), ClassTag$.MODULE$.apply(Tuple2.class)), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2[] batchDurations = (Tuple2[])UIUtils$.MODULE$.withNoProgress(query, (Function0 & Serializable)() -> (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)p -> new Tuple2.mcJD.sp(UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp()), UIUtils$.MODULE$.withNumberInvalid((Function0<Object>)(JFunction0.mcD.sp & Serializable)() -> p.batchDuration())), ClassTag$.MODULE$.apply(Tuple2.class)), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2[] operationDurationData = (Tuple2[])UIUtils$.MODULE$.withNoProgress(query, (Function0 & Serializable)() -> (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress()), (Function1 & Serializable)p -> {
            Map durationMs = p.durationMs();
            durationMs.remove("triggerExecution");
            return new Tuple2((Object)BoxesRunTime.boxToLong((long)UIUtils$.MODULE$.parseProgressTimestamp(p.timestamp())), (Object)durationMs);
        }, ClassTag$.MODULE$.apply(Tuple2.class)), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
        JsCollector jsCollector = new JsCollector(request);
        GraphUIData graphUIDataForInputRate = new GraphUIData("input-rate-timeline", "input-rate-histogram", (scala.collection.immutable.Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)inputRateData).toImmutableArraySeq(), minBatchTime, maxBatchTime, (double)minRecordRate, maxRecordRate, "records/sec", GraphUIData$.MODULE$.$lessinit$greater$default$9());
        graphUIDataForInputRate.generateDataJs(jsCollector);
        GraphUIData graphUIDataForProcessRate = new GraphUIData("process-rate-timeline", "process-rate-histogram", (scala.collection.immutable.Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)processRateData).toImmutableArraySeq(), minBatchTime, maxBatchTime, (double)minProcessRate, maxProcessRate, "records/sec", GraphUIData$.MODULE$.$lessinit$greater$default$9());
        graphUIDataForProcessRate.generateDataJs(jsCollector);
        GraphUIData graphUIDataForInputRows = new GraphUIData("input-rows-timeline", "input-rows-histogram", (scala.collection.immutable.Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)inputRowsData).toImmutableArraySeq(), minBatchTime, maxBatchTime, (double)minRows, (double)maxRows, "records", GraphUIData$.MODULE$.$lessinit$greater$default$9());
        graphUIDataForInputRows.generateDataJs(jsCollector);
        GraphUIData graphUIDataForBatchDuration = new GraphUIData("batch-duration-timeline", "batch-duration-histogram", (scala.collection.immutable.Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)batchDurations).toImmutableArraySeq(), minBatchTime, maxBatchTime, (double)minBatchDuration, (double)maxBatchDuration, "ms", GraphUIData$.MODULE$.$lessinit$greater$default$9());
        graphUIDataForBatchDuration.generateDataJs(jsCollector);
        GraphUIData graphUIDataForDuration = new GraphUIData("duration-area-stack", "", (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), 0L, 0L, 0.0, 0.0, "ms", GraphUIData$.MODULE$.$lessinit$greater$default$9());
        if (query.lastProgress() != null) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("style", (Seq)new Text("width: auto"), (MetaData)$md);
            $md = new UnprefixedAttribute("class", (Seq)new Text("table table-bordered"), (MetaData)$md);
            $md = new UnprefixedAttribute("id", (Seq)new Text("stat-table"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n            "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md2);
            $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
            $buf3.$amp$plus((Object)new Text("\n            "));
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("style", (Seq)new Text("width: 492px;"), (MetaData)$md3);
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("Timelines"));
            $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
            $buf3.$amp$plus((Object)new Text("\n            "));
            Null$ $md4 = Null$.MODULE$;
            $md4 = new UnprefixedAttribute("style", (Seq)new Text("width: 350px;"), (MetaData)$md4);
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("Histograms"));
            $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
            $buf2.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
            $buf.$amp$plus((Object)new Text("\n        "));
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("\n            "));
            Null$ $md5 = Null$.MODULE$;
            $md5 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md5);
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus((Object)new Text("\n              "));
            Null$ $md6 = Null$.MODULE$;
            $md6 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md6);
            NodeBuffer $buf9 = new NodeBuffer();
            $buf9.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf10 = new NodeBuffer();
            NodeBuffer $buf11 = new NodeBuffer();
            $buf11.$amp$plus((Object)new Text("Input Rate "));
            $buf11.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("The aggregate (across all sources) rate of data arriving.", "right"));
            $buf10.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf11.toVector()));
            $buf9.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf10.toVector()));
            $buf9.$amp$plus((Object)new Text("\n              "));
            $buf8.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf9.toVector()));
            $buf8.$amp$plus((Object)new Text("\n            "));
            $buf7.$amp$plus((Object)new Elem(null, "td", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf8.toVector()));
            $buf7.$amp$plus((Object)new Text("\n            "));
            Null$ $md7 = Null$.MODULE$;
            $md7 = new UnprefixedAttribute("class", (Seq)new Text("timeline"), (MetaData)$md7);
            NodeBuffer $buf12 = new NodeBuffer();
            $buf12.$amp$plus((Object)graphUIDataForInputRate.generateTimelineHtml(jsCollector));
            $buf7.$amp$plus((Object)new Elem(null, "td", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf12.toVector()));
            $buf7.$amp$plus((Object)new Text("\n            "));
            Null$ $md8 = Null$.MODULE$;
            $md8 = new UnprefixedAttribute("class", (Seq)new Text("histogram"), (MetaData)$md8);
            NodeBuffer $buf13 = new NodeBuffer();
            $buf13.$amp$plus((Object)graphUIDataForInputRate.generateHistogramHtml(jsCollector));
            $buf7.$amp$plus((Object)new Elem(null, "td", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf13.toVector()));
            $buf7.$amp$plus((Object)new Text("\n          "));
            $buf6.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf7.toVector()));
            $buf6.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf14 = new NodeBuffer();
            $buf14.$amp$plus((Object)new Text("\n            "));
            Null$ $md9 = Null$.MODULE$;
            $md9 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md9);
            NodeBuffer $buf15 = new NodeBuffer();
            $buf15.$amp$plus((Object)new Text("\n              "));
            Null$ $md10 = Null$.MODULE$;
            $md10 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md10);
            NodeBuffer $buf16 = new NodeBuffer();
            $buf16.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf17 = new NodeBuffer();
            NodeBuffer $buf18 = new NodeBuffer();
            $buf18.$amp$plus((Object)new Text("Process Rate "));
            $buf18.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("The aggregate (across all sources) rate at which Spark is processing data.", "right"));
            $buf17.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf18.toVector()));
            $buf16.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf17.toVector()));
            $buf16.$amp$plus((Object)new Text("\n              "));
            $buf15.$amp$plus((Object)new Elem(null, "div", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf16.toVector()));
            $buf15.$amp$plus((Object)new Text("\n            "));
            $buf14.$amp$plus((Object)new Elem(null, "td", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf15.toVector()));
            $buf14.$amp$plus((Object)new Text("\n            "));
            Null$ $md11 = Null$.MODULE$;
            $md11 = new UnprefixedAttribute("class", (Seq)new Text("timeline"), (MetaData)$md11);
            NodeBuffer $buf19 = new NodeBuffer();
            $buf19.$amp$plus((Object)graphUIDataForProcessRate.generateTimelineHtml(jsCollector));
            $buf14.$amp$plus((Object)new Elem(null, "td", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf19.toVector()));
            $buf14.$amp$plus((Object)new Text("\n            "));
            Null$ $md12 = Null$.MODULE$;
            $md12 = new UnprefixedAttribute("class", (Seq)new Text("histogram"), (MetaData)$md12);
            NodeBuffer $buf20 = new NodeBuffer();
            $buf20.$amp$plus((Object)graphUIDataForProcessRate.generateHistogramHtml(jsCollector));
            $buf14.$amp$plus((Object)new Elem(null, "td", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf20.toVector()));
            $buf14.$amp$plus((Object)new Text("\n          "));
            $buf6.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf14.toVector()));
            $buf6.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf21 = new NodeBuffer();
            $buf21.$amp$plus((Object)new Text("\n            "));
            Null$ $md13 = Null$.MODULE$;
            $md13 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md13);
            NodeBuffer $buf22 = new NodeBuffer();
            $buf22.$amp$plus((Object)new Text("\n              "));
            Null$ $md14 = Null$.MODULE$;
            $md14 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md14);
            NodeBuffer $buf23 = new NodeBuffer();
            $buf23.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf24 = new NodeBuffer();
            NodeBuffer $buf25 = new NodeBuffer();
            $buf25.$amp$plus((Object)new Text("Input Rows "));
            $buf25.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("The aggregate (across all sources) number of records processed in a trigger.", "right"));
            $buf24.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf25.toVector()));
            $buf23.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf24.toVector()));
            $buf23.$amp$plus((Object)new Text("\n              "));
            $buf22.$amp$plus((Object)new Elem(null, "div", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf23.toVector()));
            $buf22.$amp$plus((Object)new Text("\n            "));
            $buf21.$amp$plus((Object)new Elem(null, "td", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf22.toVector()));
            $buf21.$amp$plus((Object)new Text("\n            "));
            Null$ $md15 = Null$.MODULE$;
            $md15 = new UnprefixedAttribute("class", (Seq)new Text("timeline"), (MetaData)$md15);
            NodeBuffer $buf26 = new NodeBuffer();
            $buf26.$amp$plus((Object)graphUIDataForInputRows.generateTimelineHtml(jsCollector));
            $buf21.$amp$plus((Object)new Elem(null, "td", (MetaData)$md15, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf26.toVector()));
            $buf21.$amp$plus((Object)new Text("\n            "));
            Null$ $md16 = Null$.MODULE$;
            $md16 = new UnprefixedAttribute("class", (Seq)new Text("histogram"), (MetaData)$md16);
            NodeBuffer $buf27 = new NodeBuffer();
            $buf27.$amp$plus((Object)graphUIDataForInputRows.generateHistogramHtml(jsCollector));
            $buf21.$amp$plus((Object)new Elem(null, "td", (MetaData)$md16, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf27.toVector()));
            $buf21.$amp$plus((Object)new Text("\n          "));
            $buf6.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf21.toVector()));
            $buf6.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf28 = new NodeBuffer();
            $buf28.$amp$plus((Object)new Text("\n            "));
            Null$ $md17 = Null$.MODULE$;
            $md17 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md17);
            NodeBuffer $buf29 = new NodeBuffer();
            $buf29.$amp$plus((Object)new Text("\n              "));
            Null$ $md18 = Null$.MODULE$;
            $md18 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md18);
            NodeBuffer $buf30 = new NodeBuffer();
            $buf30.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf31 = new NodeBuffer();
            NodeBuffer $buf32 = new NodeBuffer();
            $buf32.$amp$plus((Object)new Text("Batch Duration "));
            $buf32.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("The process duration of each batch.", "right"));
            $buf31.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf32.toVector()));
            $buf30.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf31.toVector()));
            $buf30.$amp$plus((Object)new Text("\n              "));
            $buf29.$amp$plus((Object)new Elem(null, "div", (MetaData)$md18, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf30.toVector()));
            $buf29.$amp$plus((Object)new Text("\n            "));
            $buf28.$amp$plus((Object)new Elem(null, "td", (MetaData)$md17, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf29.toVector()));
            $buf28.$amp$plus((Object)new Text("\n            "));
            Null$ $md19 = Null$.MODULE$;
            $md19 = new UnprefixedAttribute("class", (Seq)new Text("timeline"), (MetaData)$md19);
            NodeBuffer $buf33 = new NodeBuffer();
            $buf33.$amp$plus((Object)graphUIDataForBatchDuration.generateTimelineHtml(jsCollector));
            $buf28.$amp$plus((Object)new Elem(null, "td", (MetaData)$md19, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf33.toVector()));
            $buf28.$amp$plus((Object)new Text("\n            "));
            Null$ $md20 = Null$.MODULE$;
            $md20 = new UnprefixedAttribute("class", (Seq)new Text("histogram"), (MetaData)$md20);
            NodeBuffer $buf34 = new NodeBuffer();
            $buf34.$amp$plus((Object)graphUIDataForBatchDuration.generateHistogramHtml(jsCollector));
            $buf28.$amp$plus((Object)new Elem(null, "td", (MetaData)$md20, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf34.toVector()));
            $buf28.$amp$plus((Object)new Text("\n          "));
            $buf6.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf28.toVector()));
            $buf6.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf35 = new NodeBuffer();
            $buf35.$amp$plus((Object)new Text("\n            "));
            Null$ $md21 = Null$.MODULE$;
            $md21 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md21);
            NodeBuffer $buf36 = new NodeBuffer();
            $buf36.$amp$plus((Object)new Text("\n              "));
            Null$ $md22 = Null$.MODULE$;
            $md22 = new UnprefixedAttribute("style", (Seq)new Text("width: auto;"), (MetaData)$md22);
            NodeBuffer $buf37 = new NodeBuffer();
            $buf37.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf38 = new NodeBuffer();
            NodeBuffer $buf39 = new NodeBuffer();
            $buf39.$amp$plus((Object)new Text("Operation Duration "));
            $buf39.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("The amount of time taken to perform various operations in milliseconds.", "right"));
            $buf38.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf39.toVector()));
            $buf37.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf38.toVector()));
            $buf37.$amp$plus((Object)new Text("\n              "));
            $buf36.$amp$plus((Object)new Elem(null, "div", (MetaData)$md22, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf37.toVector()));
            $buf36.$amp$plus((Object)new Text("\n            "));
            $buf35.$amp$plus((Object)new Elem(null, "td", (MetaData)$md21, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf36.toVector()));
            $buf35.$amp$plus((Object)new Text("\n            "));
            Null$ $md23 = Null$.MODULE$;
            $md23 = new UnprefixedAttribute("colspan", (Seq)new Text("2"), (MetaData)$md23);
            $md23 = new UnprefixedAttribute("class", (Seq)new Text("duration-area-stack"), (MetaData)$md23);
            NodeBuffer $buf40 = new NodeBuffer();
            $buf40.$amp$plus((Object)graphUIDataForDuration.generateAreaStackHtmlWithData(jsCollector, operationDurationData));
            $buf35.$amp$plus((Object)new Elem(null, "td", (MetaData)$md23, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf40.toVector()));
            $buf35.$amp$plus((Object)new Text("\n          "));
            $buf6.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf35.toVector()));
            $buf6.$amp$plus((Object)new Text("\n          "));
            $buf6.$amp$plus(this.generateWatermark(query, minBatchTime, maxBatchTime, jsCollector));
            $buf6.$amp$plus((Object)new Text("\n          "));
            $buf6.$amp$plus((Object)this.generateAggregatedStateOperators(query, minBatchTime, maxBatchTime, jsCollector));
            $buf6.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()));
            $buf.$amp$plus((Object)new Text("\n      "));
            Elem elem2 = new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
            elem = elem2;
        } else {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("id", (Seq)new Text("empty-streaming-query-message"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            NodeBuffer $buf41 = new NodeBuffer();
            $buf41.$amp$plus((Object)new Text("No visualization information available."));
            $buf.$amp$plus((Object)new Elem(null, "b", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf41.toVector()));
            $buf.$amp$plus((Object)new Text("\n      "));
            Elem elem3 = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
            elem = elem3;
        }
        Elem table = elem;
        return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)((IterableOps)((IterableOps)this.generateTimeToValues(operationDurationData).$plus$plus(this.generateFormattedTimeTipStrings(batchToTimestamps))).$plus$plus(this.generateTimeMap((scala.collection.immutable.Seq<Object>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)batchTimes).toImmutableArraySeq()))).$plus$plus(this.generateTimeTipStrings(batchToTimestamps))).$plus$plus((IterableOnce)table)).$plus$plus((IterableOnce)jsCollector.toHtml());
    }

    public static final /* synthetic */ boolean $anonfun$render$2(String parameterId$1, StreamingQueryUIData uiData) {
        return uiData.summary().runId().equals(parameterId$1);
    }

    public static final /* synthetic */ String $anonfun$generateTimeMap$1(long time) {
        String formattedTime = org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime(time, 1L, false, org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime$default$4());
        return "timeFormat[" + time + "] = '" + formattedTime + "';";
    }

    public static final /* synthetic */ boolean $anonfun$generateAggregatedCustomMetrics$1(StreamingQueryStatisticsPage $this, String m) {
        return $this.enabledCustomMetrics().contains((Object)m.toLowerCase(Locale.ROOT));
    }

    public static final /* synthetic */ boolean $anonfun$generateAggregatedCustomMetrics$6(String metricName$1, StateStoreCustomMetric x$16) {
        return x$16.name().equalsIgnoreCase(metricName$1);
    }

    public StreamingQueryStatisticsPage(StreamingQueryTab parent) {
        this.parent = parent;
        super("statistics");
        Logging.$init$((Logging)this);
        this.supportedCustomMetrics = StateStoreProvider$.MODULE$.create((String)parent.parent().conf().get(SQLConf$.MODULE$.STATE_STORE_PROVIDER_CLASS())).supportedCustomMetrics();
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Supported custom metrics: " + this.supportedCustomMetrics());
        this.enabledCustomMetrics = (scala.collection.immutable.Seq)((IterableOps)parent.parent().conf().get(StaticSQLConf$.MODULE$.ENABLED_STREAMING_UI_CUSTOM_METRIC_LIST())).map((Function1 & Serializable)x$1 -> x$1.toLowerCase(Locale.ROOT));
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Enabled custom metrics: " + this.enabledCustomMetrics());
    }
}

