/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.state;

import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.StreamingSymmetricHashJoinHelper;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.StreamingSymmetricHashJoinHelper$LeftSide$;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.SymmetricHashJoinStateManager$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker$;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class StreamStreamJoinStateHelper$ {
    public static final StreamStreamJoinStateHelper$ MODULE$ = new StreamStreamJoinStateHelper$();

    public StructType readSchema(SparkSession session, String stateCheckpointLocation, int operatorId, StreamingSymmetricHashJoinHelper.JoinSide side, List<Path> oldSchemaFilePaths, boolean excludeAuxColumns) {
        Tuple2<StructType, StructType> tuple2 = this.readKeyValueSchema(session, stateCheckpointLocation, operatorId, side, oldSchemaFilePaths, excludeAuxColumns);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        StructType keySchema = (StructType)tuple2._1();
        StructType valueSchema = (StructType)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)keySchema, (Object)valueSchema);
        StructType keySchema2 = (StructType)tuple22._1();
        StructType valueSchema2 = (StructType)tuple22._2();
        return new StructType().add("key", (DataType)keySchema2).add("value", (DataType)valueSchema2);
    }

    public boolean readSchema$default$6() {
        return true;
    }

    public boolean usesVirtualColumnFamilies(Configuration hadoopConf, String stateCheckpointLocation, int operatorId) {
        int partitionId = StateStore$.MODULE$.PARTITION_ID_TO_CHECK_SCHEMA();
        StateStoreId storeId = new StateStoreId(stateCheckpointLocation, operatorId, partitionId, (String)SymmetricHashJoinStateManager$.MODULE$.allStateStoreNames((Seq<StreamingSymmetricHashJoinHelper.JoinSide>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamingSymmetricHashJoinHelper.JoinSide[]{StreamingSymmetricHashJoinHelper$LeftSide$.MODULE$})).toList().head());
        Path schemaFilePath = StateSchemaCompatibilityChecker$.MODULE$.schemaFile(storeId.storeCheckpointLocation());
        CheckpointFileManager fm = CheckpointFileManager$.MODULE$.create(schemaFilePath, hadoopConf);
        return !fm.exists(schemaFilePath);
    }

    public Tuple2<StructType, StructType> readKeyValueSchema(SparkSession session, String stateCheckpointLocation, int operatorId, StreamingSymmetricHashJoinHelper.JoinSide side, List<Path> oldSchemaFilePaths, boolean excludeAuxColumns) {
        Tuple2 tuple2;
        Configuration newHadoopConf = session.sessionState().newHadoopConf();
        int partitionId = StateStore$.MODULE$.PARTITION_ID_TO_CHECK_SCHEMA();
        List storeNames = SymmetricHashJoinStateManager$.MODULE$.allStateStoreNames((Seq<StreamingSymmetricHashJoinHelper.JoinSide>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamingSymmetricHashJoinHelper.JoinSide[]{side})).toList();
        if (!this.usesVirtualColumnFamilies(newHadoopConf, stateCheckpointLocation, operatorId)) {
            StateStoreId storeIdForKeyToNumValues = new StateStoreId(stateCheckpointLocation, operatorId, partitionId, (String)storeNames.apply(0));
            StateStoreProviderId providerIdForKeyToNumValues = new StateStoreProviderId(storeIdForKeyToNumValues, UUID.randomUUID());
            StateStoreId storeIdForKeyWithIndexToValue = new StateStoreId(stateCheckpointLocation, operatorId, partitionId, (String)storeNames.apply(1));
            StateStoreProviderId providerIdForKeyWithIndexToValue = new StateStoreProviderId(storeIdForKeyWithIndexToValue, UUID.randomUUID());
            StateSchemaCompatibilityChecker manager = new StateSchemaCompatibilityChecker(providerIdForKeyToNumValues, newHadoopConf, oldSchemaFilePaths, StateSchemaCompatibilityChecker$.MODULE$.$lessinit$greater$default$4());
            StructType kSchema = ((StateStoreColFamilySchema)manager.readSchemaFile().head()).keySchema();
            StateSchemaCompatibilityChecker manager2 = new StateSchemaCompatibilityChecker(providerIdForKeyWithIndexToValue, newHadoopConf, oldSchemaFilePaths, StateSchemaCompatibilityChecker$.MODULE$.$lessinit$greater$default$4());
            StructType vSchema = ((StateStoreColFamilySchema)manager2.readSchemaFile().head()).valueSchema();
            v0 = new Tuple2((Object)kSchema, (Object)vSchema);
        } else {
            StateStoreId storeId = new StateStoreId(stateCheckpointLocation, operatorId, partitionId, StateStoreId$.MODULE$.DEFAULT_STORE_NAME());
            StateStoreProviderId providerId = new StateStoreProviderId(storeId, UUID.randomUUID());
            StateSchemaCompatibilityChecker manager = new StateSchemaCompatibilityChecker(providerId, newHadoopConf, oldSchemaFilePaths, StateSchemaCompatibilityChecker$.MODULE$.$lessinit$greater$default$4());
            StructType kSchema = (StructType)manager.readSchemaFile().find((Function1 & Serializable)schema -> BoxesRunTime.boxToBoolean((boolean)StreamStreamJoinStateHelper$.$anonfun$readKeyValueSchema$1(storeNames, schema))).map((Function1 & Serializable)x$2 -> x$2.keySchema()).get();
            StructType vSchema = (StructType)manager.readSchemaFile().find((Function1 & Serializable)schema -> BoxesRunTime.boxToBoolean((boolean)StreamStreamJoinStateHelper$.$anonfun$readKeyValueSchema$3(storeNames, schema))).map((Function1 & Serializable)x$3 -> x$3.valueSchema()).get();
            v0 = tuple2 = new Tuple2((Object)kSchema, (Object)vSchema);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructType keySchema = (StructType)tuple2._1();
        StructType valueSchema = (StructType)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)keySchema, (Object)valueSchema);
        StructType keySchema2 = (StructType)tuple22._1();
        StructType valueSchema2 = (StructType)tuple22._2();
        StructField maybeMatchedColumn = (StructField)valueSchema2.last();
        if (excludeAuxColumns) {
            String string = maybeMatchedColumn.name();
            String string2 = "matched";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                DataType dataType = maybeMatchedColumn.dataType();
                BooleanType$ booleanType$ = BooleanType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(booleanType$) : booleanType$ != null)) {
                    return new Tuple2((Object)keySchema2, (Object)StructType$.MODULE$.apply((Seq)valueSchema2.dropRight(1)));
                }
            }
        }
        return new Tuple2((Object)keySchema2, (Object)valueSchema2);
    }

    public boolean readKeyValueSchema$default$6() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$readKeyValueSchema$1(List storeNames$1, StateStoreColFamilySchema schema) {
        String string = schema.colFamilyName();
        Object object = storeNames$1.apply(0);
        return !(string != null ? !string.equals(object) : object != null);
    }

    public static final /* synthetic */ boolean $anonfun$readKeyValueSchema$3(List storeNames$1, StateStoreColFamilySchema schema) {
        String string = schema.colFamilyName();
        Object object = storeNames$1.apply(1);
        return !(string != null ? !string.equals(object) : object != null);
    }

    private StreamStreamJoinStateHelper$() {
    }
}

